/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.AccountReceiveAndPayableHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;

public abstract class AbstractArApQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractAaApQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"custsupptype", ResManager.loadKDString((String)"\u5ba2\u5546\u7c7b\u578b", (String)"AbstractAaApQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"paymentday", ResManager.loadKDString((String)"\u8d26\u671f", (String)"AbstractAaApQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"count", ResManager.loadKDString((String)"\u7b14\u6570", (String)"AbstractAaApQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"billtype", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AbstractAaApQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"billname", ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"AbstractAaApQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"AbstractAaApQingDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"sort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"AbstractAaApQingDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 12);
        DataSet filter = allDs.filter("billtype in ( " + this.getBillType() + " )");
        DataSet groupDs = filter.groupBy(new String[]{"billtype", "billname", "paymentday", "custsupptype"}).sum("amount").sum("count").finish();
        DataSet totalDs = groupDs.copy().groupBy(new String[]{"billtype", "billname", "paymentday"}).sum("amount").sum("count").finish().addField("'allside'", "custsupptype");
        DataSet union = groupDs.union(totalDs.select(groupDs.getRowMeta().getFieldNames())).addFields(new String[]{"concat(custsupptype, '_' , paymentday)", "case when custsupptype = 'allside' then 1 when custsupptype = 'inside' then 2 when custsupptype = 'outside' then 3 end"}, new String[]{"param", "sort"});
        return ArapDataSetHelper.updateCustsuppTypeAndPaymentDay(union);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> paramMap) {
        String custsupptype = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"custsupptype");
        String paymentday = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"paymentday");
        return AccountReceiveAndPayableHelper.getAfterFilterDataSet((DataSet)ds, (String)custsupptype, (String)paymentday, (int)12, paramMap);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton("amount");
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(this.getLinkFormId());
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(this.getLinkFormId());
        ArapDataSetHelper.setParameterFilter(ids, parameter);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId(this.getLinkFormId());
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("paymentDay", paramMap.get("paymentday"));
        customParams.put("custsupptype", paramMap.get("custsupptype"));
        param.setCustomParams(customParams);
    }

    protected abstract String getLinkFormId();

    protected abstract String getBillType();
}

