/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.arap.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.arap.helper.ArapDataSetHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class ArDistributionQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected String getBillType() {
        return "ar_finarbill";
    }

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"org", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"ArDistributionQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"paymentday", ResManager.loadKDString((String)"\u8d26\u671f", (String)"ArDistributionQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"custsupptype", ResManager.loadKDString((String)"\u5ba2\u5546\u7c7b\u578b", (String)"ArDistributionQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"ArDistributionQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"count", ResManager.loadKDString((String)"\u7b14\u6570", (String)"ArDistributionQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"param", ResManager.loadKDString((String)"\u53c2\u6570", (String)"ArDistributionQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = ArapDataSetHelper.queryArapSummaryData(((Object)((Object)this)).getClass().getName(), paramMap, 12);
        DataSet filter = allDs.filter("billtype = '" + this.getBillType() + "'");
        return filter.groupBy(new String[]{"orgid", "paymentday", "custsupptype"}).sum("amount").sum("count").finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, Map<String, Object> paramMap) {
        String custsuppType = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"custsupptype");
        String paymentDay = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"paymentday");
        dataSet = dataSet.filter("paymentday = '" + paymentDay + "'");
        if (EmptyUtil.isNoEmpty((String)custsuppType) && !"allside".equals(custsuppType)) {
            dataSet = dataSet.filter("custsupptype = '" + custsuppType + "'");
        } else {
            dataSet = dataSet.updateField("custsupptype", "'allside'");
            dataSet = dataSet.groupBy(new String[]{"orgid", "paymentday", "custsupptype"}).sum("amount").sum("count").finish();
        }
        return this.handleDataSet(dataSet, paramMap);
    }

    private DataSet handleDataSet(DataSet dataSet, Map<String, Object> paramMap) {
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(dataSet.getRowMeta());
        }
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String custsuppType = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"custsupptype");
        String paymentDay = TdaCommonHelper.getSelectValue((IPageCache)this.getPageCache(), paramMap, (String)"paymentday");
        dataSet = orgDateSet.leftJoin(dataSet).on("orgid", "orgid").select(new String[]{"orgid", "(case when Len(simplename) > 1 then simplename else orgname end) as org", "rowid", "isgroupnode", "pid", "level", "0  as sumlevel", "'" + paymentDay + "' as paymentday", "'" + custsuppType + "' as custsupptype"}, new String[]{"amount", "count"}).finish();
        dataSet = DecisionAnlsHelper.getSumDataSetByLevel(dataSet, Arrays.asList("amount", "count"), "orgid,org,paymentday,custsupptype").select(new String[]{"amount", "count", "orgid", "org", "paymentday", "custsupptype"}).filter("amount>0");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List orgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        if (EmptyUtil.isEmpty((Collection)orgIds)) {
            orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        }
        dataSet = dataSet.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", orgIds));
        dataSet = dataSet.addField("concat(custsupptype, '_' , paymentday)", "param");
        return ArapDataSetHelper.updateCustsuppTypeAndPaymentDay(dataSet);
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(8, 4);
        }
        return value;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_ar_sumrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "param";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        parameter.setCaption(this.getLinkReportName());
        ArapDataSetHelper.setParameterFilter(ids, parameter);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId("tda_ar_sumrpt");
        param.setCaption(this.getLinkReportName());
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("paymentDay", paramMap.get("paymentday"));
        customParams.put("custsupptype", paramMap.get("custsupptype"));
        param.setCustomParams(customParams);
    }

    protected String getLinkReportName() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u8d26\u6b3e\u5355\u4f4d\u5206\u5e03\u8868", (String)"ArDistributionQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton("amount");
    }
}

