/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bank.form;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class BankDrCrDistListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(BankDrCrDistListPlugin.class);
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String PREFIX = "bankcate_";
    private static final String FILTER_COMPANY = "filter_company";
    private static final String BTN_SHOWALL = "btn_showall";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Object displayType = formShowParameter.getCustomParams().get("displayType");
        LOGGER.info("BankDrCrDistListPlugin.verifyQuery displayType:" + displayType);
        if (EmptyUtil.isEmpty(displayType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u663e\u793a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankCrDrDistListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
            return false;
        }
        queryParam.getFilter().addFilterItem("displayType", displayType);
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_SHOWALL.equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", true);
            this.getView().invokeOperation("refresh");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SHOWALL});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SHOWALL});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString("isgroupnode");
        long orgid = row.getLong(ORGID);
        String fieldName = event.getFieldName();
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith(PREFIX)) {
            ReportShowParameter param = new ReportShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
            long parentId = ((DynamicObject)((DynamicObjectCollection)paramMap.get(FILTER_COMPANY)).get(0)).getLong("id");
            param.getCustomParams().put("parent_id", Long.toString(parentId));
            if (EmptyUtil.isEmpty((Long)orgid)) {
                param.getCustomParams().put("current_org_id", Long.toString(parentId));
            } else {
                param.getCustomParams().put("current_org_id", Long.toString(orgid));
            }
            param.getCustomParams().put("displayType", paramMap.get("displayType"));
            if (this.getView().getFormShowParameter().getCustomParams().get("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            }
            param.setFormId("tda_bankotherdistrpt");
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        if (EmptyUtil.isEmpty((Long)orgid) || !"1".equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportShowParameter param = new ReportShowParameter();
        param.setCaption(formShowParameter.getCaption());
        param.getCustomParams().put(ORGID, Long.toString(orgid));
        Object displayType = formShowParameter.getCustomParams().get("displayType");
        LOGGER.info("BankDrCrDistListPlugin.hyperLinkClick displayType:" + displayType);
        param.getCustomParams().put("displayType", displayType);
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(this.getView().getFormShowParameter().getFormId());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString("isgroupnode");
        Object formatValue = packageDataEvent.getFormatValue();
        String fieldKey = ((ReportColumn)packageDataEvent.getSource()).getFieldKey();
        if (fieldKey.startsWith(PREFIX)) {
            return;
        }
        if (formatValue != null && !"1".equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(fieldKey);
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        ReportView reportView = (ReportView)this.getView();
        ReportListModel reportModel = (ReportListModel)reportView.getReportList().getReportModel();
        List reportColumnList = reportModel.getReportTaskResult().getReportColumnList();
        Set columns = reportColumnList.stream().map(ReportColumn::getFieldKey).collect(Collectors.toSet());
        for (String fieldKey : columns) {
            this.addCellStyleRule(cellStyleRules, fieldKey, "red", "sumlevel = '3'");
        }
        columns.remove("mixorgname");
        String condition = "sumlevel = '3' and %s = '0.00'";
        for (String fieldKey : columns) {
            this.addCellStyleRule(cellStyleRules, fieldKey, "white", String.format(condition, fieldKey));
        }
        super.setCellStyleRules(cellStyleRules);
    }

    private void addCellStyleRule(List<CellStyleRule> cellStyleRules, String fieldKey, String foreColor, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(fieldKey);
        cellStyleRule.setForeColor(foreColor);
        cellStyleRule.setBackgroundColor("white");
        cellStyleRule.setDegree(100);
        cellStyleRule.setCondition(condition);
        cellStyleRules.add(cellStyleRule);
    }
}

