/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class AcctDisplayByBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String DISPLAY_TYPE = "displayType";
    private static final String OPENORG = "openorg";
    private static final String BANKCATE = "bankcate";
    private static final String PREFIX = "bankcate_";
    private static final String FINCOMP_ID = TdaFinOrgTypeEnum.FINCOMP.getValue();
    private static final String SETTLE_ID = TdaFinOrgTypeEnum.CLEARINGHOUSE.getValue();
    private static final String TRDPARTPAY_ID = TdaFinOrgTypeEnum.TRDPARTPAY.getValue();
    private static final String OTHERACCT_ID = TdaFinOrgTypeEnum.OTHERACCT.getValue();
    private static final String OHTERBANK_ID = "0";
    private static final String STAT = "stat";
    private static final String ROWID = "rowid";
    public static final int TOP_NUMBER = 15;

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        DataSet allAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap).select("bankaccountnumber,finorgtype,org openorg,bankcate,bankname, case when areas = 'domestic' then '1' else '0' end as isdomestic");
        return allAcctSet.orderBy(new String[]{OPENORG});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet allAcctSet, ReportQueryParam queryParam) {
        DataSet unionSet;
        Map paramMap = this.transQueryParam(queryParam);
        Map customParam = queryParam.getCustomParam();
        String displayType = null;
        if (EmptyUtil.isNoEmpty((Object)customParam)) {
            displayType = (String)customParam.get(DISPLAY_TYPE);
        }
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue(displayType);
        allAcctSet = DecisionAnlsHelper.getAcctSetByType(allAcctSet, displayByBankTypeEnum);
        DataSet[] allAcctSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(allAcctSet);
        Pair<DataSet, DataSet> splitDataSet = DecisionAnlsHelper.splitTopBank(allAcctSets[0], 15);
        DataSet topBankAcctSet = (DataSet)splitDataSet.getValue0();
        Set<String> topBankCate = DecisionAnlsHelper.getTopBanks(topBankAcctSet.copy(), BANKCATE);
        this.getQueryParam().getCustomParam().put("topBankCate", topBankCate);
        Boolean hasOtherBank = Boolean.FALSE;
        if (!((DataSet)splitDataSet.getValue1()).isEmpty()) {
            hasOtherBank = Boolean.TRUE;
            DataSet otherBankSet = (DataSet)splitDataSet.getValue1();
            DataSet nonTopBankAcctSet = otherBankSet.copy().updateField(BANKCATE, OHTERBANK_ID);
            unionSet = topBankAcctSet.union(new DataSet[]{otherBankSet, nonTopBankAcctSet});
        } else {
            unionSet = topBankAcctSet;
        }
        unionSet = unionSet.union(BankAcctHelper.getUnBankAcctSet(allAcctSets));
        DataSet groupSet = unionSet.groupBy(new String[]{OPENORG, BANKCATE}).count("count").finish();
        DataSet result = this.ChangeRowToColDataSet(groupSet, BANKCATE, OPENORG, PREFIX);
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = AcctDisplayByBankDataListPlugin.getSumField(result);
        List<String> selectField = AcctDisplayByBankDataListPlugin.getSelectField(sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(result).on(ROWID, OPENORG).select(selectField.toArray(new String[0])).finish();
        DataSet resultSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "orgname,mixorgname,sortcode");
        sumField.remove("bankcate_0");
        resultSet = resultSet.addField(String.join((CharSequence)"+", sumField), STAT).addField("'groupcol'", "groupcol");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        resultSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? resultSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : resultSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat > 0");
        sumField.add(STAT);
        if (hasOtherBank.booleanValue()) {
            sumField.add("bankcate_0");
        }
        DataSet totalSet = this.addSubTotalDataSet(resultSet, Collections.singletonList("groupcol"), sumField, "orgname").updateField("mixorgname", ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"AcctDisplayByBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        resultSet = resultSet.orderBy(new String[]{"sortcode"});
        return resultSet.union(totalSet);
    }

    private static List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }

    private Map<String, String> getTopBankType(AcctDisplayByBankTypeEnum displayByBankTypeEnum, Map<String, Object> paramMap) {
        Set<String> amFinOrgTypeConfigs;
        DataSet allAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap).select("bankaccountnumber,finorgtype,org openorg,bankcate,bankname, case when areas = 'domestic' then '1' else '0' end as isdomestic");
        DataSet bankAcctSet = DecisionAnlsHelper.getAcctByType(allAcctSet, displayByBankTypeEnum);
        Map<String, String> topBank = DecisionAnlsHelper.getTopBankCate(bankAcctSet.copy(), 0);
        topBank.put(OHTERBANK_ID, ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"AcctDisplayByBankDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
        if (displayByBankTypeEnum == AcctDisplayByBankTypeEnum.ALL || displayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC) {
            topBank.put(FINCOMP_ID, ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8", (String)"AcctDisplayByBankDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        if ((amFinOrgTypeConfigs = BankAcctHelper.getAmFinOrgTypeConfigs()).contains(TdaFinOrgTypeEnum.CLEARINGHOUSE.getValue())) {
            topBank.put(SETTLE_ID, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"AcctDisplayByBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        if (amFinOrgTypeConfigs.contains(TdaFinOrgTypeEnum.TRDPARTPAY.getValue())) {
            topBank.put(TRDPARTPAY_ID, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8d26\u6237", (String)"AcctDisplayByBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        if (amFinOrgTypeConfigs.contains(TdaFinOrgTypeEnum.OTHERACCT.getValue())) {
            topBank.put(OTHERACCT_ID, ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784", (String)"AcctDisplayByBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        return topBank;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map paramMap = this.transQueryParam(this.getQueryParam());
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
        Map<String, String> topBank = this.getTopBankType(displayByBankTypeEnum, paramMap);
        Set topBankCate = (Set)this.getQueryParam().getCustomParam().get("topBankCate");
        topBankCate.addAll(Arrays.asList(FINCOMP_ID, SETTLE_ID, TRDPARTPAY_ID, OTHERACCT_ID));
        Boolean isShowAll = (Boolean)this.getQueryParam().getCustomParam().get("isShowAll");
        for (Map.Entry<String, String> topBankEntry : topBank.entrySet()) {
            String fieldKey = PREFIX + topBankEntry.getKey();
            ReportColumn newCol = new ReportColumn();
            newCol.setFieldKey(fieldKey);
            newCol.setFieldType("integer");
            newCol.setZeroShow(true);
            newCol.setCaption(new LocaleString(topBankEntry.getValue()));
            if (topBankEntry.getKey().equals(OHTERBANK_ID)) {
                newCol.setHyperlink(true);
            }
            String bankCate = topBankEntry.getKey();
            if (!topBankCate.isEmpty() && !topBankCate.contains(bankCate)) {
                if (isShowAll != null && isShowAll.booleanValue()) {
                    newCol.setHide(false);
                    if (OHTERBANK_ID.equals(bankCate)) {
                        newCol.setHide(true);
                    }
                } else {
                    newCol.setHide(true);
                    if (OHTERBANK_ID.equals(bankCate)) {
                        newCol.setHide(false);
                    }
                }
            }
            columns.add((AbstractReportColumn)newCol);
        }
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey(STAT);
        newCol.setFieldType("integer");
        newCol.setZeroShow(true);
        newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AcctDisplayByBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)newCol);
        return columns;
    }
}

