/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class AcctDisplayByOtherBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    public static final String DISPLAY_TYPE = "displayType";
    public static final String PARENT_ORG = "parentorg";
    public static final String BANKNAME = "bankname";
    public static final String ACCTNUM = "acctnum";
    public static final String GROUPCOL = "groupcol";

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        String parentorg = (String)paramMap.get(PARENT_ORG);
        String orgViewNumber = ((DynamicObject)paramMap.get("orgview")).getString("number");
        List<Long> orgIds = Collections.singletonList(Long.valueOf(parentorg));
        List parentAllOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, orgIds, (boolean)true);
        paramMap.put("allorgids", parentAllOrgIds);
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
        DataSet allAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap).select("bankaccountnumber,finorgtype,org openorg,bankcate,bankname, case when areas = 'domestic' then '1' else '0' end as isdomestic");
        DataSet bankAcctSet = DecisionAnlsHelper.getAcctByType(allAcctSet, displayByBankTypeEnum);
        Pair<DataSet, DataSet> splitDataSet = DecisionAnlsHelper.splitTopBank(bankAcctSet, 15);
        DataSet nonTopBankAcctSet = (DataSet)splitDataSet.getValue1();
        return nonTopBankAcctSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DynamicObject company;
        Map paramMap = this.transQueryParam(queryParam);
        List allOrgIds = (List)paramMap.get("allorgids");
        String parentorg = (String)paramMap.get(PARENT_ORG);
        if (parentorg.equals((company = (DynamicObject)((DynamicObjectCollection)paramMap.get("filter_company")).get(0)).getString("id")) && allOrgIds.size() > 1) {
            allOrgIds.remove(Long.valueOf(parentorg));
        }
        ds = ds.filter("openorg in filterOrg", Collections.singletonMap("filterOrg", allOrgIds));
        DataSet groupSet = ds.select(BANKNAME).groupBy(new String[]{BANKNAME}).count(ACCTNUM).finish().addField("'groupcol'", GROUPCOL);
        DataSet totalSet = this.addSubTotalDataSet(groupSet, Collections.singletonList(GROUPCOL), Collections.singletonList(ACCTNUM), BANKNAME).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"AcctDisplayByOtherBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        return groupSet.addField("'0'", "istotal").union(totalSet.addField("'1'", "istotal"));
    }
}

