/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctByAreaDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ORG_NAME = "org_name";
    private static final String BANK_ACCTS = "bankaccts";
    private static final String COMPANY_ACCTS = "companyaccts";
    private static final String ACCTS = "accts";
    private static final String DOMESTIC_OTHER = "domestic_other1";
    private static final String DOMESTIC_SUBTOTAL = "domestic_subtotal";
    private static final String OVERSEAS_OTHER = "overseas_other1";
    private static final String OVERSEAS_SUBTOTAL = "overseas_subtotal";
    private static final String DOMESTIC_PREFIX = "domestic_";
    private static final String OVERSEAS_PREFIX = "overseas_";
    private static final String ALL_AREA = "allArea";
    private static List<String> COUNT_FIELDS = Arrays.asList("domestic_basic", "domestic_normal", "domestic_spcl", "overseas_basic", "overseas_normal", "overseas_spcl");

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map reportQueryMap = this.transQueryParam(reportQueryParam);
        DataSet query = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), reportQueryMap);
        return query.select(new String[]{"org", "acctstyle", "areas", "finorgtype", "bankcate"});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        RowMeta rowMeta = ds.getRowMeta();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        Map reportQueryMap = this.transQueryParam(queryParam);
        ds = this.processDataSet(ds, reportQueryMap);
        List subOrgIds = EmptyUtil.isNoEmpty(reportQueryMap.get("suborgids")) ? (List)reportQueryMap.get("suborgids") : (List)reportQueryMap.get("allorgids");
        DataSet sumResultSet = ds;
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumResultSet = sumResultSet.where("org in ids", Collections.singletonMap("ids", subOrgIds));
        }
        List<String> domesticFields = this.getSumFields(sumResultSet, DOMESTIC_PREFIX);
        List<String> overseasFields = this.getSumFields(sumResultSet, OVERSEAS_PREFIX);
        sumResultSet = sumResultSet.addField(String.join((CharSequence)"+", this.getOtherSumFields(domesticFields)), DOMESTIC_OTHER);
        sumResultSet = sumResultSet.addField(String.join((CharSequence)"+", domesticFields), DOMESTIC_SUBTOTAL);
        sumResultSet = sumResultSet.addField(String.join((CharSequence)"+", this.getOtherSumFields(overseasFields)), OVERSEAS_OTHER);
        sumResultSet = sumResultSet.addField(String.join((CharSequence)"+", overseasFields), OVERSEAS_SUBTOTAL);
        String join = String.join((CharSequence)"+", Arrays.stream((sumResultSet = sumResultSet.addField("domestic_subtotal + overseas_subtotal", BANK_ACCTS)).getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith("bankcate_")).collect(Collectors.toSet()));
        sumResultSet = EmptyUtil.isNoEmpty((String)join) ? sumResultSet.addField("bankaccts + " + join, ACCTS) : sumResultSet.addField(BANK_ACCTS, ACCTS);
        List<String> allArea = this.getSumFields(sumResultSet, ALL_AREA);
        allArea.addAll(Arrays.asList(BANK_ACCTS, ACCTS));
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(sumResultSet, allArea, ORG_NAME);
        if (Arrays.asList(sumResultSet.getRowMeta().getFieldNames()).contains("sortcode")) {
            sumResultSet = sumResultSet.orderBy(new String[]{"sortcode"});
        }
        DataSet resultSet = sumResultSet.union(totalDataSet);
        String companyField = "bankcate_" + TdaFinOrgTypeEnum.FINCOMP.getValue();
        resultSet = resultSet.getRowMeta().getFieldIndex(companyField, false) < 0 ? resultSet.addField("0", COMPANY_ACCTS) : resultSet.addField(companyField, COMPANY_ACCTS);
        return resultSet.filter("accts != 0 and accts != null");
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        this.getAllColumns().stream().filter(column -> !COUNT_FIELDS.contains(column)).forEach(column -> columns.add((AbstractReportColumn)this.createColumn((String)column, (String)column, true)));
        List amFinOrgTypeConfigs = BankAcctHelper.getAmFinOrgTypeConfigs().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        int index = 5;
        for (String finOrgTypeValue : amFinOrgTypeConfigs) {
            String name = TdaFinOrgTypeEnum.getName((String)finOrgTypeValue);
            columns.add(index, (AbstractReportColumn)this.createColumn("bankcate_" + finOrgTypeValue, name, false));
        }
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption, boolean isHide) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("integer");
        reportColumn.setZeroShow(true);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setHide(isHide);
        return reportColumn;
    }

    private DataSet processDataSet(DataSet ds, Map<String, Object> reportQueryMap) {
        DataSet[] splitDataSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(ds);
        DataSet bankAcctSet = splitDataSets[0].filter("acctstyle in acctstyles", Collections.singletonMap("acctstyles", this.getAcctStyleItems())).select(new String[]{"org", "concat(areas,concat('_',acctstyle)) as acctstyle"}).addField("1", "count").groupBy(new String[]{"org", "acctstyle"}).sum("count").finish();
        bankAcctSet = DecisionAnlsHelper.ChangeRowToColDataSet(bankAcctSet, "acctstyle", "org", "");
        bankAcctSet = DecisionAnlsHelper.addAbsentFields(bankAcctSet, this.getAllColumns());
        DataSet unBankAcctSet = BankAcctHelper.getUnBankAcctSet(splitDataSets);
        unBankAcctSet = unBankAcctSet.select(new String[]{"org", "bankcate"}).addField("1", "count").groupBy(new String[]{"org", "bankcate"}).sum("count").finish();
        unBankAcctSet = DecisionAnlsHelper.ChangeRowToColDataSet(unBankAcctSet, "bankcate", "org", "bankcate_");
        Long orgViewId = ((DynamicObject)reportQueryMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDataSet = orgDateSet.leftJoin(bankAcctSet).on("org", "org").select(new String[]{"org", "rowid", "pid", "isgroupnode", "level", "mixorgname as org_name", "sortcode"}, this.getSumFields(bankAcctSet, ALL_AREA).toArray(new String[0])).finish();
        leftJoinDataSet = leftJoinDataSet.leftJoin(unBankAcctSet).on("org", "org").select(leftJoinDataSet.getRowMeta().getFieldNames(), (String[])Arrays.stream(unBankAcctSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith("bankcate_")).toArray(String[]::new)).finish().addField("0", "sumlevel");
        List<String> sumFields = this.getSumFields(leftJoinDataSet, ALL_AREA);
        return DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDataSet, sumFields, "org,org_name,sortcode");
    }

    private List<String> getSumFields(DataSet dataSet, String areaType) {
        Set sumFields;
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        switch (areaType) {
            case "domestic_": {
                sumFields = Arrays.stream(fieldNames).filter(fieldName -> fieldName.startsWith(DOMESTIC_PREFIX)).collect(Collectors.toSet());
                break;
            }
            case "overseas_": {
                sumFields = Arrays.stream(fieldNames).filter(fieldName -> fieldName.startsWith(OVERSEAS_PREFIX)).collect(Collectors.toSet());
                break;
            }
            default: {
                sumFields = Arrays.stream(fieldNames).filter(fieldName -> fieldName.startsWith(DOMESTIC_PREFIX) || fieldName.startsWith(OVERSEAS_PREFIX) || fieldName.startsWith("bankcate_")).collect(Collectors.toSet());
            }
        }
        return new ArrayList<String>(sumFields);
    }

    private Set<String> getOtherSumFields(List<String> sumFields) {
        HashSet<String> set = new HashSet<String>(sumFields);
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!COUNT_FIELDS.contains(iterator.next())) continue;
            iterator.remove();
        }
        return set;
    }

    private List<String> getAcctStyleItems() {
        MainEntityType bd_accountbanks = MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks");
        List acctstyleItems = ((ComboProp)bd_accountbanks.getProperty("acctstyle")).getComboItems();
        return acctstyleItems.stream().filter(ValueMapItem::isItemVisible).map(ValueMapItem::getValue).collect(Collectors.toList());
    }

    private List<String> getAllColumns() {
        List<String> acctStyleItems = this.getAcctStyleItems();
        HashSet<String> acctStyles = new HashSet<String>(acctStyleItems.size() * 2);
        for (String acctStyle : acctStyleItems) {
            acctStyles.add(DOMESTIC_PREFIX + acctStyle);
            acctStyles.add(OVERSEAS_PREFIX + acctStyle);
        }
        acctStyles.addAll(COUNT_FIELDS);
        return new ArrayList<String>(acctStyles);
    }
}

