/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.BankAcctDateRangeEnum;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctByChangeDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String OPEN_ = "open_";
    private static final String CLOSE_ = "close_";
    private static final String CHANGE_ = "change_";
    private List<String> COUNT_FIELDS = Arrays.asList("open_0", "open_3", "open_total", "close_0", "close_3", "close_total", "change_0", "change_3", "change_total");

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map<String, Object> dateRangeMap = BankAcctHelper.getDateRangeMap(queryDate);
        DataSet bankAcctSet = BankAcctHelper.queryUncloseacct(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet queryDataSet = bankAcctSet.select(new String[]{"id", "org", "finorgtype", "opendate", "closedate"}).filter("opendate != NULL AND opendate < querydate", dateRangeMap);
        return queryDataSet;
    }

    private DataSet processDataSet(DataSet dataSet, Map<String, Object> paramMap, Map<String, Object> dateRangeMap) {
        DataSet bankAcctSet = dataSet;
        DataSet acctOpenSet = bankAcctSet.copy().select(new String[]{"org", "finorgtype", "opendate as opDate"}).addField("1", "count").updateField("finorgtype", "concat('open_', finorgtype)");
        DataSet acctCloseSet = bankAcctSet.copy().filter("closedate != NULL AND closedate < querydate", dateRangeMap).select(new String[]{"org", "finorgtype", "closedate as opDate"}).addField("1", "count").updateField("finorgtype", "concat('close_', finorgtype)");
        DataSet acctChangeSet = BankAcctHelper.getAcctChangeSet(paramMap);
        acctChangeSet = acctChangeSet.leftJoin(bankAcctSet).on("accountid", "id").select(new String[]{"applydate as opDate"}, new String[]{"id as accountid", "org", "finorgtype"}).finish().filter("accountid is not null").addField("1", "count").updateField("finorgtype", "concat('change_', finorgtype)").select(new String[]{"org", "finorgtype", "opDate", "count"});
        DataSet union = acctOpenSet.union(new DataSet[]{acctCloseSet, acctChangeSet});
        union = union.groupBy(new String[]{"org", "finorgtype", "opDate"}).sum("count").finish();
        return union;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DataSet dataSet;
        RowMeta rowMeta = ds.getRowMeta();
        DataSet[] configs = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(ds);
        if ((ds = configs[0].union(BankAcctHelper.getUnBankAcctSet(configs))).isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta.getFieldNames(), rowMeta.getDataTypes());
        }
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Map customParam = queryParam.getCustomParam();
        String dateRange = EmptyUtil.isNoEmpty((Object)customParam) && EmptyUtil.isNoEmpty(customParam.get("dateRange")) ? (String)customParam.get("dateRange") : BankAcctDateRangeEnum.CURRENT_MONTH.getValue();
        Map<String, Object> dateRangeMap = BankAcctHelper.getDateRangeMap(queryDate);
        DataSet processDataSet = this.processDataSet(ds, paramMap, dateRangeMap);
        processDataSet = processDataSet.addField("TO_CHAR(opDate,'yyyyMMdd')", "dateSub");
        DataSet[] dataSets = processDataSet.splitByFilter(new String[]{"dateSub >= " + DateUtils.formatString((Date)((Date)dateRangeMap.get(dateRange)), (String)"yyyyMMdd")}, false);
        DataSet dataSet2 = dataSet = dataSets.length > 0 ? dataSets[0] : null;
        if (dataSet == null || dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta.getFieldNames(), rowMeta.getDataTypes());
        }
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet dealDateRangeSet = this.dealDateRangeSet(orgViewId, dataSet);
        dealDateRangeSet = DecisionAnlsHelper.addAbsentFields(dealDateRangeSet, this.COUNT_FIELDS);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            dealDateRangeSet = dealDateRangeSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds));
        }
        dealDateRangeSet = dealDateRangeSet.orderBy(new String[]{"sortcode"});
        List<String> sumFields = this.getSumFields(dealDateRangeSet);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(dealDateRangeSet, sumFields, "mixorgname");
        DataSet resultSet = dealDateRangeSet.union(totalDataSet);
        resultSet = resultSet.updateFields(new String[]{this.COUNT_FIELDS.get(2), this.COUNT_FIELDS.get(5), this.COUNT_FIELDS.get(8)}, new String[]{String.join((CharSequence)"+", this.getSubSumFields(resultSet, OPEN_)), String.join((CharSequence)"+", this.getSubSumFields(resultSet, CLOSE_)), String.join((CharSequence)"+", this.getSubSumFields(resultSet, CHANGE_))});
        sumFields.addAll(Arrays.asList(this.COUNT_FIELDS.get(2), this.COUNT_FIELDS.get(5), this.COUNT_FIELDS.get(8)));
        resultSet = DecisionAnlsHelper.removeNoDataTreeDs(resultSet, sumFields, false);
        return resultSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List amFinOrgTypeConfigs = BankAcctHelper.getAmFinOrgTypeConfigs().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        int index = 2;
        for (String finOrgTypeValue : amFinOrgTypeConfigs) {
            String name = TdaFinOrgTypeEnum.getName((String)finOrgTypeValue);
            ((ReportColumnGroup)columns.get(1)).getChildren().add(index, this.createColumn(OPEN_ + finOrgTypeValue, name, false));
            ((ReportColumnGroup)columns.get(2)).getChildren().add(index, this.createColumn(CHANGE_ + finOrgTypeValue, name, false));
            ((ReportColumnGroup)columns.get(3)).getChildren().add(index, this.createColumn(CLOSE_ + finOrgTypeValue, name, false));
        }
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption, boolean isHide) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("integer");
        reportColumn.setZeroShow(true);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setHide(isHide);
        return reportColumn;
    }

    private DataSet dealDateRangeSet(Long orgViewId, DataSet dataSet) {
        dataSet = DecisionAnlsHelper.ChangeRowToColDataSet(dataSet, "finorgtype", "org,opDate", "");
        List<String> sumFields = this.getSumFields(dataSet);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"org"});
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        DataSet groupSet = groupbyDataSet.finish();
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinDs = orgDateSet.leftJoin(groupSet).on("rowid", "org").select(new String[]{"orgid", "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, sumFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, sumFields, "orgid,mixorgname,sortcode");
        return sumDataSet;
    }

    private List<String> getSumFields(DataSet dataSet) {
        List<String> sumFields = Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(s -> Pattern.matches(".*\\d$", s)).collect(Collectors.toList());
        return sumFields;
    }

    private List<String> getSubSumFields(DataSet dataSet, String type) {
        List<String> sumFields = this.getSumFields(dataSet);
        return sumFields.stream().filter(s -> s.startsWith(type)).collect(Collectors.toList());
    }
}

