/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.form;

import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class AcctDisplayByBankFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public static final String ORGID = "orgid";
    public static final String DISPLAY_TYPE = "displayType";
    public static final String FILTER = "filter";
    public static final String ISGROUPNODE = "isgroupnode";
    public static final String ROWID = "rowid";
    public static final String BANKCATE_0 = "bankcate_0";
    public static final String FILTER_COMPANY = "filter_company";
    public static final String PARENTORG = "parentorg";
    private static final String BTN_SHOWALL = "btn_showall";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String displayType = (String)customParams.get(DISPLAY_TYPE);
        queryParam.getCustomParam().put(DISPLAY_TYPE, displayType);
        return super.verifyQuery(queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (BTN_SHOWALL.equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", true);
            this.getView().invokeOperation("refresh");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SHOWALL});
        } else if ("btn_showdetail".equals(key)) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.getCustomParams().put(DISPLAY_TYPE, this.getQueryParam().getCustomParam().get(DISPLAY_TYPE));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SHOWALL});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
        String displayType = (String)customParams.get(DISPLAY_TYPE);
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString(ISGROUPNODE);
        long orgid = row.getLong(ROWID);
        long clickOrgId = row.getLong(ROWID);
        if (BANKCATE_0.equals(fieldName)) {
            if (row.getInt(BANKCATE_0) == 0) {
                return;
            }
            orgid = ((DynamicObject)((DynamicObjectCollection)paramMap.get(FILTER_COMPANY)).get(0)).getLong("id");
            if (EmptyUtil.isEmpty((Long)clickOrgId) || 0L == clickOrgId) {
                clickOrgId = orgid;
            }
        }
        if (!(BANKCATE_0.equals(fieldName) || !EmptyUtil.isEmpty((Long)orgid) && 0L != orgid && "1".equals(isGroupNode))) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        String formId = BANKCATE_0.equals(fieldName) ? "tda_otherbankacctrpt" : "tda_acctbankrpt";
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put(ORGID, Long.toString(clickOrgId));
        param.getCustomParams().put(PARENTORG, Long.toString(orgid));
        param.getCustomParams().put("orgViewNumber", this.getPageCache().get("orgViewNumber"));
        param.getCustomParams().put(DISPLAY_TYPE, displayType);
        param.getCustomParams().put(ISGROUPNODE, isGroupNode);
        param.setCaption(displayType.equals(AcctDisplayByBankTypeEnum.DOMESTIC.getValue()) ? ResManager.loadKDString((String)"\u5883\u5185\u94f6\u884c\u8d26\u6237\u5206\u5e03", (String)"AcctDisplayByBankFormListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5883\u5916\u94f6\u884c\u8d26\u6237\u5206\u5e03", (String)"AcctDisplayByBankFormListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(formId);
        param.getOpenStyle().setShowType(BANKCATE_0.equals(fieldName) ? ShowType.Modal : ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString(ISGROUPNODE);
        Object formatValue = packageDataEvent.getFormatValue();
        if (formatValue != null && !"1".equals(isGroupNode) && !BANKCATE_0.equals(((ReportColumn)packageDataEvent.getSource()).getFieldKey())) {
            packageDataEvent.getNoLinkKey().add(((ReportColumn)packageDataEvent.getSource()).getFieldKey());
        }
    }
}

