/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class BankAcctByAreaFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ACCT_STYLE = "acctstyle";
    private static final String SHORT_NUMBER = "shortnumber";
    private static final String DOMESTIC_PREFIX = "domestic_";
    private static final String OVERSEAS_PREFIX = "overseas_";
    private static final String FILTER = "filter";
    private static final String ORGID = "orgid";
    private static List<String> FiXED_REPORT_HEADS = Arrays.asList(AcctStyleEnum.BASIC.getValue(), AcctStyleEnum.NORMAL.getValue(), AcctStyleEnum.SPCL.getValue());
    private final String[] REPORT_HEADS = new String[]{"domestic_basic", "domestic_normal", "domestic_spcl", "domestic_other1", "domestic_subtotal", "overseas_basic", "overseas_normal", "overseas_spcl", "overseas_other1", "overseas_subtotal", "bankaccts", "companyaccts", "accts", "org_name", "rowid", "isgroupnode"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlistap = (ReportList)this.getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btn_showdetail".equals(key)) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Number orgId = (Number)formShowParameter.getCustomParam(ORGID);
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString("isgroupnode");
        String domesticOther = row.getString(this.REPORT_HEADS[3]);
        String overseasOther = row.getString(this.REPORT_HEADS[8]);
        Object formatValue = packageDataEvent.getFormatValue();
        if (formatValue != null && !"1".equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(this.REPORT_HEADS[13]);
        }
        if (formatValue != null && "0".equals(domesticOther)) {
            packageDataEvent.getNoLinkKey().add(this.REPORT_HEADS[3]);
        }
        if (formatValue != null && "0".equals(overseasOther)) {
            packageDataEvent.getNoLinkKey().add(this.REPORT_HEADS[8]);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (this.REPORT_HEADS[13].equals(fieldName)) {
            Number org = (Number)hyperLinkClickEvent.getRowData().get(this.REPORT_HEADS[14]);
            String isgroupnode = (String)hyperLinkClickEvent.getRowData().get(this.REPORT_HEADS[15]);
            if (EmptyUtil.isEmpty((Object)org)) {
                return;
            }
            if ("0".equals(isgroupnode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"CreditTotalDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]));
                return;
            }
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo filter = queryParam.getFilter();
            ReportShowParameter param = new ReportShowParameter();
            param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            param.getCustomParams().put(ORGID, org);
            param.getCustomParams().put("orgViewNumber", this.getPageCache().get("orgViewNumber"));
            param.getCustomParams().put("next", true);
            param.setFormId("tda_acctbankarearpt");
            String caption = this.getView().getFormShowParameter().getCaption();
            if (StringUtils.isNotEmpty((String)caption)) {
                param.setCaption(caption);
            }
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        if (this.REPORT_HEADS[3].equals(fieldName) || this.REPORT_HEADS[8].equals(fieldName)) {
            this.showForm(fieldName.startsWith(DOMESTIC_PREFIX), hyperLinkClickEvent);
        }
    }

    private void showForm(boolean isDomestic, HyperLinkClickEvent hyperLinkClickEvent) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("formId", "tda_dybilllist_rpt");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
        ArrayList columns = new ArrayList();
        HashMap<String, Object> data1 = new HashMap<String, Object>(4);
        data1.put("key", ACCT_STYLE);
        data1.put("caption", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"BankAcctDistSumaryRowDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        data1.put("colIndex", 0);
        columns.add(data1);
        HashMap<String, Object> data2 = new HashMap<String, Object>(4);
        data2.put("key", SHORT_NUMBER);
        data2.put("caption", ResManager.loadKDString((String)"\u8d26\u6237\u6570\u91cf", (String)"DormantDataQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        data2.put("colIndex", 1);
        columns.add(data2);
        List<ValueMapItem> dynamicHeads = this.getOtherCols(hyperLinkClickEvent);
        ArrayList datas = new ArrayList(dynamicHeads.size());
        String area = isDomestic ? DOMESTIC_PREFIX : OVERSEAS_PREFIX;
        for (ValueMapItem valueMapItem : dynamicHeads) {
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            String key = area + valueMapItem.getValue();
            data.put(ACCT_STYLE, valueMapItem.getName().getLocaleValue());
            data.put(SHORT_NUMBER, hyperLinkClickEvent.getRowData().get(key));
            datas.add(data);
        }
        String[] propertys = new String[]{ACCT_STYLE, SHORT_NUMBER};
        Class[] propertyTypes = new Class[]{String.class, String.class};
        showParameter.setCustomParam("bill_entity", (Object)"bd_accountbanks");
        showParameter.setCustomParam("columns", columns);
        showParameter.setCustomParam("propertys", (Object)propertys);
        showParameter.setCustomParam("propertyTypes", (Object)propertyTypes);
        showParameter.setCustomParam("datas", datas);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u8d26\u6237\u7c7b\u578b\u5206\u5e03", (String)"BankAcctByAreaFormListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    private List<ValueMapItem> getOtherCols(HyperLinkClickEvent hyperLinkClickEvent) {
        DataEntityPropertyCollection properties = hyperLinkClickEvent.getRowData().getDataEntityType().getProperties();
        Set propertys = properties.stream().filter(property -> property.getName().startsWith(DOMESTIC_PREFIX) || property.getName().startsWith(OVERSEAS_PREFIX)).map(property -> property.getName().replaceAll("(?:domestic_|overseas_)", "")).collect(Collectors.toSet());
        MainEntityType bd_accountbanks = MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks");
        List acctstyleItems = ((ComboProp)bd_accountbanks.getProperty(ACCT_STYLE)).getComboItems();
        List<ValueMapItem> dynamicHeads = acctstyleItems.stream().filter(valueMapItem -> propertys.contains(valueMapItem.getValue()) && !FiXED_REPORT_HEADS.contains(valueMapItem.getValue()) && valueMapItem.isItemVisible()).collect(Collectors.toList());
        return dynamicHeads;
    }
}

