/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.form;

import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.mvc.list.ListDataProvider;

public class DynamicBillListPlugin
extends AbstractFormPlugin
implements CreateListColumnsListener,
BeforeBindDataListener {
    private static final String BILL_LIST_KEY = "billlistap";
    private static final String LIST_GRID_VIEW_AP = "listgridviewap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILL_LIST_KEY);
        billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        billList.addBeforeBindDataListener((BeforeBindDataListener)this);
    }

    public void createListColumns(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List columns = beforeCreateListColumnsArgs.getListColumns();
        List needColumns = JSONArray.parseArray((String)formShowParameter.getCustomParams().get("columns").toString(), Map.class);
        for (Map map : needColumns) {
            String key = (String)map.get("key");
            String caption = (String)map.get("caption");
            Integer colIndex = (Integer)map.get("colIndex");
            ListColumn listColumn = this.createListColumn(key, caption, colIndex);
            listColumn.setParentViewKey(LIST_GRID_VIEW_AP);
            columns.add(listColumn);
        }
    }

    public void beforeBindData(BeforeBindDataEvent beforeBindDataEvent) {
        BillList billList = (BillList)this.getControl(BILL_LIST_KEY);
        billList.addCreateListDataProviderListener(beforeCreateListDataProviderArgs -> beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new BillListDataProvider()));
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn column = new ListColumn();
        column.setCaption(new LocaleString(caption));
        column.setKey(key);
        column.setFieldName(key);
        column.setListFieldKey(key);
        column.setSeq(colIndex);
        column.setWidth(new LocaleString("8%"));
        return column;
    }

    public class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            FormShowParameter formShowParameter = DynamicBillListPlugin.this.getView().getFormShowParameter();
            String billEntity = (String)formShowParameter.getCustomParams().get("bill_entity");
            List dataList = JSONArray.parseArray((String)formShowParameter.getCustomParams().get("datas").toString(), Map.class);
            List propertys = JSONArray.parseArray((String)formShowParameter.getCustomParams().get("propertys").toString(), String.class);
            List propertyTypes = JSONArray.parseArray((String)formShowParameter.getCustomParams().get("propertyTypes").toString(), Class.class);
            DynamicObjectCollection results = new DynamicObjectCollection();
            for (Map map : dataList) {
                DynamicObjectType dynamicObjectType = new DynamicObjectType(billEntity);
                for (int p = 0; p < propertys.size(); ++p) {
                    DynamicSimpleProperty dynamicSimpleProperty = new DynamicSimpleProperty((String)propertys.get(p), (Class)propertyTypes.get(p), null);
                    dynamicObjectType.addProperty((DynamicProperty)dynamicSimpleProperty);
                }
                DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                for (String property : propertys) {
                    dynamicObject.set(property, map.get(property));
                }
                results.add((Object)dynamicObject);
            }
            this.getQueryResult().setCollection(results);
            this.getQueryResult().setDataCount(results.size());
            return results;
        }
    }
}

