/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.tmc.tda.extpoint.bankacct.IParentAcctInterface;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.bankacct.extpoint.ParentAcctDefaultExt;
import kd.tmc.tda.report.common.helper.AbstractDecisionDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundConcentrationQingDataHelper
extends AbstractDecisionDataHelper {
    private static final String TMC_TDA_REPORT = "tmc-tda-report";
    private static final String FUNDCONCENTRATION = "fundConcentration";
    private static final String FUNDTYPE = "fundType";
    private static final String FUND_TYPE_NUM = "fundTypeNum";
    private static final String AREA = "area";
    private static final String AREA_NUM = "area_num";
    private static final String AMOUNT = "amount";
    private static final String REALVALIBALANCE = "realvalibalance";
    private static final String ISDOMESTIC = "isdomestic";
    private static final String[] SELECT_FIELDS = new String[]{"finorgtype", "accountbank", "fundType", "amount", "realvalibalance", "isoffset", "isdomestic", "acctproperty", "businessunit"};
    private static final DataType[] dataTypes = new DataType[]{DataType.BigDecimalType, DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.IntegerType};
    private static final String[] fields = new String[]{"fundConcentration", "fundType", "fundTypeNum", "area", "area_num"};
    private static final Log logger = LogFactory.getLog(FundConcentrationQingDataHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSet queryDataSetFromDb(Map<String, Object> paramMap, String algoKey) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        DataSet fundBalance = null;
        DataSet parentBalance = null;
        try {
            DataSet subTotalDs;
            parentBalance = CashFundsDataHelper.getFundDataSet((String)algoKey, (List)orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)false);
            parentBalance = parentBalance.select(SELECT_FIELDS);
            fundBalance = CashFundsDataHelper.getFundConcentrateDs((DataSet)parentBalance.copy(), (List)orgIds);
            DataSet sumDs = fundBalance.copy().filter("isoffset = '0'").groupBy(new String[]{ISDOMESTIC}).sum(AMOUNT).sum(REALVALIBALANCE).finish();
            BigDecimal domesticAmount = new BigDecimal(0);
            BigDecimal overseasAmount = new BigDecimal(0);
            BigDecimal cDomesticAmount = new BigDecimal(0);
            BigDecimal cOverseasAmount = new BigDecimal(0);
            for (Row next : sumDs) {
                BigDecimal subCollectAmount;
                BigDecimal subAmount = next.getBigDecimal(AMOUNT) == null ? BigDecimal.ZERO : next.getBigDecimal(AMOUNT);
                BigDecimal bigDecimal = subCollectAmount = next.getBigDecimal(REALVALIBALANCE) == null ? BigDecimal.ZERO : next.getBigDecimal(REALVALIBALANCE);
                if ("1".equals(next.getString(ISDOMESTIC))) {
                    domesticAmount = subAmount;
                    cDomesticAmount = subCollectAmount;
                    continue;
                }
                overseasAmount = subAmount;
                cOverseasAmount = subCollectAmount;
            }
            BigDecimal amount = domesticAmount.add(overseasAmount);
            BigDecimal collectAmount = cDomesticAmount.add(cOverseasAmount);
            logger.info("\u8d44\u91d1\u4f59\u989d\uff1a{}, \u8d44\u91d1\u4f59\u989d-\u5883\u5185\uff1a{}, \u8d44\u91d1\u4f59\u989d-\u5883\u5916\uff1a{},", new Object[]{amount, domesticAmount, overseasAmount});
            logger.info("\u53ef\u7528\u4f59\u989d\uff1a{}, \u53ef\u7528\u4f59\u989d-\u5883\u5185\uff1a{}, \u53ef\u7528\u4f59\u989d-\u5883\u5916\uff1a{},", new Object[]{collectAmount, cDomesticAmount, cOverseasAmount});
            DataSet financialDs = fundBalance.filter("finorgtype = '3'");
            List<Long> acctIds = FundConcentrationQingDataHelper.getParentAcctIdsByExtPoint(paramMap);
            if (!acctIds.isEmpty()) {
                DataSet acctDs = parentBalance.filter("finorgtype != '3' and fundtype = 0 and accountbank in acctIds", Collections.singletonMap("acctIds", acctIds));
                subTotalDs = financialDs.union(acctDs);
            } else {
                subTotalDs = financialDs;
            }
            DataSet sumDs1 = subTotalDs.groupBy(new String[]{ISDOMESTIC}).sum(AMOUNT).finish();
            BigDecimal domesticTotal = new BigDecimal(0);
            BigDecimal overseasTotal = new BigDecimal(0);
            for (Row next : sumDs1) {
                BigDecimal subTotal;
                BigDecimal bigDecimal = subTotal = next.getBigDecimal(AMOUNT) == null ? BigDecimal.ZERO : next.getBigDecimal(AMOUNT);
                if ("1".equals(next.getString(ISDOMESTIC))) {
                    domesticTotal = subTotal;
                    continue;
                }
                overseasTotal = subTotal;
            }
            BigDecimal subTotal = domesticTotal.add(overseasTotal);
            logger.info("\u8d26\u6237\u5c0f\u8ba1:{}, \u8d26\u6237-\u5883\u5185\u5c0f\u8ba1:{}, \u8d26\u6237-\u5883\u5916\u5c0f\u8ba1:{} ", new Object[]{subTotal, domesticTotal, overseasTotal});
            BigDecimal amountRate = amount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : subTotal.divide(amount, 4);
            BigDecimal domesticRate = domesticAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : domesticTotal.divide(domesticAmount, 4);
            BigDecimal overseasRate = overseasAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : overseasTotal.divide(overseasAmount, 4);
            BigDecimal valibalanceRate = collectAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : subTotal.divide(collectAmount, 4);
            BigDecimal valiDomesticRate = cDomesticAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : domesticTotal.divide(cDomesticAmount, 4);
            BigDecimal valiOverseasRate = cOverseasAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : overseasTotal.divide(cOverseasAmount, 4);
            logger.info("\u5168\u53e3\u5f84:{}, \u5168\u53e3\u5f84-\u5883\u5185:{}, \u5168\u53e3\u5f84-\u5883\u5916:{}", new Object[]{amountRate, domesticRate, overseasRate});
            logger.info("\u53ef\u5f52\u96c6:{}, \u53ef\u5f52\u96c6-\u5883\u5185:{}, \u53ef\u5f52\u96c6-\u5883\u5916:{}", new Object[]{valibalanceRate, valiDomesticRate, valiOverseasRate});
            String full = ResManager.loadKDString((String)"\u5168\u53e3\u5f84", (String)"FundConcentrationQingPlugin_3", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
            String coll = ResManager.loadKDString((String)"\u53ef\u5f52\u96c6", (String)"FundConcentrationQingPlugin_4", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
            list.add(new Object[]{amountRate, full, 0, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FundConcentrationQingPlugin_6", (String)TMC_TDA_REPORT, (Object[])new Object[0]), 0});
            list.add(new Object[]{domesticRate, full, 0, ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)TMC_TDA_REPORT, (Object[])new Object[0]), 1});
            list.add(new Object[]{overseasRate, full, 0, ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)TMC_TDA_REPORT, (Object[])new Object[0]), 2});
            list.add(new Object[]{valibalanceRate, coll, 1, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FundConcentrationQingPlugin_6", (String)TMC_TDA_REPORT, (Object[])new Object[0]), 0});
            list.add(new Object[]{valiDomesticRate, coll, 1, ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)TMC_TDA_REPORT, (Object[])new Object[0]), 1});
            list.add(new Object[]{valiOverseasRate, coll, 1, ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)TMC_TDA_REPORT, (Object[])new Object[0]), 2});
            DataSet dataSet = DecisionAnlsHelper.createRow(algoKey, fields, dataTypes, list);
            return dataSet;
        }
        finally {
            if (fundBalance != null) {
                fundBalance.close();
            }
            if (parentBalance != null) {
                parentBalance.close();
            }
        }
    }

    private static List<Long> getParentAcctIdsByExtPoint(Map<String, Object> param) {
        ParentAcctDefaultExt interfaceAcct = new ParentAcctDefaultExt();
        PluginProxy pluginProxy = PluginProxy.create((Object)interfaceAcct, IParentAcctInterface.class, (String)"kd.sdk.tmc.tda.extpoint.bankacct.parentAcct", null);
        List result = pluginProxy.callReplaceIfPresent(p -> p.getParentAcct(param));
        return (List)result.get(0);
    }
}

