/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class AcctDisplayByBankQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String BANKNAME = "bankname";
    private static final String ACCTNUM = "acctnum";
    private static final String ISDOMESTIC = "isdomestic";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BANKNAME, ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"AcctDisplayByBankQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{ISDOMESTIC, ResManager.loadKDString((String)"\u662f\u5426\u5883\u5185", (String)"AcctDisplayByBankQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{ACCTNUM, ResManager.loadKDString((String)"\u8d26\u6237\u6570\u91cf", (String)"AcctDisplayByBankQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f\u5217", (String)"AcctDisplayByBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    @Override
    protected List<String> getLinkReport() {
        return Arrays.asList("tda_domesticacctqingrpt", "tda_overseasacctqingrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BANKNAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        AcctDisplayByBankTypeEnum type = "tda_domesticacctqingrpt".equals(formId) ? AcctDisplayByBankTypeEnum.DOMESTIC : AcctDisplayByBankTypeEnum.OVERSEAS;
        String caption = "tda_domesticacctqingrpt".equals(formId) ? ResManager.loadKDString((String)"\u5883\u5185\u8d26\u6237\u94f6\u884c\u5206\u5e03\u8868", (String)"AcctDisplayByBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5883\u5916\u8d26\u6237\u94f6\u884c\u5206\u5e03\u8868", (String)"AcctDisplayByBankQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.getCustomParams().put("displayType", type.getValue());
        param.setFormId("tda_acctbankrpt");
        param.setCaption(caption);
        this.fireLinkageShowForm(view, param);
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet overseasUnionSet;
        DataSet domesticUnionSet;
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet allAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap).select("bankaccountnumber,finorgtype,org openorg,bankcate,bankname, case when areas = 'domestic' then '1' else '0' end as isdomestic");
        DataSet[] allAcctSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(allAcctSet);
        DataSet bankDomesticAcctSet = DecisionAnlsHelper.getAcctByType(allAcctSets[0].copy(), AcctDisplayByBankTypeEnum.DOMESTIC);
        Pair<DataSet, DataSet> splitDomesticDataSet = DecisionAnlsHelper.splitTopBank(bankDomesticAcctSet, 15);
        DataSet topDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue0()).select(new String[]{BANKNAME, ISDOMESTIC}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).count(ACCTNUM).finish().orderBy(new String[]{"acctnum desc"});
        if (splitDomesticDataSet.getValue1() != null) {
            DataSet nonTopDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"AcctDisplayByBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0])).select(new String[]{BANKNAME, ISDOMESTIC}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).count(ACCTNUM).finish();
            domesticUnionSet = topDomesticBankAcctSet.union(nonTopDomesticBankAcctSet);
        } else {
            domesticUnionSet = topDomesticBankAcctSet;
        }
        DataSet bankOverseasAcctSet = DecisionAnlsHelper.getAcctByType(allAcctSets[0], AcctDisplayByBankTypeEnum.OVERSEAS);
        Pair<DataSet, DataSet> splitOverseasDataSet = DecisionAnlsHelper.splitTopBank(bankOverseasAcctSet, 15);
        DataSet topBankOverseasAcctSet = ((DataSet)splitOverseasDataSet.getValue0()).select(new String[]{BANKNAME, ISDOMESTIC}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).count(ACCTNUM).finish().orderBy(new String[]{"acctnum desc"});
        if (splitOverseasDataSet.getValue1() != null) {
            DataSet nonTopOverseasBankAcctSet = ((DataSet)splitOverseasDataSet.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"AcctDisplayByBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0])).select(new String[]{BANKNAME, ISDOMESTIC}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).count(ACCTNUM).finish();
            overseasUnionSet = topBankOverseasAcctSet.union(nonTopOverseasBankAcctSet);
        } else {
            overseasUnionSet = topBankOverseasAcctSet;
        }
        String trdOrder = "trdOrder";
        DataSet finCompAcctSet = allAcctSets[2].addField("1", trdOrder).updateField(BANKNAME, ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"AcctDisplayByBankQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]));
        DataSet settleAcctSet = allAcctSets[1].addField("2", trdOrder).updateField(BANKNAME, ResManager.loadKDString((String)"'\u7ed3\u7b97\u4e2d\u5fc3'", (String)"AcctDisplayByBankQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]));
        DataSet trdAcctSet = allAcctSets[3].addField("3", trdOrder).updateField(BANKNAME, ResManager.loadKDString((String)"'\u7b2c\u4e09\u65b9\u8d26\u6237'", (String)"AcctDisplayByBankQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]));
        DataSet otherAcctSet = allAcctSets[4].addField("4", trdOrder).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u91d1\u878d\u673a\u6784'", (String)"AcctDisplayByBankQingAnlsPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]));
        DataSet unionSet = finCompAcctSet.union(new DataSet[]{settleAcctSet, trdAcctSet, otherAcctSet}).select(new String[]{BANKNAME, ISDOMESTIC, trdOrder}).groupBy(new String[]{BANKNAME, ISDOMESTIC, trdOrder}).count(ACCTNUM).finish().orderBy(new String[]{"isdomestic DESC", trdOrder + " ASC"}).select(domesticUnionSet.getRowMeta().getFieldNames());
        return domesticUnionSet.union(new DataSet[]{overseasUnionSet, unionSet});
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        JSONArray data = (JSONArray)clickArgs.get((Object)"data");
        AcctDisplayByBankTypeEnum type = AcctDisplayByBankTypeEnum.DOMESTIC;
        if (data != null && data.size() > 1 && "0".equals(data.get(1))) {
            type = AcctDisplayByBankTypeEnum.OVERSEAS;
        }
        String caption = type == AcctDisplayByBankTypeEnum.DOMESTIC ? ResManager.loadKDString((String)"\u5883\u5185\u8d26\u6237\u94f6\u884c\u5206\u5e03\u8868", (String)"AcctDisplayByBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5883\u5916\u8d26\u6237\u94f6\u884c\u5206\u5e03\u8868", (String)"AcctDisplayByBankQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.getCustomParams().put("displayType", type.getValue());
        param.setFormId("tda_acctbankrpt");
        param.setCaption(caption);
    }
}

