/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.AcctStyleEnum;
import kd.tmc.fbp.common.enums.AcctTypeEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BankInterFaceEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;

public class AcctSumQingAnlsDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"company.name", ResManager.loadKDString((String)"\u7533\u8bf7\u516c\u53f8", (String)"AcctSumQingAnlsDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"openorg.name", ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"AcctSumQingAnlsDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"name", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u540d\u79f0", (String)"AcctSumQingAnlsDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"AcctSumQingAnlsDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"fintypeorbank", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b/\u91d1\u878d\u673a\u6784", (String)"AcctSumQingAnlsDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"finorginfo", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784", (String)"AcctSumQingAnlsDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctproperty", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"AcctSumQingAnlsDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctstyle", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"AcctSumQingAnlsDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"accttype", ResManager.loadKDString((String)"\u8d26\u6237\u6027\u8d28", (String)"AcctSumQingAnlsDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctstatus", ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001", (String)"AcctSumQingAnlsDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"issetbankinterface", ResManager.loadKDString((String)"\u94f6\u4f01\u63a5\u53e3", (String)"AcctSumQingAnlsDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"country", ResManager.loadKDString((String)"\u56fd\u5bb6\u6216\u5730\u533a", (String)"AcctSumQingAnlsDataPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"province", ResManager.loadKDString((String)"\u7701\u4efd", (String)"AcctSumQingAnlsDataPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"city", ResManager.loadKDString((String)"\u57ce\u5e02", (String)"AcctSumQingAnlsDataPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        QFilter filter = new QFilter("org.id", "in", orgIdSet);
        String bankAcctSic = "name, bankaccountnumber,acctstatus, company.name, openorg.name, bank.id, acctproperty, acctstyle, accttype, issetbankinterface";
        DataSet bankAcctSet = QueryServiceHelper.queryDataSet((String)"BankAcctSum", (String)"bd_accountbanks", (String)bankAcctSic, (QFilter[])filter.toArray(), null);
        String finOrgSic = "id, name finorginfo, country.name country, province.name province, city.name city,bank_cate.name,finorgtype.type finorgtype";
        DataSet bankSet = QueryServiceHelper.queryDataSet((String)"FinOrgInfo", (String)"bd_finorginfo", (String)finOrgSic, null, null);
        DataSet allBankSet = bankSet.addField("bank_cate.name||','||finorginfo||','||finorgtype", "fintypeorbank");
        return bankAcctSet.join(allBankSet).on("bank.id", "id").select(new String[]{"name", "bankaccountnumber", "acctstatus", "company.name", "openorg.name", "acctproperty", "acctstyle", "accttype", "issetbankinterface", "finorginfo", "finorgtype", "country", "province", "city", "fintypeorbank"}).finish();
    }

    @Override
    protected Object translateCellDisplay(String field, Object value, Row rs) {
        switch (field) {
            case "fintypeorbank": {
                String[] finsplit = value.toString().split(",");
                if (finsplit.length > 3 && finsplit[2].equals(FinOrgTypeEnum.BANK.getValue())) {
                    value = finsplit[0];
                    break;
                }
                if (finsplit.length < 2) break;
                value = finsplit[1];
                break;
            }
            case "acctstyle": {
                value = AcctStyleEnum.getName((String)((String)value));
                break;
            }
            case "issetbankinterface": {
                if (!FinOrgTypeEnum.BANK.getName().equals(rs.getString("finorgtype"))) {
                    value = false;
                }
                value = BankInterFaceEnum.getName((boolean)((Boolean)value));
                break;
            }
            case "accttype": {
                value = AcctTypeEnum.getName((String)((String)value));
                break;
            }
            case "acctstatus": {
                value = BankAcctStatusEnum.getName((String)((String)value));
            }
        }
        return value;
    }
}

