/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctDistSumaryDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private String BANK_INTERFACE = "bankinterface";
    private String DISTRIBUTE = "distribute";
    private String DISTRIBUTE_NAME = "distribute_name";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{this.DISTRIBUTE, ResManager.loadKDString((String)"\u5206\u5e03", (String)"BankInterfaceOpenRateDataPulgin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{this.DISTRIBUTE_NAME, ResManager.loadKDString((String)"\u5206\u5e03\u540d\u79f0", (String)"BankInterfaceOpenRateDataPulgin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"count", ResManager.loadKDString((String)"\u6570\u91cf", (String)"BankInterfaceOpenRateDataPulgin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] dataSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(bankAcctSet);
        DataSet interfaceSet = BasicParamHelper.getBasicParamApplicationConfigs((DataSet)dataSets[0], (String)"bankapplyconditiontag");
        interfaceSet = interfaceSet.groupBy(new String[]{this.BANK_INTERFACE}).count("count").finish().select(new String[]{"bankinterface distribute", "count"});
        DataSet fincomSet = dataSets[2].groupBy().count().finish().addField("'fincom'", this.DISTRIBUTE).select(interfaceSet.getRowMeta().getFieldNames());
        DataSet resultSet = interfaceSet.union(fincomSet);
        resultSet = this.creatAbsentRow(resultSet);
        return resultSet;
    }

    private DataSet creatAbsentRow(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<String> distributes = new ArrayList<String>(Arrays.asList("bi_true", "bi_false", "fincom"));
        ArrayList<String> exists = new ArrayList<String>(4);
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"true", "true"}, false);
        Iterator iterator = dataSets[0].iterator();
        while (iterator.hasNext()) {
            exists.add(((Row)iterator.next()).getString(this.DISTRIBUTE));
        }
        distributes.removeAll(exists);
        DataSet resultSet = dataSets[1];
        if (CollectionUtils.isNotEmpty(distributes)) {
            for (String absent : distributes) {
                collection.add(new Object[]{absent, "0"});
            }
            DataSet createRow = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), collection);
            resultSet = resultSet.union(createRow);
        }
        return resultSet.addField("case when distribute = 'bi_true' then '" + BankAcctDistSumaryDataPlugin.getBankCompanyStr() + "' when distribute = 'bi_false' then '" + BankAcctDistSumaryDataPlugin.getNoBankCompanyStr() + "' else '" + BankAcctDistSumaryDataPlugin.getFinCompanyStr() + "' end", this.DISTRIBUTE_NAME);
    }

    private static String getBankCompanyStr() {
        return ResManager.loadKDString((String)"\u94f6\u4f01", (String)"BankInterfaceOpenRateDataPulgin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getNoBankCompanyStr() {
        return ResManager.loadKDString((String)"\u975e\u94f6\u4f01", (String)"BankInterfaceOpenRateDataPulgin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static String getFinCompanyStr() {
        return ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8", (String)"BankInterfaceOpenRateDataPulgin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_acctbankinterface_rpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return this.DISTRIBUTE_NAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbankinterface_rpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u4f01\u8d26\u6237\u5206\u5e03\u8868", (String)"BankInterfaceOpenRateDataPulgin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(4, 4);
        }
        return value;
    }
}

