/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.TdaFinOrgTypeEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankAcctDistSumaryRowDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    public static final String FINORGTYPE = "finorgtype";
    private String AREAS = "areas";
    private String DOMESTIC = "domestic";
    private String OVERSEAS = "overseas";
    private List<String> UN_BANK_COLS = Arrays.asList("bankcate_" + TdaFinOrgTypeEnum.CLEARINGHOUSE.getValue(), "bankcate_" + TdaFinOrgTypeEnum.FINCOMP.getValue(), "bankcate_" + TdaFinOrgTypeEnum.TRDPARTPAY.getValue(), "bankcate_" + TdaFinOrgTypeEnum.OTHERACCT.getValue());

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"org", ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b", (String)"BankAcctDistSumaryRowDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{this.DOMESTIC, ResManager.loadKDString((String)"\u5883\u5185\u8d26\u6237", (String)"BankAcctDistSumaryRowDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{this.OVERSEAS, ResManager.loadKDString((String)"\u5883\u5916\u8d26\u6237", (String)"BankAcctDistSumaryRowDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"bankcate_1", ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"AcctDisplayByBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"bankcate_3", ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8", (String)"BankAcctDistSumaryRowDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"bankcate_4", ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8d26\u6237", (String)"AcctDisplayByBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"bankcate_999", ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784", (String)"AcctDisplayByBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"accts", ResManager.loadKDString((String)"\u8d26\u6237\u603b\u6570", (String)"BankAcctDistSumaryRowDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{"domesticcolumn", ResManager.loadKDString((String)"\u5883\u5185\u94f6\u884c\u8d26\u6237\u5217", (String)"BankAcctDistSumaryRowDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"overseascolumn", ResManager.loadKDString((String)"\u5883\u5916\u94f6\u884c\u8d26\u6237\u5217", (String)"BankAcctDistSumaryRowDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"fincomcolumn", ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8\u5217", (String)"BankAcctDistSumaryRowDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"settlecolumn", ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5217", (String)"BankAcctDistSumaryRowDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"trdacctcolumn", ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8d26\u6237\u5217", (String)"BankAcctDistSumaryRowDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"othacctcolumn", ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784\u5217", (String)"BankAcctDistSumaryRowDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"acctscolumn", ResManager.loadKDString((String)"\u8d26\u6237\u603b\u6570\u5217", (String)"BankAcctDistSumaryRowDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet query = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap).select(new String[]{this.AREAS, FINORGTYPE});
        DataSet[] splitDataSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(query);
        DataSet bankAcctSet = splitDataSets[0].groupBy(new String[]{this.AREAS}).count().finish().select(new String[]{"'0' org", this.AREAS, "count"});
        bankAcctSet = DecisionAnlsHelper.ChangeRowToColDataSet(bankAcctSet, this.AREAS, "org", "");
        bankAcctSet = DecisionAnlsHelper.addAbsentFields(bankAcctSet, Arrays.asList(this.DOMESTIC, this.OVERSEAS));
        DataSet unBankAcctSet = BankAcctHelper.getUnBankAcctSet(splitDataSets);
        unBankAcctSet = unBankAcctSet.groupBy(new String[]{FINORGTYPE}).count().finish().select(new String[]{"'0' org", FINORGTYPE, "count"});
        unBankAcctSet = DecisionAnlsHelper.ChangeRowToColDataSet(unBankAcctSet, FINORGTYPE, "org", "bankcate_");
        unBankAcctSet = DecisionAnlsHelper.addAbsentFields(unBankAcctSet, this.UN_BANK_COLS);
        RowMeta rowMeta = bankAcctSet.getRowMeta();
        if (bankAcctSet.isEmpty()) {
            bankAcctSet = DecisionAnlsHelper.createRowByDefault(rowMeta.getFieldNames(), rowMeta.getDataTypes());
        }
        DataSet resultSet = bankAcctSet.leftJoin(unBankAcctSet).on("org", "org").select(new String[]{"org", this.DOMESTIC, this.OVERSEAS}, this.UN_BANK_COLS.toArray(new String[0])).finish();
        ArrayList<String> allAcctfields = new ArrayList<String>(this.UN_BANK_COLS);
        allAcctfields.addAll(Arrays.asList(this.DOMESTIC, this.OVERSEAS));
        resultSet = DecisionAnlsHelper.updateValueWhenNull(resultSet, allAcctfields);
        resultSet = resultSet.addField(String.join((CharSequence)"+", allAcctfields), "accts");
        if (resultSet.isEmpty()) {
            DataSet ds = DecisionAnlsHelper.creatAbsentRow(resultSet, "org", Collections.singletonList("0"), 0, () -> new Object[]{"", 0, 0, 0, 0, 0, 0, 0});
            return this.addFields(ds);
        }
        return this.addFields(resultSet).updateField("bankcate_999", "bankcate_1+bankcate_999");
    }

    private DataSet addFields(DataSet ds) {
        return ds.addFields(new String[]{DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5883\u5185\u8d26\u6237", (String)"BankAcctDistSumaryRowDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5883\u5916\u8d26\u6237", (String)"BankAcctDistSumaryRowDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8", (String)"BankAcctDistSumaryRowDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"AcctDisplayByBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u8d26\u6237", (String)"AcctDisplayByBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5176\u4ed6\u91d1\u878d\u673a\u6784", (String)"AcctDisplayByBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u8d26\u6237\u603b\u6570", (String)"BankAcctDistSumaryRowDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{"domesticcolumn", "overseascolumn", "fincomcolumn", "settlecolumn", "trdacctcolumn", "othacctcolumn", "acctscolumn"});
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_acctbankarearpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "org";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbankarearpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u5883\u5185\u5916\u5206\u5e03\u8868", (String)"SecCompBankAcctDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }
}

