/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class BankInterfaceOpenRateDataPulgin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String DOMESTIC = "domestic";
    private static final String OVERSEAS = "overseas";
    private static final String ALL = "all";
    private static final String OPENING_RATE = "opening_rate";
    private static final String TOTAL = "total";
    private static final String AREAS = "areas";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{OPENING_RATE, ResManager.loadKDString((String)"\u94f6\u4f01\u5f00\u901a\u7387", (String)"BankInterfaceOpenRateDataPulgin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AREAS, ResManager.loadKDString((String)"\u533a\u57df", (String)"BankInterfaceOpenRateDataPulgin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet bankAcctSet = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap).filter("finorgtype = '0' or finorgtype = '3'").select(new String[]{"id", "finorgtype", "bankinterface", AREAS, "0.0 as opening_rate"});
        bankAcctSet = BasicParamHelper.getBasicParamApplicationConfigs((DataSet)bankAcctSet, (String)"bankapplyconditiontag");
        DataSet[] bankAcctSets = bankAcctSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet bankInterfaceSet = bankAcctSets[0].filter("bankinterface = 'bi_true'");
        bankInterfaceSet = bankInterfaceSet.groupBy(new String[]{AREAS}).count("bankinterface").sum(OPENING_RATE).finish();
        DataSet totalColSet = bankAcctSets[1].groupBy(new String[]{AREAS}).count(TOTAL).finish();
        DataSet resultSet = totalColSet.leftJoin(bankInterfaceSet).on(AREAS, AREAS).select(new String[]{AREAS, "bankinterface", TOTAL, OPENING_RATE}).finish();
        DataSet[] resultSets = resultSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet totalRowSet = resultSets[0].groupBy().sum("bankinterface").sum(TOTAL).sum(OPENING_RATE).finish().select(new String[]{"'all' as areas", "bankinterface", TOTAL, OPENING_RATE});
        resultSet = resultSets[1].union(totalRowSet);
        resultSet = DecisionAnlsHelper.updateValueWhenNull(resultSet, Arrays.asList("bankinterface", TOTAL));
        resultSet = DecisionAnlsHelper.creatAbsentRow(resultSet, AREAS, Arrays.asList(DOMESTIC, OVERSEAS, ALL), 0, () -> new Object[]{"", "0", "0", "0.00"});
        resultSet = resultSet.updateField(OPENING_RATE, "case when (total = 0 or bankInterface = 0) then 0.00 else bankInterface*1.0/total end");
        return resultSet;
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(4, 4);
        }
        return value;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_acctbankinterface_rpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return AREAS;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbankinterface_rpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u94f6\u4f01\u8d26\u6237\u5206\u5e03\u8868", (String)"BankInterfaceOpenRateDataPulgin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }
}

