/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.bankacct.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class SecCompBankAcctDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ORG = "org";
    private static final String ORG_NAME = "org_name";
    private static final String MIX_ORGNAME = "mixorgname";
    private static final String DOMESTIC = "domestic";
    private static final String OVERSEAS = "overseas";
    private static final String AREAS = "areas";
    private static final List<String> sumFields = Arrays.asList("domestic", "overseas");

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{ORG, ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8ID", (String)"SecCompBankAcctDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{ORG_NAME, ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8", (String)"SecCompBankAcctDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{MIX_ORGNAME, ResManager.loadKDString((String)"\u5f00\u6237\u516c\u53f8\u7b80\u79f0", (String)"SecCompBankAcctDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DOMESTIC, ResManager.loadKDString((String)"\u5883\u5185", (String)"SecCompBankAcctDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{OVERSEAS, ResManager.loadKDString((String)"\u5883\u5916", (String)"SecCompBankAcctDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"total", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SecCompBankAcctDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        this.getQueryParam(paramMap);
        DataSet query = BankAcctHelper.query(((Object)((Object)this)).getClass().getName(), paramMap);
        DataSet[] acctSets = BankAcctHelper.getAcctSetByFinOrgTypeConfigs(query);
        DataSet acctSet = acctSets[0].union(BankAcctHelper.getUnBankAcctSet(acctSets));
        DataSet bankAcctSet = acctSet.select(new String[]{ORG, AREAS}).addField("1", "count");
        bankAcctSet = bankAcctSet.groupBy(new String[]{ORG, AREAS}).sum("count").finish();
        bankAcctSet = DecisionAnlsHelper.ChangeRowToColDataSet(bankAcctSet, AREAS, ORG, "");
        bankAcctSet = DecisionAnlsHelper.addAbsentFields(bankAcctSet, sumFields);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinSet = orgDateSet.leftJoin(bankAcctSet).on(ORG, ORG).select(new String[]{ORG, "rowid", "pid", "isgroupnode", "level", MIX_ORGNAME, "orgname as org_name", DOMESTIC, OVERSEAS}).finish().addField("0", "sumlevel");
        DataSet sumResultSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinSet, sumFields, String.join((CharSequence)",", ORG, ORG_NAME, MIX_ORGNAME));
        List subOrgIds = EmptyUtil.isNoEmpty((Object)paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumResultSet = sumResultSet.where("org in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        DataSet resultSet = sumResultSet.filter("domestic > 0 or overseas > 0").addField("domestic+overseas", "total").orderBy(new String[]{"total desc"});
        return resultSet;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_acctbankarearpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return ORG;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_acctbankarearpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u5355\u4f4d\u5206\u5e03\u8868", (String)"SecCompBankAcctDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }

    private void getQueryParam(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get(ORG)).getLong("id");
        List allorgids = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        paramMap.put("allorgids", allorgids);
        OrgTreeParam filterParam = new OrgTreeParam();
        filterParam.setOrgViewId(orgViewId.longValue());
        filterParam.setId(orgId.longValue());
        List subOrgMap = OrgUnitServiceHelper.getTreeChildrenMap((OrgTreeParam)filterParam);
        if (subOrgMap != null && subOrgMap.size() > 0) {
            List subOrgIds = subOrgMap.stream().map(o -> (Long)o.get("id")).collect(Collectors.toList());
            paramMap.put("suborgids", subOrgIds);
        }
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setCaption(ResManager.loadKDString((String)"\u8d26\u6237\u5355\u4f4d\u5206\u5e03\u8868", (String)"SecCompBankAcctDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
    }
}

