/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashCateDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COMPANY = "company";
    private static final String FUND_TYPE = "fundtype";
    private static final String BALANCE = "statbalance";
    private static final String BALANCE_MULTIPLY_RATE = "statbalancerate";
    private static final String RATE = "frate";
    private static final String ROWID = "rowid";
    private static final String IS_OFFSET = "isoffset";
    private static final List<String> PROFIT_LIST = Arrays.asList("noticeprofit", "fixprofit", "structprofit", "hugeprofit", "financeprofit", "statprofit");

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        DataSet ds = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true);
        return this.groupCashCategory(ds);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet[] splitDs = ds.copy().splitByFilter(new String[]{"isoffset='1'"}, true);
        DataSet offsetDs = splitDs[0].updateField(COMPANY, ((DynamicObject)parentOrgs.get(0)).getString("id"));
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        DataSet allDs = this.groupby(ds, new String[]{COMPANY});
        List<String> sumFields = this.getSumField();
        String[] selectFields = DecisionAnlsHelper.getSelectField(sumFields);
        offsetDs = offsetDs.leftJoin(orgDs).on(COMPANY, ROWID).select(selectFields).finish();
        allDs = orgDs.leftJoin(allDs).on(ROWID, COMPANY).select(selectFields).finish();
        offsetDs = offsetDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode", BALANCE, "accountbalance", "noticebalance", "fixbalance", "structbalance", "hugebalance", "financebalance"}, new String[]{ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashCateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "-1", "'0'", "statbalance * (-1)", "accountbalance * (-1)", "noticebalance * (-1)", "fixbalance * (-1)", "structbalance * (-1)", "hugebalance * (-1)", "financebalance * (-1)"});
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("statbalance > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("statbalance > 0");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = sumDataSet.union(offsetDs.select(sumDataSet.getRowMeta().getFieldNames()));
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        DataSet resultDs = sumDataSet.union(totalSet);
        resultDs = this.calculateProfit(resultDs);
        return this.handleProfit(resultDs, this.getNoOffSetProfits(splitDs[1]));
    }

    private String[] getNoOffSetProfits(DataSet noOffSetDs) {
        int len = PROFIT_LIST.size();
        String[] array = new String[len];
        noOffSetDs = this.groupby(noOffSetDs, new String[]{IS_OFFSET});
        if ((noOffSetDs = this.calculateProfit(noOffSetDs)).hasNext()) {
            Row row = noOffSetDs.next();
            for (int i = 0; i < len; ++i) {
                array[i] = DecisionCommonHelper.toPlainString((String)row.getString(PROFIT_LIST.get(i)));
            }
        }
        return array;
    }

    private DataSet calculateProfit(DataSet resultDs) {
        String resultRowFields = String.join((CharSequence)",", resultDs.getRowMeta().getFieldNames()) + ",case when accountbalance=0 then 0 else accountbalancerate*1.0/accountbalance end as accountprofit,case when noticebalance=0 then 0 else noticebalancerate*1.0/noticebalance end as noticeprofit,case when fixbalance=0 then 0 else fixbalancerate*1.0/fixbalance end as fixprofit,case when structbalance=0 then 0 else structbalancerate*1.0/structbalance end as structprofit,case when hugebalance=0 then 0 else hugebalancerate*1.0/hugebalance end as hugeprofit,case when financebalance=0 then 0 else financebalancerate*1.0/financebalance end as financeprofit,0 statprofit,' ' noticeprofitstr, ' ' fixprofitstr, ' ' structprofitstr, ' ' hugeprofitstr, ' ' financeprofitstr, ' ' statprofitstr";
        resultDs = resultDs.select(resultRowFields);
        resultDs = resultDs.updateField("statprofit", "case when (noticebalance+fixbalance+structbalance+hugebalance+financebalance)=0 then 0 else (noticebalancerate+fixbalancerate+structbalancerate+hugebalancerate+financebalancerate)*1.0/(noticebalance+fixbalance+structbalance+hugebalance+financebalance) end");
        return resultDs;
    }

    private DataSet handleProfit(DataSet ds, String[] noOffSetProfits) {
        for (int i = 0; i < PROFIT_LIST.size(); ++i) {
            String profitKey = PROFIT_LIST.get(i);
            ds = ds.updateField(profitKey, String.format("case when (%1$s <0 or sumlevel=-1) then 0.00 when sumlevel=1 then %2$s else %1$s end", profitKey, noOffSetProfits[i]));
        }
        return ds;
    }

    private DataSet groupCashCategory(DataSet allDs) {
        String selectProps = "company,finorgtype, realvalibalance+realrestrictedamt statbalance, frate, isoffset, fundtype";
        allDs = allDs.select(selectProps);
        DataSet groupDs = allDs.groupBy(new String[]{COMPANY, FUND_TYPE, IS_OFFSET}).sum(BALANCE).sum("statbalance*frate", BALANCE_MULTIPLY_RATE).finish().orderBy(new String[]{COMPANY, FUND_TYPE});
        String props = "company,fundtype,isoffset,statbalance,statbalancerate,case when fundtype=0 then statbalance else 0 end as accountbalance,case when fundtype=0 then statbalancerate else 0 end as accountbalancerate,case when fundtype=1 then statbalance else 0 end as noticebalance,case when fundtype=1 then statbalancerate else 0 end as noticebalancerate,case when fundtype=2 then statbalance else 0 end as fixbalance,case when fundtype=2 then statbalancerate else 0 end as fixbalancerate,case when fundtype=3 then statbalance else 0 end as structbalance,case when fundtype=3 then statbalancerate else 0 end as structbalancerate,case when fundtype=4 then statbalance else 0 end as hugebalance,case when fundtype=4 then statbalancerate else 0 end as hugebalancerate,case when fundtype=5 then statbalance else 0 end as financebalance,case when fundtype=5 then statbalancerate else 0 end as financebalancerate";
        groupDs = groupDs.select(props);
        groupDs = this.groupby(groupDs, new String[]{COMPANY, IS_OFFSET});
        return groupDs;
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        ds = ds.groupBy(groups).sum(BALANCE).sum(BALANCE_MULTIPLY_RATE).sum("accountbalance").sum("accountbalancerate").sum("noticebalance").sum("noticebalancerate").sum("fixbalance").sum("fixbalancerate").sum("structbalance").sum("structbalancerate").sum("hugebalance").sum("hugebalancerate").sum("financebalance").sum("financebalancerate").finish().orderBy(groups);
        return ds;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(16);
        fields.add(BALANCE);
        fields.add("accountbalance");
        fields.add("noticebalance");
        fields.add("fixbalance");
        fields.add("structbalance");
        fields.add("hugebalance");
        fields.add("financebalance");
        return fields;
    }

    private List<String> getSumField() {
        ArrayList<String> sumFields = new ArrayList<String>(14);
        sumFields.add(BALANCE);
        sumFields.add("accountbalance");
        sumFields.add("noticebalance");
        sumFields.add("fixbalance");
        sumFields.add("structbalance");
        sumFields.add("hugebalance");
        sumFields.add("financebalance");
        sumFields.add(BALANCE_MULTIPLY_RATE);
        sumFields.add("accountbalancerate");
        sumFields.add("noticebalancerate");
        sumFields.add("fixbalancerate");
        sumFields.add("structbalancerate");
        sumFields.add("hugebalancerate");
        sumFields.add("financebalancerate");
        return sumFields;
    }
}

