/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashCateFinanceDateListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String PRODUCT_NAME = "productname";
    private static final String AMOUNT = "amount";
    private static final String BALANCE = "fbalance";
    private static final String BALANCE_MULTIPLY_RATE = "balancerate";
    private static final String RATE = "frate";
    private static final String IS_OFFSET = "isoffset";
    private static final String[] GROUP_BY_ARRAY = new String[]{"productname"};

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet ds = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true).filter("fundtype=" + CashTypeEnum.FINANCE.getNumber()).select("currency, isoffset, productname, depositamountrpt amount, realvalibalance+realrestrictedamt fbalance, frate");
        return this.handleDataSet(ds);
    }

    private DataSet handleDataSet(DataSet allDs) {
        allDs = allDs.groupBy(new String[]{PRODUCT_NAME, IS_OFFSET}).sum(AMOUNT).sum(BALANCE).sum("fbalance*frate", BALANCE_MULTIPLY_RATE).finish();
        DataSet[] splitDs = allDs.copy().splitByFilter(new String[]{"isoffset='1'"}, true);
        DataSet offsetDs = splitDs[0].updateField(PRODUCT_NAME, "' '");
        offsetDs = this.groupByProductName(offsetDs).addField("-1", "sumlevel");
        offsetDs = offsetDs.updateFields(new String[]{PRODUCT_NAME, AMOUNT, BALANCE}, new String[]{ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashCateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "amount*(-1)", "fbalance*(-1)"});
        allDs = this.groupByProductName(allDs).addField("0", "sumlevel");
        allDs = allDs.union(offsetDs.select(allDs.getRowMeta().getFieldNames()));
        DataSet sumDs = allDs.copy().updateField(PRODUCT_NAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashCateFinanceDateListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        sumDs = this.groupByProductName(sumDs).addField("1", "sumlevel");
        DataSet resultDs = allDs.union(sumDs);
        String resultRowFields = String.join((CharSequence)",", resultDs.getRowMeta().getFieldNames()) + ",case when fbalance=0 then 0 else balancerate/fbalance end as profit, ' ' profitstr";
        resultDs = resultDs.select(resultRowFields);
        return this.handleProfit(resultDs, this.calculateProfit(splitDs[1])).addField(PRODUCT_NAME, "mixorgname");
    }

    private DataSet handleProfit(DataSet ds, String noOffSetProfit) {
        ds = ds.updateField("profit", String.format("case when (%1$s <0 or sumlevel=-1) then 0.00 when sumlevel=1 then %2$s else %1$s end", "profit", noOffSetProfit));
        return ds;
    }

    private String calculateProfit(DataSet ds) {
        String profit = "0.0";
        ds = ds.updateField(PRODUCT_NAME, "' '");
        if ((ds = this.groupByProductName(ds).addField("case when fbalance=0 then 0 else balancerate/fbalance end as profit", "profit")).hasNext()) {
            Row row = ds.next();
            profit = row.getString("profit");
        }
        return DecisionCommonHelper.toPlainString((String)profit);
    }

    private DataSet groupByProductName(DataSet ds) {
        ds = ds.groupBy(GROUP_BY_ARRAY).sum(AMOUNT).sum(BALANCE).sum(BALANCE_MULTIPLY_RATE).finish();
        return ds;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(BALANCE);
        fields.add(AMOUNT);
        return fields;
    }
}

