/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.enums.BankCatePropertyEnum;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.cash.helper.CashDistributionByAreaHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDetailDataListPlugin
extends AbstractDetailDataPlugin {
    private static final String DISPLAY_TYPE = "displayType";

    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"CashDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"fundtypevalue", ResManager.loadKDString((String)"\u5b58\u6b3e\u7c7b\u578b", (String)"CashDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(CashTypeEnum.cashTypeEnumItemList())});
        field.add(new Object[]{"detailbillno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"CashDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"productname", ResManager.loadKDString((String)"\u5b58\u6b3e\u54c1\u79cd", (String)"CashDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"CashDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankcateproperty", ResManager.loadKDString((String)"\u94f6\u884c\u6027\u8d28", (String)"CashDetailDataListPlugin_31", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(BankCatePropertyEnum.itemList())});
        field.add(new Object[]{"finorgname", ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784", (String)"CashDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237", (String)"CashDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"acctpropertyname", ResManager.loadKDString((String)"\u8d26\u6237\u7528\u9014", (String)"CashDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"limitusage", ResManager.loadKDString((String)"\u7528\u9014\u53d7\u9650", (String)"CashDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CashDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"CashDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isdomestic_fund", ResManager.loadKDString((String)"\u5883\u5185\u5916", (String)"CashDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("1", this.getDomesticType(), "0", this.getForeignType())});
        field.add(new Object[]{"countryname", ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"CashDetailDataListPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"depositamountoriginal", ResManager.loadKDString((String)"\u5b58\u6b3e\u91d1\u989d", (String)"CashDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"depositamountrpt", ResManager.loadKDString((String)"\u5b58\u6b3e\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"CashDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amountoriginal", ResManager.loadKDString((String)"\u5b58\u6b3e\u4f59\u989d", (String)"CashDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u5b58\u6b3e\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"CashDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realvalibalanceoriginal", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"CashDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realvalibalance", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"CashDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realrestrictedamtoriginal", ResManager.loadKDString((String)"\u53d7\u9650\u91d1\u989d", (String)"CashDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realrestrictedamt", ResManager.loadKDString((String)"\u53d7\u9650\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"CashDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f", (String)"CashDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"bizupdatedate", ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u65f6\u95f4", (String)"CashDetailDataListPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"startdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"CashDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"enddate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"CashDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"deadline", ResManager.loadKDString((String)"\u671f\u9650", (String)"CashDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"interestrate", ResManager.loadKDString((String)"\u5229\u7387%", (String)"CashDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"recentlyrate", ResManager.loadKDString((String)"\u6700\u65b0\u5229\u7387%", (String)"CashDetailDataListPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u62b5\u6d88\u6807\u8bc6", (String)"CashDetailDataListPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        String displayType;
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet usageLimitDs = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        String selectStr = "id,company,fundtypevalue,fundtype,detailbillno,productname,bankname as finorgname,country,countryname,finorgtype,accountbank,bankcateproperty,case when finorgtype = '1' then '%1$s' when finorgtype = '3' then '%2$s' else bankcatename end as bankcatename,bankaccountnumber,acctpropertyname,limitusage,currencyname,rate,isdomestic,isdomestic_fund,depositamountoriginal,depositamountrpt,amount,amountoriginal,realvalibalance,realvalibalanceoriginal,realrestrictedamt,realrestrictedamtoriginal,bizdate,bizupdatedate,startdate,enddate,deadline,interestrate,frate as recentlyrate,isoffset";
        selectStr = String.format(selectStr, FinOrgTypeEnum.CLEARINGHOUSE.getName(), FinOrgTypeEnum.FINCOMP.getName());
        DataSet allDataSet = usageLimitDs.select(selectStr);
        String finance = (String)paramMap.get("finance");
        if (EmptyUtil.isNoEmpty((String)finance)) {
            allDataSet = allDataSet.filter("fundtypevalue='" + CashTypeEnum.FINANCE.getValue() + "'");
        }
        if (EmptyUtil.isNoEmpty((String)(displayType = (String)paramMap.get(DISPLAY_TYPE)))) {
            String filterBankString = String.format("bankcatename not like '%1$s%2$s%3$s'", "%", ResManager.loadKDString((String)"\u4eba\u6c11\u94f6\u884c", (String)"CashBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "%");
            allDataSet = allDataSet.filter(filterBankString);
            List<String> finOrgTypeList = Arrays.asList(FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.FINCOMP.getValue(), FinOrgTypeEnum.CLEARINGHOUSE.getValue());
            allDataSet = allDataSet.filter("finorgtype in finorgtypes", Collections.singletonMap("finorgtypes", finOrgTypeList));
            allDataSet = AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(displayType) ? allDataSet.filter("isdomestic = '1' ") : allDataSet.filter("isdomestic = '0' ");
        }
        allDataSet = allDataSet.addField("case when isoffset = '1' then 1 else 0 end ", "isoffsetNum");
        allDataSet = CashDistributionByAreaHelper.updateCountry(allDataSet);
        return allDataSet;
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("amount", "realvalibalance", "realrestrictedamt");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("detailbillno", "id");
    }

    @Override
    protected List<String> getOrderByList() {
        return Arrays.asList("fundtype", "productname", "bankcatename");
    }

    @Override
    protected Boolean getIsRemoveNoDataFlag() {
        return Boolean.FALSE;
    }

    @Override
    protected String getCountField() {
        return "isoffsetNum";
    }

    @Override
    protected String getNotNullFilterStr() {
        String filterStr = this.getFilterStr(this.getSumLists());
        StringBuilder sb = new StringBuilder("(isgroupnode = '1' or (isgroupnode = '0' and fundtypevalue != null)) and ");
        sb.append("(").append(filterStr).append("or isoffsetNum != 0 ").append("or fundtypevalue = ").append("'").append(CashTypeEnum.ACCOUNT.getValue()).append("'").append(")");
        return sb.toString();
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String fundTypeValue = rowData.getString("fundtypevalue");
            String linkEntity = "cim_deposit";
            if (CashTypeEnum.FINANCE.getValue().equals(fundTypeValue)) {
                linkEntity = "cim_finsubscribe";
            } else if (CashTypeEnum.ACCOUNT.getValue().equals(fundTypeValue)) {
                linkEntity = "bei_bankbalance";
            } else if (CashTypeEnum.NOTICE.getValue().equals(fundTypeValue)) {
                linkEntity = "cim_noticedeposit";
            }
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    private String getDomesticType() {
        return ResManager.loadKDString((String)"\u5883\u5185", (String)"CashDetailDataListPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private String getForeignType() {
        return ResManager.loadKDString((String)"\u5883\u5916", (String)"CashDetailDataListPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]);
    }
}

