/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDistributionByOrgDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COMPANY = "company";
    private static final String REALRESTRICTEDAMT = "realrestrictedamt";
    private static final String REALVALIBALANCE = "realvalibalance";
    private static final String TOTAL_CASH = "totalcash";
    private static final String ISOFFSET = "isoffset";
    private static final List<String> SUM_FIELDS = Arrays.asList("realvalibalance", "realrestrictedamt", "totalcash");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String selectStr = String.join((CharSequence)",", COMPANY, REALVALIBALANCE, REALRESTRICTEDAMT, ISOFFSET);
        List allOrgids = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)allOrgids) && allOrgids.size() > 1) {
            allOrgids.remove(orgId);
        }
        DataSet dataSet = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgids, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true).select(selectStr);
        dataSet = dataSet.groupBy(new String[]{COMPANY, ISOFFSET}).sum(REALRESTRICTEDAMT).sum(REALVALIBALANCE).finish().select(selectStr);
        return dataSet.addField(String.join((CharSequence)"+", REALVALIBALANCE, REALRESTRICTEDAMT), TOTAL_CASH);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(REALRESTRICTEDAMT);
        fields.add(REALVALIBALANCE);
        fields.add(TOTAL_CASH);
        return fields;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        DataSet offsetDataSet = dataSets[1].filter("isoffset= '1'").updateField(COMPANY, currentOrgId.toString());
        offsetDataSet = offsetDataSet.groupBy(new String[]{COMPANY}).sum(REALRESTRICTEDAMT).sum(REALVALIBALANCE).sum(TOTAL_CASH).finish();
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String[] selectFields = DecisionAnlsHelper.getSelectField(SUM_FIELDS);
        selectFields[0] = "mixorgname as orgname";
        offsetDataSet = offsetDataSet.leftJoin(allOrgDataSet).on(COMPANY, "rowid").select(selectFields).finish();
        offsetDataSet = offsetDataSet.updateFields(new String[]{"orgname", REALVALIBALANCE, REALRESTRICTEDAMT, TOTAL_CASH, "isgroupnode", "sumlevel"}, new String[]{ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashCateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "realvalibalance * (-1)", "realrestrictedamt * (-1)", "totalcash * (-1)", "'0'", "0"});
        DataSet allDs = ds.groupBy(new String[]{COMPANY}).sum(REALRESTRICTEDAMT).sum(REALVALIBALANCE).sum(TOTAL_CASH).finish();
        DataSet dataSet = allOrgDataSet.leftJoin(allDs).on("rowid", COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(dataSet, SUM_FIELDS, "orgid,orgname,sortcode");
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        if (EmptyUtil.isNoEmpty((Object)filterOrg)) {
            sumDataSet = sumDataSet.filter("orgid in filterorg", Collections.singletonMap("filterorg", filterOrg));
        }
        sumDataSet = sumDataSet.filter("totalcash != 0 and totalcash != null").orderBy(new String[]{"sortcode"});
        selectFields[0] = "orgname";
        sumDataSet = sumDataSet.select(selectFields).union(offsetDataSet);
        sumDataSet = sumDataSet.addField(String.valueOf(currencyId), "listcurrency");
        DataSet totalDataSet = this.addAllTotalDataSet(sumDataSet, SUM_FIELDS, Collections.singletonList("listcurrency"), "orgname");
        return sumDataSet.union(totalDataSet);
    }
}

