/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDomesticDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COMPANY = "company";
    private static final String IS_OFFSET = "isoffset";
    private static final String BANKCATE_PROPERTY = "bankcateproperty";
    private static final String CURRENCY_NUMBER = "currencynumber";
    private static final String AREA_TYPE = "areatype";
    private static final String AMOUNT = "amount";
    private static final String ROWID = "rowid";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("in_percentage_amount", "cny_valibalance", "hkd_valibalance", "usd_valibalance", "other_valibalance", "subtotal_valibalance", "subtotal_in_bank_amount", "out_percentage_amount", "cny_restricted", "usd_restricted", "hkd_restricted", "other_restricted", "subtotal_restricted", "subtotal_out_bank_amount", "percentage_amount", "cny_total", "hkd_total", "usd_total", "other_total", "subtotal_total", "subtotal_bank_amount");
    private static final List<String> PROFIT_LIST = Arrays.asList("in_percentage", "out_percentage", "percentage");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List allOrgIds = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (allOrgIds != null && allOrgIds.size() > 1) {
            allOrgIds.remove(orgId);
        }
        DataSet allDs = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgIds, (Date)queryDate, (Map)paramMap, (boolean)false, (boolean)true);
        String sic = "company,isoffset,realvalibalance+realrestrictedamt as amount,finorgtype ,case when bankcateproperty is null then '' else bankcateproperty end as bankcateproperty,case when isdomestic_fund = '1' or isdomestic_fund is null then 0 else 1 end as areatype,case when currencynumber != 'CNY' and currencynumber != 'HKD' and currencynumber != 'USD' then 'other' else lower(currencynumber) end as currencynumber";
        allDs = allDs.select(sic);
        return allDs.groupBy(new String[]{COMPANY, IS_OFFSET, BANKCATE_PROPERTY, CURRENCY_NUMBER, AREA_TYPE, "finorgtype"}).sum(AMOUNT).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        ds = this.groupByCurrencyAndArea(ds);
        Map paramMap = this.transQueryParam(param);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet[] splitDs = ds.copy().splitByFilter(new String[]{"isoffset='1'"}, true);
        DataSet offsetDs = splitDs[0].updateField(COMPANY, ((DynamicObject)parentOrgs.get(0)).getString("id"));
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        DataSet allDs = this.groupby(ds, new String[]{COMPANY});
        String[] selectFields = DecisionAnlsHelper.getSelectField(AMOUNT_FIELDS);
        offsetDs = offsetDs.leftJoin(orgDs).on(COMPANY, ROWID).select(selectFields).finish();
        allDs = orgDs.leftJoin(allDs).on(ROWID, COMPANY).select(selectFields).finish();
        offsetDs = offsetDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode"}, new String[]{ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashCateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "-1", "'0'"});
        offsetDs = offsetDs.updateFields(AMOUNT_FIELDS.toArray(new String[0]), this.negativeAmountFields());
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, AMOUNT_FIELDS, "mixorgname,orgid,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("subtotal_total > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("subtotal_total > 0");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        sumDataSet = sumDataSet.union(offsetDs.select(sumDataSet.getRowMeta().getFieldNames()));
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), AMOUNT_FIELDS, "mixorgname");
        DataSet resultDs = sumDataSet.union(totalSet);
        resultDs = this.calculateProfit(resultDs);
        return this.handleProfit(resultDs, this.getNoOffSetProfits(splitDs[1]));
    }

    private DataSet calculateProfit(DataSet resultDs) {
        String resultRowFields = String.join((CharSequence)",", resultDs.getRowMeta().getFieldNames()) + ",case when subtotal_in_bank_amount=0 then 0.00 else in_percentage_amount*1.0/subtotal_in_bank_amount end as in_percentage,case when subtotal_out_bank_amount=0 then 0.00 else out_percentage_amount*1.0/subtotal_out_bank_amount end as out_percentage,case when subtotal_bank_amount=0 then 0.00 else percentage_amount*1.0/subtotal_bank_amount end as percentage";
        return resultDs.select(resultRowFields);
    }

    private DataSet handleProfit(DataSet ds, String[] noOffSetProfits) {
        for (int i = 0; i < PROFIT_LIST.size(); ++i) {
            String profitKey = PROFIT_LIST.get(i);
            ds = ds.updateField(profitKey, String.format("case when (%1$s <0 or sumlevel=-1) then 0.00 when sumlevel=1 then %2$s else %1$s end", profitKey, noOffSetProfits[i]));
        }
        ds = ds.updateFields(new String[]{"in_percentage", "out_percentage", "percentage"}, new String[]{"case when in_percentage is null then 0.00 else in_percentage end", "case when out_percentage is null then 0.00 else out_percentage end", "case when percentage is null then 0.00 else percentage end"});
        return ds.addFields(new String[]{"concat(round(in_percentage*100, 2), '%')", "concat(round(out_percentage*100, 2), '%')", "concat(round(percentage*100, 2), '%')"}, new String[]{"in_percentage_str", "out_percentage_str", "percentage_str"});
    }

    private String[] getNoOffSetProfits(DataSet noOffSetDs) {
        int len = PROFIT_LIST.size();
        String[] array = new String[len];
        noOffSetDs = this.groupby(noOffSetDs, new String[]{IS_OFFSET});
        if ((noOffSetDs = this.calculateProfit(noOffSetDs)).hasNext()) {
            Row row = noOffSetDs.next();
            for (int i = 0; i < len; ++i) {
                array[i] = DecisionCommonHelper.toPlainString((String)row.getString(PROFIT_LIST.get(i)));
            }
        }
        return array;
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(AMOUNT_FIELDS);
    }

    private DataSet groupByCurrencyAndArea(DataSet ds) {
        String props = "company,isoffset,case when finorgtype='0' and bankcateproperty='1' and areatype=0 then amount else 0 end as in_percentage_amount,case when currencynumber='cny' and areatype=0 then amount else 0 end as cny_valibalance,case when currencynumber='hkd' and areatype=0 then amount else 0 end as hkd_valibalance,case when currencynumber='usd' and areatype=0 then amount else 0 end as usd_valibalance,case when currencynumber='other' and areatype=0 then amount else 0 end as other_valibalance,case when areatype=0 then amount else 0 end as subtotal_valibalance,case when areatype=0 and finorgtype='0' then amount else 0 end as subtotal_in_bank_amount,case when finorgtype='0' and bankcateproperty='1' and areatype=1 then amount else 0 end as out_percentage_amount,case when currencynumber='cny' and areatype=1 then amount else 0 end as cny_restricted,case when currencynumber='hkd' and areatype=1 then amount else 0 end as hkd_restricted,case when currencynumber='usd' and areatype=1 then amount else 0 end as usd_restricted,case when currencynumber='other' and areatype=1 then amount else 0 end as other_restricted,case when areatype=1 then amount else 0 end as subtotal_restricted,case when areatype=1 and finorgtype='0' then amount else 0 end as subtotal_out_bank_amount,case when finorgtype='0' and bankcateproperty='1' then amount else 0 end as percentage_amount,case when currencynumber='cny' then amount else 0 end as cny_total,case when currencynumber='hkd' then amount else 0 end as hkd_total,case when currencynumber='usd' then amount else 0 end as usd_total,case when currencynumber='other' then amount else 0 end as other_total,amount as subtotal_total,case when finorgtype='0' then amount else 0 end as subtotal_bank_amount";
        ds = ds.select(props);
        return this.groupby(ds, new String[]{COMPANY, IS_OFFSET});
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        GroupbyDataSet groupbyDs = ds.groupBy(groups);
        for (String amountField : AMOUNT_FIELDS) {
            groupbyDs = groupbyDs.sum(amountField);
        }
        return groupbyDs.finish().orderBy(groups);
    }

    private String[] negativeAmountFields() {
        String[] array = new String[AMOUNT_FIELDS.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = AMOUNT_FIELDS.get(i) + "* (-1)";
        }
        return array;
    }
}

