/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDistributionByAreaHelper {
    private static String ALGO_KEY = "FundDistributionByArea";
    private static String ORG = "org";
    private static String MIX_ORGNAME = "mixorgname";
    private static String ROWID = "rowid";
    private static String PID = "pid";
    private static String ISGROUPNODE = "isgroupnode";
    private static String LEVEL = "level";
    private static String COUNTRY = "country";
    private static String COUNTRY_NAME = "countryname";
    public static String BALANCE = "balance";
    public static String AREA_PREFIX = "area_";
    public static String IS_OFFSET = "isoffset";

    public static DataSet query(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIds) && orgIds.size() > 1) {
            orgIds.remove(orgId);
        }
        DataSet balanceDataSet = CashFundsDataHelper.getFundDataSet((String)ALGO_KEY, (List)orgIds, (Date)DecisionAnlsHelper.getQueryDate(paramMap), paramMap, (boolean)false, (boolean)true).select(new String[]{"company org", "currency", COUNTRY, COUNTRY_NAME, "amount balance", IS_OFFSET});
        RowMeta rowMeta = balanceDataSet.getRowMeta();
        if (balanceDataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        return CashDistributionByAreaHelper.updateCountry(balanceDataSet);
    }

    public static DataSet updateCountry(DataSet ds) {
        String countryExpr = "case when country = null or country = 0 then 1000001L else country end";
        String countryNameExpr = "case when country = null or country = 0 or country = 1000001 then '" + CashDistributionByAreaHelper.getKdString() + "' else countryname end";
        return ds.updateFields(new String[]{COUNTRY, COUNTRY_NAME}, new String[]{countryExpr, countryNameExpr});
    }

    private static String getKdString() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u5927\u9646", (String)"CashDistributionByAreaDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static DataSet processDataSet(DataSet dataSet, Map<String, Object> reportQueryMap) {
        dataSet = dataSet.groupBy(new String[]{ORG, COUNTRY}).sum(BALANCE).finish();
        dataSet = dataSet.addField("case when true then balance end", "count");
        dataSet = DecisionAnlsHelper.ChangeRowToColDataSet(dataSet, COUNTRY, ORG, AREA_PREFIX);
        Long orgViewId = ((DynamicObject)reportQueryMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet leftJoinSet = orgDateSet.leftJoin(dataSet).on(ORG, ORG).select(new String[]{ORG, ROWID, PID, ISGROUPNODE, LEVEL, MIX_ORGNAME, "sortcode"}, CashDistributionByAreaHelper.getCountFields(dataSet).toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumResultSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinSet, CashDistributionByAreaHelper.getCountFields(leftJoinSet), TmcBusinessBaseHelper.listToString(Arrays.asList(ORG, MIX_ORGNAME, "sortcode")));
        return sumResultSet;
    }

    public static DataSet filterResultDataSet(DataSet sumResultSet, Map<String, Object> paramMap) {
        List subOrgIds = EmptyUtil.isNoEmpty((Object)paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumResultSet = sumResultSet.where("org in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        return sumResultSet;
    }

    public static List<String> getCountFields(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> countFilds = new ArrayList<String>();
        Arrays.stream(fieldNames).forEach(fieldName -> {
            if (fieldName.startsWith(AREA_PREFIX)) {
                countFilds.add((String)fieldName);
            }
        });
        return countFilds;
    }
}

