/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashBalanceAvailableQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String CURRENCY_NAME = "currencyname";
    private static final String CURRENCY_TYPE = "currencytype";
    private static final String AMOUNT = "amount";
    private static final String VALIBALANCE = "valibalance";
    private static final String REALRESTRICTEDAMT = "realrestrictedamt";
    private static final String RATE = "frate";
    private static final String TOTAL_PROFIT = "totalprofit";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{CURRENCY_NAME, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CashTotalAmountQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u8d44\u91d1\u603b\u989d", (String)"CashTotalAmountQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{VALIBALANCE, ResManager.loadKDString((String)"\u53ef\u7528\u8d44\u91d1", (String)"CashTotalAmountQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{REALRESTRICTEDAMT, ResManager.loadKDString((String)"\u53d7\u9650\u8d44\u91d1", (String)"CashTotalAmountQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{CURRENCY_TYPE, ResManager.loadKDString((String)"\u5e01\u79cd\u79cd\u7c7b", (String)"CashTotalAmountQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{TOTAL_PROFIT, ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"CashTotalAmountQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"validcolumn", ResManager.loadKDString((String)"\u53ef\u7528\u8d44\u91d1\u5217", (String)"CashTotalAmountQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"realrestrictedcolumn", ResManager.loadKDString((String)"\u53d7\u9650\u8d44\u91d1\u5217", (String)"CashTotalAmountQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"totalprofitcolumn", ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387\u5217", (String)"CashTotalAmountQingAnlsPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List<Long> orgIds = this.getOrgIds(paramMap);
        DataSet ds = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true);
        ds = ds.filter("isoffset = '0' ");
        String sic = "frate,realvalibalance as valibalance,realrestrictedamt,realvalibalance+realrestrictedamt amount,case when fundtype=0 then fundtype else 1 end as fundtype,case when currencynumber = 'CNY' then 0 when currencynumber = 'USD' then 1 when currencynumber = 'HKD' then 2 else 3 end as currencytype";
        ds = ds.select(sic);
        ds = ds.groupBy(new String[]{"fundtype", CURRENCY_TYPE}).sum(AMOUNT).sum(VALIBALANCE).sum(REALRESTRICTEDAMT).sum("amount*frate", "balancerate").finish();
        ds = DecisionAnlsHelper.creatAbsentRow(ds, CURRENCY_TYPE, Arrays.asList("0", "1", "2", "3"), 1, () -> new Object[]{"0", "", 0.0, 0.0, 0.0, 0.0});
        ds = this.addTotalProfit(ds);
        ds = ds.groupBy(new String[]{CURRENCY_TYPE, TOTAL_PROFIT}).sum(AMOUNT).sum(VALIBALANCE).sum(REALRESTRICTEDAMT).finish().orderBy(new String[]{CURRENCY_TYPE});
        String currencyNameStr = String.format("case when currencytype=0 then '%1$s' when currencytype=1 then '%2$s' when currencytype=2 then '%3$s' else '%4$s' end", CurrencyTypeEnum.CNY.getName(), CurrencyTypeEnum.USD.getName(), CurrencyTypeEnum.HKD.getName(), CurrencyTypeEnum.OTHER.getName());
        return ds.addFields(new String[]{currencyNameStr, DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u53ef\u7528\u8d44\u91d1", (String)"CashTotalAmountQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u53d7\u9650\u8d44\u91d1", (String)"CashTotalAmountQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5e73\u5747\u6536\u76ca\u7387", (String)"CashTotalAmountQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{CURRENCY_NAME, "validcolumn", "realrestrictedcolumn", "totalprofitcolumn"});
    }

    private DataSet addTotalProfit(DataSet ds) {
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        String profit = DecisionCommonHelper.toPlainString((String)this.getTotalProfit(dataSets[1]));
        return ds.addField(profit, TOTAL_PROFIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTotalProfit(DataSet ds) {
        String profit = "0.0";
        try {
            ds = ds.filter("fundtype=1").groupBy().sum(AMOUNT).sum("balancerate").finish();
            ds = ds.select("case when amount=0 then 0.0 else balancerate/amount end as profit");
            Iterator iterator = ds.iterator();
            if (iterator.hasNext()) {
                profit = ((Row)iterator.next()).getString("profit");
            }
        }
        finally {
            ds.close();
        }
        return profit;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> amountFields = new HashSet<String>(8);
        amountFields.add(AMOUNT);
        amountFields.add(VALIBALANCE);
        amountFields.add(REALRESTRICTEDAMT);
        return amountFields;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_cashbalanceavailrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CURRENCY_NAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tda_cashbalanceavailrpt");
        this.fireLinkageShowForm(view, param);
    }
}

