/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.report.cash.helper.CashDistributionByAreaHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;

public class CashDistributionByAreaDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final Log logger = LogFactory.getLog(CashDistributionByAreaDataPlugin.class);
    private static String COUNTRY = "country";
    private static String COUNTRY_NAME = "countryname";
    private static int TOP_NUM = 15;
    private static String TOP_NUM_STR = "topNum";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{COUNTRY, ResManager.loadKDString((String)"\u56fd\u5bb6", (String)"CashDistributionByAreaDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{COUNTRY_NAME, ResManager.loadKDString((String)"\u56fd\u5bb6\u540d\u79f0", (String)"CashDistributionByAreaDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{CashDistributionByAreaHelper.BALANCE, ResManager.loadKDString((String)"\u5f53\u524d\u4f59\u989d", (String)"CashDistributionByAreaDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"CashBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        DataSet query = CashDistributionByAreaHelper.query(paramMap);
        if (query.copy().isEmpty()) {
            logger.info("\u5934\u5bf8\u533a\u57df\u5206\u5e03 -- \u5934\u5bf8\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return query;
        }
        query = query.filter("isoffset != '1'").groupBy(new String[]{COUNTRY, COUNTRY_NAME}).sum(CashDistributionByAreaHelper.BALANCE).finish();
        return this.getTopDataSet(query);
    }

    private DataSet getTopDataSet(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        DataSet topSet = dataSet.orderBy(new String[]{CashDistributionByAreaHelper.BALANCE + " desc"}).addBalanceField("1", TOP_NUM_STR);
        DataSet[] splitSet = topSet.splitByFilter(new String[]{TOP_NUM_STR + " <= " + TOP_NUM}, true);
        String otherCountry = ResManager.loadKDString((String)"\u5176\u4ed6\u56fd\u5bb6", (String)"CashDistributionByAreaDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet otherSet = splitSet[1].groupBy().sum(CashDistributionByAreaHelper.BALANCE).finish().addFields(new String[]{"0L", "'" + otherCountry + "'"}, new String[]{COUNTRY, COUNTRY_NAME}).select(fieldNames);
        DataSet resultSet = splitSet[0].select(fieldNames);
        return resultSet.union(otherSet);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_cashdisbyarearpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return COUNTRY_NAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_cashdisbyarearpt");
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(CashDistributionByAreaHelper.BALANCE);
    }
}

