/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.CashFundsDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashDomesticAndForeignQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String CURRENCY = "currency";
    private static final String AMOUNT = "amount";
    private static final String AREATYPE = "areatype";
    private static final String VALIBALANCE = "valibalance";
    private static final String REALRESTRICTEDAMT = "realrestrictedamt";

    public static String getDomesticType() {
        return ResManager.loadKDString((String)"\u5883\u5185\u8d44\u91d1", (String)"CashDomesticAndForeignQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static String getForeignType() {
        return ResManager.loadKDString((String)"\u5883\u5916\u8d44\u91d1", (String)"CashDomesticAndForeignQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{CURRENCY, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CashDomesticAndForeignQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u8d44\u91d1\u603b\u989d", (String)"CashDomesticAndForeignQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{AREATYPE, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b", (String)"CashDomesticAndForeignQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List<Long> orgIds = this.getOrgIds(paramMap);
        DataSet usageLimitDs = CashFundsDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)false, (boolean)true).filter("isoffset = '0' ");
        String props = "currency,realvalibalance as valibalance,realrestrictedamt,case when isdomestic_fund = '1' or isdomestic_fund is null then 0 else 1 end as areatype";
        usageLimitDs = usageLimitDs.select(props).groupBy(new String[]{CURRENCY, AREATYPE}).sum(VALIBALANCE).sum(REALRESTRICTEDAMT).finish();
        usageLimitDs = usageLimitDs.addField("valibalance + realrestrictedamt", AMOUNT);
        usageLimitDs = DecisionAnlsHelper.creatAbsentRow(usageLimitDs, AREATYPE, Arrays.asList("0", "1"), 1, () -> new Object[]{"0", "", 0.0, 0.0, 0.0});
        String nameStr = String.format("case when areatype=0 then '%1$s' else '%2$s' end", CashDomesticAndForeignQingAnlsPlugin.getDomesticType(), CashDomesticAndForeignQingAnlsPlugin.getForeignType());
        return usageLimitDs.updateField(AREATYPE, nameStr);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("tda_cashdomandforrpt");
        list.add("tda_cashdomandforrpt2");
        return list;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return AREATYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public String getShowFormId() {
        return "tda_cashdomandforrpt2";
    }
}

