/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CollFundTotalAmtDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(CollFundTotalAmtDataListPlugin.class);
    private static final String AREA_ALL = "2";
    private static final String IS_OFF_SET = "isoffset";
    private static final String ORGID = "orgid";
    private static final String COMPANY = "company";
    private static final String AMOUNT = "amount";
    private static final String FINANCEAMOUNT = "financeamount";
    private static final String COMPANYAMOUNT = "companyamount";
    private static final String COLLECTAMOUNT = "collectamount";
    private static final String COLLECTABLEAMOUNT = "collectableamount";
    private static final String NOCOLLECTAMOUNT = "nocollectamount";
    private static final String UNCOLLECTAMOUNT = "uncollectamount";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("amount", "financeamount", "companyamount", "collectamount", "collectableamount", "nocollectamount", "uncollectamount");
    private static final List<String> OFFSET_FIELDS = Arrays.asList("amount", "collectableamount", "nocollectamount", "uncollectamount");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet ds = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIds, queryDate, paramMap, true);
        ds = ds.updateField("isdomestic", "case when isdomestic is null then '1' else isdomestic end");
        ds = this.groupby(ds, new String[]{COMPANY, "isdomestic", "term", IS_OFF_SET});
        return ds;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        ds = this.filterByParam(ds, paramMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List orgIdSet = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIdSet) && orgIdSet.size() > 1) {
            orgIdSet.remove(orgId);
        }
        DataSet offsetDs = ds.filter("isoffset='1'").filter("company in suborgids", Collections.singletonMap("suborgids", orgIdSet)).updateField(COMPANY, orgId.toString());
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        ds = this.groupby(ds, new String[]{COMPANY});
        String[] offsetFields = DecisionAnlsHelper.getSelectField(OFFSET_FIELDS);
        offsetDs = offsetDs.leftJoin(allOrgDataSet).on(COMPANY, ORGID).select(offsetFields).finish();
        String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CollFundTotalAmtDataListPlugin_00", (String)"tmc-tda-report", (Object[])new Object[0]);
        offsetDs = offsetDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode", AMOUNT, COLLECTABLEAMOUNT, NOCOLLECTAMOUNT, UNCOLLECTAMOUNT}, new String[]{'\'' + offsetName + '\'', "0", "'0'", "amount * (-1)", "collectableamount * (-1)", "collectableamount * (-1)", "uncollectamount * (-1)"});
        String[] selectFields = DecisionAnlsHelper.getSelectField(AMOUNT_FIELDS);
        DataSet dataSet = allOrgDataSet.leftJoin(ds).on("rowid", COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(dataSet, AMOUNT_FIELDS, "orgid,mixorgname,sortcode");
        sumDataSet = DecisionAnlsHelper.removeNoDataTreeDs(sumDataSet, AMOUNT_FIELDS, false);
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("orgid in filterorg", Collections.singletonMap("filterorg", filterOrg)).orderBy(new String[]{"sortcode"});
        sumDataSet = sumDataSet.addFields(new String[]{"case when amount is null or amount = 0 then 0.00 else collectamount/amount*100 end", "case when collectableamount is null or collectableamount = 0 then 0.00 else collectamount/collectableamount*100 end"}, new String[]{"allfundrate", "fundrate"});
        offsetDs = offsetDs.addFields(new String[]{"0", "0", "0", "0", "0"}, new String[]{"allfundrate", "fundrate", FINANCEAMOUNT, COMPANYAMOUNT, COLLECTAMOUNT});
        sumDataSet = sumDataSet.union(offsetDs.select(sumDataSet.getRowMeta().getFieldNames()));
        Long currencyId = (Long)paramMap.get("basecurrency");
        sumDataSet = sumDataSet.addField(String.valueOf(currencyId), "listcurrency");
        DataSet totalDataSet = this.addAllTotalDataSet(sumDataSet, AMOUNT_FIELDS, Collections.singletonList("listcurrency"), "orgname");
        totalDataSet = totalDataSet.updateFields(new String[]{"allfundrate", "fundrate"}, new String[]{"case when amount is null or amount = 0 then 0.00 else collectamount/amount*100 end", "case when collectableamount is null or collectableamount = 0 then 0.00 else collectamount/collectableamount*100 end"});
        return sumDataSet.union(totalDataSet);
    }

    private DataSet filterByParam(DataSet ds, Map<String, Object> paramMap) {
        String termDate = (String)paramMap.get("ccrdate");
        String isDomestic = (String)paramMap.get("isdomestic");
        LOGGER.info("CollFundTotalAmtDataListPlugin filterResultDataSet param termDate: " + termDate + " isDomestic: " + isDomestic);
        if (EmptyUtil.isEmpty((String)termDate)) {
            DateRangeEnum rangeEnum = DateRangeEnum.getEnumByValue((String)DateRangeEnum.MONTH.getValue());
            Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
            termDate = FinanceCostDateHelper.getDateCaption((Date)queryDate, (String)rangeEnum.getValue(), (String)rangeEnum.getShortName(), (int)0);
        }
        if (EmptyUtil.isEmpty((String)isDomestic)) {
            isDomestic = AREA_ALL;
        }
        StringBuilder condition = new StringBuilder("term").append(" = '").append(termDate).append("'");
        if (!AREA_ALL.equals(isDomestic)) {
            condition.append(" and isdomestic = '").append(isDomestic).append("'");
        }
        ds = ds.filter(condition.toString());
        return ds;
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(AMOUNT_FIELDS);
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        ds = ds.groupBy(groups).sum(AMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(COLLECTAMOUNT).sum(COLLECTABLEAMOUNT).sum(NOCOLLECTAMOUNT).sum(UNCOLLECTAMOUNT).finish();
        return ds;
    }
}

