/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundDistByAreaDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String COLLECT_AMOUNT = "collamt";
    private static final String COLLECTABLE_AMOUNT = "collableamt";
    private static final String TOTAL_COLLECT_AMOUNT = "totalcollamt";
    private static final String TOTAL_COLLECTABLE_AMOUNT = "totalcollableamt";
    private static final String TOTAL = "total";
    private static final String AREA = "area";
    private static final String CITYNAME = "cityname";
    private static final String COUNTRYNAME = "countryname";
    private static final String RANK = "rank";
    private static final String AREA_TYPE = "areatype";
    private static final String FUND_RATIO = "colfundratio";
    private static final String FUND_CON_RATIO = "colfundconratio";
    private static final String AREA_PREFIX = "area_";
    private static final String ISOFFSET = "isoffset";
    private List<String> sumFields;
    private List<String> amountFields;
    private List<String> collectableAmountFields;

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIdSet = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet fundDataSet = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIdSet, queryDate, paramMap, false).select("company orgid, collectamount collamt, collectableamount collableamt, countryname, cityname, isoffset");
        fundDataSet = fundDataSet.filter("collableamt > 0");
        return fundDataSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        DataSet rankRow;
        Map paramMap = this.transQueryParam(queryParam);
        String areaType = (String)paramMap.get(AREA_TYPE);
        DataSet[] dataSets = DataSetHelper.copy((DataSet)dataSet);
        if ("1".equals(areaType)) {
            rankRow = this.createRankRow(CITYNAME, dataSets[0]);
            dataSet = dataSets[1].leftJoin(rankRow).on(CITYNAME, CITYNAME).select(new String[]{CITYNAME, "orgid", COLLECT_AMOUNT, COLLECTABLE_AMOUNT, ISOFFSET, RANK}).finish();
            String otherCity = ResManager.loadKDString((String)"\u5176\u4ed6\u57ce\u5e02", (String)"FundDistByAreaDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
            dataSet = dataSet.addField("case when cityname is null then '" + otherCity + "' else cityname end", AREA);
        } else {
            rankRow = this.createRankRow(COUNTRYNAME, dataSets[0]);
            dataSet = dataSets[1].leftJoin(rankRow).on(COUNTRYNAME, COUNTRYNAME).select(new String[]{COUNTRYNAME, "orgid", COLLECT_AMOUNT, COLLECTABLE_AMOUNT, ISOFFSET, RANK}).finish();
            String country = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FundDistByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
            dataSet = dataSet.addField("case when countryname is null then '" + country + "' else countryname end", AREA);
        }
        DataSet collFundSet = this.processDataSet(dataSet, paramMap);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)subOrgIds)) {
            collFundSet = collFundSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("totalcollableamt > 0 or orgid = 0");
        } else {
            subOrgIds.add(0L);
            collFundSet = collFundSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("totalcollableamt > 0 or orgid = 0");
        }
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(collFundSet, this.sumFields, "mixorgname");
        DataSet resultSet = collFundSet.union(totalDataSet);
        List<Object> sqlList = new ArrayList(this.amountFields.size() * 2);
        sqlList.addAll(this.amountFields.stream().map(s -> "case when " + s + " IS NULL or " + s + " = 0 then 0.00 else " + s + "/" + TOTAL_COLLECT_AMOUNT + "*100 end").collect(Collectors.toList()));
        sqlList.addAll(this.amountFields.stream().map(s -> "case when " + s + " IS NULL or " + s + " = 0 or " + s.replace(COLLECT_AMOUNT, COLLECTABLE_AMOUNT) + " = 0 then 0.00 else " + s + "/" + s.replace(COLLECT_AMOUNT, COLLECTABLE_AMOUNT) + "*100 end").collect(Collectors.toList()));
        sqlList = sqlList.stream().map(s -> "concat(round(" + s + ", 2), '%')").collect(Collectors.toList());
        ArrayList ratioList = new ArrayList(this.amountFields.size() * 2);
        ratioList.addAll(this.amountFields.stream().map(s -> s.replace(COLLECT_AMOUNT, FUND_RATIO)).collect(Collectors.toList()));
        ratioList.addAll(this.amountFields.stream().map(s -> s.replace(COLLECT_AMOUNT, FUND_CON_RATIO)).collect(Collectors.toList()));
        resultSet = resultSet.addFields(sqlList.toArray(new String[0]), ratioList.toArray(new String[0]));
        return resultSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> hashSet = new HashSet<String>(this.amountFields);
        hashSet.addAll(this.collectableAmountFields);
        return hashSet;
    }

    @Override
    protected Set<String> getRemoveAllZoreFields() {
        return new HashSet<String>(this.amountFields);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map areaMap = (Map)this.getQueryParam().getCustomParam().get("areaMap");
        if (areaMap.isEmpty()) {
            return columns;
        }
        areaMap.put(TOTAL, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InvestRateTrendDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        for (String amountField : this.amountFields) {
            String groupKey = amountField.startsWith(TOTAL) ? TOTAL : amountField.split("_")[1];
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            if (groupKey != null) {
                group.setFieldKey(groupKey);
                group.setCaption(new LocaleString((String)areaMap.get(groupKey)));
            } else {
                group.setFieldKey("");
                group.setCaption(new LocaleString(""));
            }
            if (TOTAL.equals(groupKey)) {
                FundDistByAreaDataListPlugin.addTotalChildren(group);
            } else {
                FundDistByAreaDataListPlugin.addChildren(group, groupKey);
            }
            columns.add((AbstractReportColumn)group);
        }
        return columns;
    }

    private DataSet processDataSet(DataSet dataSet, Map<String, Object> paramMap) {
        DataSet[] splits = dataSet.splitByFilter(new String[]{"isoffset IN ('0','1')", "isoffset = '1'"}, false);
        DataSet areaSet = splits[0].groupBy(new String[]{AREA, "orgid", RANK}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish();
        areaSet = this.areaConvert(areaSet, false);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<String> sumFields = this.getSumField(areaSet);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet orgJoinSet = orgDateSet.leftJoin(areaSet).on("orgid", "orgid").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumFields, "sortcode,orgid,mixorgname");
        sumDataSet = sumDataSet.filter("totalcollableamt IS NOT NULL");
        DataSet offsetRow = this.getOffsetRow(paramMap, splits[1], sumFields);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"});
        return sumDataSet.union(offsetRow.select(sumDataSet.getRowMeta().getFieldNames()));
    }

    private DataSet areaConvert(DataSet dataSet, boolean isOffset) {
        DataSet[] areaGroupSet = dataSet.copy().splitByGroup(new String[]{AREA});
        DataSet baseSet = dataSet.groupBy(new String[]{"orgid"}).sum(COLLECT_AMOUNT, TOTAL_COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT, TOTAL_COLLECTABLE_AMOUNT).finish();
        HashSet hashCodes = new HashSet(16);
        if (!isOffset) {
            HashMap<String, String> fieldMap = new HashMap<String, String>(16);
            String[] amountFieldRank = new String[areaGroupSet.length + 1];
            this.collectableAmountFields = new ArrayList<String>(areaGroupSet.length + 1);
            for (DataSet areaSet : areaGroupSet) {
                DataSet sumSet = areaSet.copy().groupBy().sum(COLLECT_AMOUNT).finish().filter("collamt > 0");
                if (sumSet.isEmpty()) continue;
                Row row = areaSet.copy().next();
                String areaName = row.getString(AREA);
                int hashCode = this.getHashCode(hashCodes, areaName);
                String collectFieldName = AREA_PREFIX + hashCode + "_" + COLLECT_AMOUNT;
                String collectableFieldName = AREA_PREFIX + hashCode + "_" + COLLECTABLE_AMOUNT;
                areaSet = areaSet.groupBy(new String[]{"orgid"}).sum(COLLECT_AMOUNT, collectFieldName).sum(COLLECTABLE_AMOUNT, collectableFieldName).finish();
                baseSet = baseSet.leftJoin(areaSet).on("orgid", "orgid").select(baseSet.getRowMeta().getFieldNames(), new String[]{collectFieldName, collectableFieldName}).finish();
                this.collectableAmountFields.add(collectableFieldName);
                fieldMap.put(String.valueOf(hashCode), areaName);
                String otherCity = ResManager.loadKDString((String)"\u5176\u4ed6\u57ce\u5e02", (String)"FundDistByAreaDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
                String country = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FundDistByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
                if (otherCity.equals(areaName)) {
                    amountFieldRank[amountFieldRank.length - 2] = collectFieldName;
                    continue;
                }
                if (country.equals(areaName)) {
                    amountFieldRank[0] = collectFieldName;
                    continue;
                }
                int rank = row.getInteger(RANK);
                amountFieldRank[rank - 1] = collectFieldName;
            }
            this.getQueryParam().getCustomParam().put("areaMap", fieldMap);
            this.amountFields = new ArrayList<String>(areaGroupSet.length + 1);
            amountFieldRank[amountFieldRank.length - 1] = TOTAL_COLLECT_AMOUNT;
            this.collectableAmountFields.add(TOTAL_COLLECTABLE_AMOUNT);
            this.amountFields.addAll(Arrays.asList(amountFieldRank));
            this.amountFields.removeIf(Objects::isNull);
        } else {
            for (DataSet areaSet : areaGroupSet) {
                if (areaSet.isEmpty()) continue;
                Row row = areaSet.copy().next();
                String areaName = row.getString(AREA);
                Map areaMap = (Map)this.getQueryParam().getCustomParam().get("areaMap");
                int hashCode = this.getHashCode(hashCodes, areaName);
                if (!areaMap.isEmpty()) {
                    for (Map.Entry stringEntry : areaMap.entrySet()) {
                        if (!areaName.equals(stringEntry.getValue())) continue;
                        hashCode = Integer.parseInt((String)stringEntry.getKey());
                        break;
                    }
                }
                String collectFieldName = AREA_PREFIX + hashCode + "_" + COLLECT_AMOUNT;
                String collectableFieldName = AREA_PREFIX + hashCode + "_" + COLLECTABLE_AMOUNT;
                areaSet = areaSet.groupBy(new String[]{"orgid"}).sum(COLLECT_AMOUNT, collectFieldName).sum(COLLECTABLE_AMOUNT, collectableFieldName).finish();
                baseSet = baseSet.leftJoin(areaSet).on("orgid", "orgid").select(baseSet.getRowMeta().getFieldNames(), new String[]{collectFieldName, collectableFieldName}).finish();
            }
        }
        return baseSet;
    }

    private DataSet getOffsetRow(Map<String, Object> paramMap, DataSet dataSet, List<String> fieldNames) {
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List allOrgIds = (List)paramMap.get("allorgids");
        ArrayList subOrgIds = new ArrayList(allOrgIds);
        subOrgIds.remove(orgId);
        if (EmptyUtil.isNoEmpty(subOrgIds)) {
            dataSet = dataSet.where("orgid in (" + TmcBusinessBaseHelper.idListToString(subOrgIds) + ")");
        }
        DataSet offsetRow = dataSet.groupBy(new String[]{AREA}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish();
        offsetRow = offsetRow.updateFields(new String[]{COLLECT_AMOUNT, COLLECTABLE_AMOUNT}, new String[]{"0.0", "-collableamt"});
        offsetRow = offsetRow.addFields(new String[]{"0L", "0"}, new String[]{"orgid", "sumlevel"});
        offsetRow = this.areaConvert(offsetRow, true);
        String mergeName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"FinDebtDistListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]);
        offsetRow = offsetRow.addFields(new String[]{"0L", "0L", "'0'", "'0'", "0", "0", "'" + mergeName + "'"}, new String[]{"rowid", "pid", "isgroupnode", "sortcode", "level", "sumlevel", "mixorgname"});
        Set offsetRowFields = Arrays.stream(offsetRow.getRowMeta().getFieldNames()).collect(Collectors.toSet());
        ArrayList<String> absentField = new ArrayList<String>(fieldNames.size());
        ArrayList<String> absentValue = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            if (offsetRowFields.contains(fieldName)) continue;
            absentField.add(fieldName);
            absentValue.add("0.0");
        }
        offsetRow = offsetRow.addFields(absentValue.toArray(new String[0]), absentField.toArray(new String[0]));
        return offsetRow;
    }

    private List<String> getSumField(DataSet ds) {
        if (this.sumFields != null && !this.sumFields.isEmpty()) {
            return this.sumFields;
        }
        this.sumFields = new ArrayList<String>(64);
        for (String fieldName : ds.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(COLLECT_AMOUNT) && !fieldName.endsWith(COLLECTABLE_AMOUNT)) continue;
            this.sumFields.add(fieldName);
        }
        return this.sumFields;
    }

    public static void addChildren(ReportColumnGroup group, String fieldKeyPrefix) {
        FundDistByAreaDataListPlugin.buildReportColumn(group, AREA_PREFIX + fieldKeyPrefix + "_" + COLLECT_AMOUNT, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1", (String)"FundDistByAreaDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
        FundDistByAreaDataListPlugin.buildReportColumn(group, AREA_PREFIX + fieldKeyPrefix + "_" + FUND_RATIO, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u5360\u6bd4", (String)"FundDistByAreaDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text");
        FundDistByAreaDataListPlugin.buildReportColumn(group, AREA_PREFIX + fieldKeyPrefix + "_" + FUND_CON_RATIO, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundDistByAreaQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text");
    }

    public static void addTotalChildren(ReportColumnGroup group) {
        FundDistByAreaDataListPlugin.buildReportColumn(group, TOTAL_COLLECT_AMOUNT, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1", (String)"FundDistByAreaDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
        FundDistByAreaDataListPlugin.buildReportColumn(group, "totalcolfundconratio", ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundDistByAreaQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text");
    }

    private static void buildReportColumn(ReportColumnGroup group, String fieldKey, String caption, String fieldType) {
        ReportColumn newCol = new ReportColumn();
        newCol.setHideSingleColumnRow(false);
        newCol.setFieldKey(fieldKey);
        newCol.setFieldType(fieldType);
        newCol.setScale(2);
        newCol.setZeroShow(true);
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("right");
        newCol.setStyle(style);
        newCol.setCaption(new LocaleString(caption));
        group.getChildren().add(newCol);
    }

    /*
     * Exception decompiling
     */
    private DataSet createRankRow(String areaField, DataSet dataSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

