/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.DataSetCacheManagerHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.InvestCommonHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.enums.CashFinOrgTypeEnum;
import kd.tmc.tda.common.enums.FundFocusRateEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.ccr.helper.DepositRelease;
import kd.tmc.tda.report.ccr.helper.FinsubscribeRedeem;
import kd.tmc.tda.report.ccr.helper.FundConcentrateActHelper;
import org.apache.commons.lang.StringUtils;

public class CashConcentrationDataHelper {
    private static final String FUND_TYPE_NAME = "fundtypename";
    private static final String FUND_TYPE = "fundtype";
    private static final String CURRENCY = "currency";
    private static final String STRING_FORMAT = "'%s'";
    private static final List<String> INVEST_TYPE_LIST = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());
    private static final String[] FUND_TYPE_ARRAY = new String[]{"fundtypename", "fundtype"};
    private static final String[] FIELD_NAMES = new String[]{"company", "companyname", "currency", "currencyname", "accountbank", "bankaccountnumber", "finorgtype", "bank", "bankname", "bankcatename", "bankcateid", "country", "countryname", "cityname", "isdomestic", "isoffset", "businessunit", "datetype", "fundtype", "fundtypevalue"};
    private static final String[] FOCUS_AMOUNT_FIELD_NAMES = new String[]{"financeamount", "companyamount", "collectamount", "collectableamount", "nocollectamount", "uncollectamount"};
    private static final String[] EXTRA_FIELD_NAMES = new String[]{"datetype"};
    private static final DataType[] EXTRA_DATA_TYPES = new DataType[]{DataType.IntegerType};

    public static DataSet getFundDataSet(String algoKey, List<Long> orgIds, Date queryDate, Map<String, Object> paramMap, boolean includeLastYear) {
        List allIds;
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String cacheKey = CashConcentrationDataHelper.getCacheKey(orgViewId, queryDate, includeLastYear);
        boolean isNoCache = DataSetCacheManagerHelper.isNoCache((String)cacheKey);
        if (isQueryCache && !isNoCache) {
            String orgRootId = TmcOrgDataHelper.getOrgRootId((Long)orgViewId);
            Long rootId = orgRootId == null ? 0L : Long.parseLong(orgRootId);
            allIds = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgViewId, Collections.singletonList(rootId), (boolean)true, (boolean)true);
        } else {
            allIds = orgIds;
        }
        DataSet allDs = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)CashConcentrationDataHelper.class.getName(), (String)cacheKey, () -> CashConcentrationDataHelper.getFundDatas(algoKey, allIds, queryDate, paramMap, includeLastYear));
        if (isQueryCache && !isNoCache) {
            allDs = allDs.filter("company in ids", Collections.singletonMap("ids", orgIds));
        }
        allDs = BasicParamHelper.excludePositionFilter((DataSet)allDs, (List)orgIds);
        boolean isSettlementCenter = BasicParamHelper.getAppBooleamParameter((String)"tda_acct_queryparamset", (String)"issettlementcenter");
        if (!isSettlementCenter) {
            allDs = allDs.filter("finorgtype != '1'");
        }
        Map<String, Set<Long>> accountConfig = FundConcentrateActHelper.cashConcentrationAccountConfig(orgViewId, orgIds);
        allDs = CashConcentrationDataHelper.excludeAccount(allDs, accountConfig);
        allDs = CashConcentrationDataHelper.addFocusType(allDs, accountConfig);
        allDs = CashConcentrationDataHelper.addFocusAmountFieldNames(allDs);
        if (CollectionUtils.isNotEmpty((Collection)orgIds)) {
            StringBuilder offSetSb = isSettlementCenter ? new StringBuilder("case when (finorgtype = '3' or finorgtype = '1')  and businessunit in (") : new StringBuilder("case when finorgtype = '3' and businessunit in (");
            offSetSb.append(StringUtils.join((Collection)orgIds, (String)",")).append(") then '1' else '0' end");
            allDs = allDs.updateField("isoffset", offSetSb.toString());
        }
        return allDs;
    }

    private static DataSet excludeAccount(DataSet ds, Map<String, Set<Long>> accountConfig) {
        Set<Long> excludeAccounts = accountConfig.get(FundFocusRateEnum.FUND_CASH.getNumber());
        if (EmptyUtil.isEmpty(excludeAccounts)) {
            return ds;
        }
        return ds.filter("accountbank not in excludeAccounts", Collections.singletonMap("excludeAccounts", excludeAccounts));
    }

    private static DataSet addFocusType(DataSet ds, Map<String, Set<Long>> accountConfig) {
        final Set<Long> excludeFinAccounts = accountConfig.get(FundFocusRateEnum.FINANCE_COLLECTION.getNumber());
        final boolean isExcludeFinAccounts = EmptyUtil.isNoEmpty(excludeFinAccounts);
        final Set<Long> includeCompanyAccounts = accountConfig.get(FundFocusRateEnum.GROUP_COLLECTION.getNumber());
        final boolean isIncludeCompanyAccounts = EmptyUtil.isNoEmpty(includeCompanyAccounts);
        final Set<Long> excludeCollectAccounts = accountConfig.get(FundFocusRateEnum.COLLECTION.getNumber());
        final boolean isExcludeCollectAccounts = EmptyUtil.isNoEmpty(excludeCollectAccounts);
        ds = ds.addField("''", "focustype");
        final RowMeta rowMetas = ds.getRowMeta();
        return ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("focustype".equals(fieldName)) {
                        String finorgType;
                        Long accountId = row.getLong("accountbank");
                        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{accountId, finorgType = row.getString("finorgtype")})) {
                            rowInfo.add("uncollect");
                            continue;
                        }
                        if (isExcludeCollectAccounts && excludeCollectAccounts.contains(accountId)) {
                            rowInfo.add("uncollect");
                            continue;
                        }
                        String focusType = CashFinOrgTypeEnum.FIN_COMP.getValue().equals(finorgType) ? (isExcludeFinAccounts && excludeFinAccounts.contains(accountId) ? "nocollect" : "finance") : (EmptyUtil.isNoEmpty((Long)accountId) && isIncludeCompanyAccounts && includeCompanyAccounts.contains(accountId) ? "company" : "nocollect");
                        rowInfo.add(focusType);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
    }

    private static DataSet addFocusAmountFieldNames(DataSet ds) {
        ds = ds.addFields(new String[]{"case when focustype='finance' then realvalibalance else 0.0 end as financeamount", "case when focustype='company' then realvalibalance else 0.0 end as companyamount", "case when focustype='finance' or focustype='company' then realvalibalance else 0.0 end as collectamount", "0.0 as collectableamount", "case when focustype='nocollect' then realvalibalance else 0.0 end as nocollectamount", "case when focustype='uncollect' then realvalibalance+realrestrictedamt else realrestrictedamt end as uncollectamount"}, FOCUS_AMOUNT_FIELD_NAMES);
        return ds.updateField("collectableamount", "collectamount+nocollectamount");
    }

    private static DataSet getFundDatas(String algoKey, List<Long> orgIds, Date queryDate, Map<String, Object> paramMap, boolean includeLastYear) {
        DataSet accountDs = CashConcentrationDataHelper.getAvailableFunds(algoKey, orgIds, queryDate, includeLastYear);
        accountDs = accountDs.addFields(new String[]{String.format(STRING_FORMAT, CashTypeEnum.ACCOUNT.getText()), "" + CashTypeEnum.ACCOUNT.getNumber()}, FUND_TYPE_ARRAY);
        DataSet depositDs = CashConcentrationDataHelper.getDeposit(algoKey + "deposit", orgIds, queryDate, includeLastYear);
        String fundTypeName = String.format("case when fundtypevalue='notice' then '%1$s' when fundtypevalue='fixed' then '%2$s' when fundtypevalue='structure' then '%3$s' when fundtypevalue='huge' then '%4$s' else '' end", CashTypeEnum.NOTICE.getText(), CashTypeEnum.FIX.getText(), CashTypeEnum.STRUCT.getText(), CashTypeEnum.HUGE.getText());
        String fundType = String.format("case when fundtypevalue='notice' then %1$s when fundtypevalue='fixed' then %2$s when fundtypevalue='structure' then %3$s when fundtypevalue='huge' then %4$s else 99 end", CashTypeEnum.NOTICE.getNumber(), CashTypeEnum.FIX.getNumber(), CashTypeEnum.STRUCT.getNumber(), CashTypeEnum.HUGE.getNumber());
        depositDs = depositDs.addFields(new String[]{fundTypeName, fundType}, FUND_TYPE_ARRAY).removeFields(new String[]{"intdate", "cleardate"});
        DataSet financeDs = CashConcentrationDataHelper.getFinsubScribe(algoKey, orgIds, queryDate, includeLastYear);
        if (financeDs != null) {
            financeDs = financeDs.addFields(new String[]{String.format(STRING_FORMAT, CashTypeEnum.FINANCE.getText()), "" + CashTypeEnum.FINANCE.getNumber()}, FUND_TYPE_ARRAY);
        }
        String[] fieldNames = depositDs.getRowMeta().getFieldNames();
        DataSet allDs = financeDs != null ? depositDs.union(new DataSet[]{financeDs.select(fieldNames), accountDs.select(fieldNames)}) : depositDs.union(accountDs.select(fieldNames));
        allDs = allDs.updateFields(new String[]{"realrestrictedamt", "realvalibalance"}, new String[]{"case when realrestrictedamt is null or realrestrictedamt < 0 then 0.0 else realrestrictedamt end", "case when realvalibalance is null or realvalibalance < 0 then 0.0 else realvalibalance end"});
        if (includeLastYear) {
            List dateList = FinanceCostDateHelper.getAllConcentrationQueryDateList((Date)queryDate);
            allDs = CashConcentrationDataHelper.calculateProfit(allDs, dateList);
            allDs = allDs.groupBy(FIELD_NAMES).sum("realvalibalance").sum("realrestrictedamt").sum("amount").finish();
            allDs = CashConcentrationDataHelper.parseDateType(allDs, queryDate);
            allDs = allDs.updateFields(new String[]{"realvalibalance", "realrestrictedamt", "amount"}, new String[]{"realvalibalance/days", "realrestrictedamt/days", "amount/days"});
        }
        allDs = allDs.addFields(new String[]{"amount", "realvalibalance", "realrestrictedamt"}, new String[]{"amountoriginal", "realvalibalanceoriginal", "realrestrictedamtoriginal"});
        return CashConcentrationDataHelper.tranDataSetRate(allDs, CashConcentrationDataHelper.getTransFields(), queryDate, ((DynamicObject)paramMap.get("orgview")).getLong("id"), (Long)paramMap.get("basecurrency"));
    }

    private static DataSet tranDataSetRate(DataSet ds, Set<String> transFields, Date queryDate, Long orgViewId, Long baseCurrency) {
        return AmountTransHelper.tranDataSetRate((DataSet)ds, (Long)orgViewId, (Long)baseCurrency, (String)CURRENCY, transFields, (Date)queryDate);
    }

    private static Set<String> getTransFields() {
        HashSet<String> transFields = new HashSet<String>(8);
        transFields.add("amount");
        transFields.add("realvalibalance");
        transFields.add("realrestrictedamt");
        return transFields;
    }

    private static DataSet getAvailableFunds(String algoKey, List<Long> orgIds, Date queryDate, boolean includeLastYear) {
        DataSet orinalDs = CashConcentrationDataHelper.getOrinalBalance(algoKey, queryDate, orgIds, includeLastYear);
        return CashConcentrationDataHelper.getLimitedFunds(orinalDs, algoKey, queryDate, orgIds);
    }

    private static DataSet calculateProfit(DataSet ds, List<Object[]> dateList) {
        DataType[] dataTypes = ds.getRowMeta().getDataTypes();
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length + EXTRA_FIELD_NAMES.length];
        DataType[] newDataTypes = new DataType[dataTypes.length + EXTRA_DATA_TYPES.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(EXTRA_FIELD_NAMES, 0, newFieldNames, fieldNames.length, EXTRA_FIELD_NAMES.length);
        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
        System.arraycopy(EXTRA_DATA_TYPES, 0, newDataTypes, dataTypes.length, EXTRA_DATA_TYPES.length);
        RowMeta builderMeta = RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
        DataSetBuilder builder = Algo.create((String)"CashConcentrationDataHelper.calculateProfit").createDataSetBuilder(builderMeta);
        for (Row row : ds) {
            CashConcentrationDataHelper.dealQueryDate(dateList, fieldNames, builder, row);
        }
        return builder.build();
    }

    private static void dealQueryDate(List<Object[]> dateList, String[] fieldNames, DataSetBuilder builder, Row row) {
        for (int i = 0; i < dateList.size(); ++i) {
            boolean isContain;
            if (dateList.get(i).length < 3) {
                return;
            }
            Date queryBeginDate = (Date)dateList.get(i)[0];
            Date queryEndDate = DateUtils.getNextDay((Date)((Date)dateList.get(i)[1]), (int)1);
            Date bizDate = (Date)row.get("bizdate");
            boolean bl = isContain = bizDate.compareTo(queryBeginDate) >= 0 && bizDate.compareTo(queryEndDate) < 0;
            if (!isContain) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + EXTRA_FIELD_NAMES.length);
            for (int j = 0; j < fieldNames.length; ++j) {
                String fieldName = fieldNames[j];
                appendRow.add(row.get(fieldName));
            }
            appendRow.add(i);
            builder.append(appendRow.toArray());
        }
    }

    private static DataSet getOrinalBalance(String algoKey, Date queryDate, List<Long> orgIds, boolean includeLastYear) {
        String sic = "id,'' billno,bizdate,company,company.name companyname,currency,currency.name currencyname,case when amount is null OR amount < 0 then 0.0 else amount end amount,case when valibalance is null OR valibalance < 0 then 0.0 else valibalance end valibalance,accountbank.id accountbank, accountbank.acctproperty.id acctproperty,accountbank.bankaccountnumber bankaccountnumber,accountbank.bank.finorgtype.type finorgtype,accountbank.bank.id bank, accountbank.bank.name bankname, accountbank.bank.bank_cate.id bankcateid, accountbank.bank.bank_cate.name bankcatename,accountbank.bank.country.id country, accountbank.bank.country.name countryname, accountbank.bank.city.name cityname,case when accountbank.bank.country.twocountrycode = 'CN' then '1' else case when accountbank.bank.country.threecountrycode = 'CHN' then '1' else case when accountbank.bank.country = 0 or (TRIM(accountbank.bank.country.twocountrycode) = '' and TRIM(accountbank.bank.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, accountbank.bank.org businessunit,'account' fundtypevalue";
        QFilter filter = new QFilter("company", "in", orgIds);
        QFilter dateFilter = CashConcentrationDataHelper.getDateFilter(queryDate, includeLastYear);
        filter.and(dateFilter).and("amount", ">", (Object)0);
        DataSet ds = QueryServiceHelper.queryDataSet((String)(algoKey + "orinalBalance"), (String)"bei_bankbalance", (String)sic, (QFilter[])filter.toArray(), null);
        return ds.updateField("valibalance", "case when amount < valibalance then amount else valibalance end");
    }

    private static QFilter getDateFilter(Date queryDate, boolean includeLastYear) {
        List dateList = FinanceCostDateHelper.getAllConcentrationQueryDateList((Date)queryDate);
        Date queryStartDate = includeLastYear ? (Date)((Object[])dateList.get(0))[0] : queryDate;
        Date queryEndDate = includeLastYear ? (Date)((Object[])dateList.get(dateList.size() - 1))[1] : queryDate;
        return new QFilter("bizdate", ">=", (Object)queryStartDate).and("bizdate", "<", (Object)DateUtils.getNextDay((Date)queryEndDate, (int)1));
    }

    private static DataSet getLimitedFunds(DataSet orinalDs, String algoKey, Date queryDate, List<Long> orgIds) {
        Pair<DataSet, DataSet> pair = CashConcentrationDataHelper.getLimitUsageAmount(orinalDs);
        DataSet usageLimitDs = ((DataSet)pair.getValue0()).addField("amount", "realrestrictedamt");
        DataSet notusageLimitDs = (DataSet)pair.getValue1();
        DataSet fundsLimitDs = CashConcentrationDataHelper.getLimitFundsAmount(algoKey, notusageLimitDs, queryDate, orgIds);
        List fieldNames = Arrays.stream(fundsLimitDs.getRowMeta().getFieldNames()).collect(Collectors.toList());
        fieldNames.remove("realrestrictedamt");
        fundsLimitDs = fundsLimitDs.select(String.join((CharSequence)",", fieldNames) + ", case when realrestrictedamt < 0 then 0.0 else realrestrictedamt end realrestrictedamt");
        fundsLimitDs = fundsLimitDs.updateField("realrestrictedamt", "case when amount < realrestrictedamt then amount else realrestrictedamt end");
        return usageLimitDs.union(fundsLimitDs).select(String.join((CharSequence)",", fundsLimitDs.getRowMeta().getFieldNames()) + ",case when amount-realrestrictedamt<0 then 0.0 else amount-realrestrictedamt end realvalibalance");
    }

    protected static Pair<DataSet, DataSet> getLimitUsageAmount(DataSet orinalBalance) {
        Pair pair;
        String sic = "usage,bizdate";
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"am_restrictedfundusage", (String)sic, (QFilter[])filter.toArray());
        List usageId = colls.stream().map(v -> v.getLong("usage")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(usageId)) {
            String filterString = "acctproperty in (" + TmcBusinessBaseHelper.idListToString(usageId) + ")";
            DataSet[] splitResult = orinalBalance.splitByFilter(new String[]{filterString}, true);
            pair = new Pair((Object)splitResult[0], (Object)splitResult[1]);
        } else {
            pair = new Pair((Object)DataSetHelper.createEmptyDataSet((RowMeta)orinalBalance.getRowMeta()), (Object)orinalBalance);
        }
        return pair;
    }

    private static DataSet getLimitFundsAmount(String algoKey, DataSet notusageLimitDs, Date queryDate, List<Long> orgIds) {
        CharSequence[] filedNames = notusageLimitDs.getRowMeta().getFieldNames();
        QFilter filter = new QFilter("org", "in", orgIds);
        Date endData = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        filter.and("restricteddate", "<=", (Object)endData);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("businesstype", "=", (Object)"1");
        DataSet manager = QueryServiceHelper.queryDataSet((String)(algoKey + "getLimitFundsAmount"), (String)"am_restrictedfundsmanager", (String)"bankacct,currency,billno,restrictedamt", (QFilter[])new QFilter[]{filter}, null);
        QFilter liftFilter = new QFilter("org", "in", orgIds);
        liftFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        liftFilter.and("businesstype", "=", (Object)"2");
        liftFilter.and("liftdate", "<=", (Object)endData);
        DataSet managerEntry = QueryServiceHelper.queryDataSet((String)(algoKey + "getLimitFundsAmount"), (String)"am_restrictedfundsmanager", (String)"srcbillno,thistimeunblockamt", (QFilter[])new QFilter[]{liftFilter}, null).groupBy(new String[]{"srcbillno"}).sum("thistimeunblockamt").finish();
        manager = manager.leftJoin(managerEntry).on("billno", "srcbillno").select(new String[]{"bankacct", CURRENCY, "restrictedamt"}, new String[]{"thistimeunblockamt"}).finish().select("bankacct,currency,restrictedamt,case when thistimeunblockamt is null then 0 else thistimeunblockamt end thistimeunblockamt").groupBy(new String[]{"bankacct", CURRENCY}).sum("restrictedamt").sum("thistimeunblockamt").finish();
        notusageLimitDs = notusageLimitDs.leftJoin(manager).on("accountbank", "bankacct").on(CURRENCY, CURRENCY).select((String[])filedNames, new String[]{"restrictedamt", "thistimeunblockamt"}).finish();
        notusageLimitDs = notusageLimitDs.select(String.join((CharSequence)",", filedNames) + ", case when restrictedamt is null then amount - valibalance else restrictedamt - thistimeunblockamt end realrestrictedamt");
        return notusageLimitDs;
    }

    private static DataSet getDeposit(String algoKey, List<Long> orgIds, Date queryDate, boolean includeLastYear) {
        QFilter filter = new QFilter("investvarieties.investtype", "in", INVEST_TYPE_LIST).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("bizstatus", "!=", (Object)"subscribe_ing");
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isredepositgenerate='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("org", "in", orgIds);
        queryDate = DateUtils.getDataFormat((Date)queryDate, (boolean)true);
        Date[] rangeDates = includeLastYear ? CashConcentrationDataHelper.rangeDate(queryDate) : null;
        filter.and(CashConcentrationDataHelper.getDepositDateFilter(queryDate, rangeDates));
        String sic = "id,billno,org company,org.name companyname,currency,currency.name currencyname,amount,intdate,cleardate,finaccountf7.id accountbank, 0L acctproperty,finaccount bankaccountnumber,finorginfo.finorgtype.type finorgtype,finorginfo bank, finorginfo.name bankname, finorginfo.bank_cate.id bankcateid, finorginfo.bank_cate.name bankcatename,finorginfo.country.id country, finorginfo.country.name countryname, finorginfo.city.name cityname,case when finorginfo.country.twocountrycode = 'CN' then '1' else case when finorginfo.country.threecountrycode = 'CHN' then '1' else case when finorginfo.country = 0 or (TRIM(finorginfo.country.twocountrycode) = '' and TRIM(finorginfo.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, finorginfo.org businessunit,investvarieties.investtype fundtypevalue";
        DataSet depositDs = QueryServiceHelper.queryDataSet((String)(algoKey + "Deposit"), (String)"cim_deposit", (String)sic, (QFilter[])filter.toArray(), null);
        DataSet releaseDs = CashConcentrationDataHelper.queryDepositRelease(algoKey, queryDate, orgIds);
        DataSet allDs = CashConcentrationDataHelper.handleDepositDateSet(algoKey, depositDs, releaseDs, queryDate, rangeDates);
        return allDs.addFields(new String[]{"amount-ramount", "0.0"}, new String[]{"realvalibalance", "realrestrictedamt"}).updateField("amount", "realvalibalance+realrestrictedamt").removeFields(new String[]{"ramount"});
    }

    private static DataSet handleDepositDateSet(String algoKey, DataSet depositDs, DataSet releaseDs, Date queryDate, Date[] rangeDates) {
        if (rangeDates == null) {
            rangeDates = new Date[]{queryDate};
        }
        return new DepositRelease(algoKey, depositDs, releaseDs, rangeDates).join();
    }

    private static Date[] rangeDate(Date queryDate) {
        List dateList = FinanceCostDateHelper.getAllConcentrationQueryDateList((Date)queryDate);
        Date queryStartDate = (Date)((Object[])dateList.get(0))[0];
        Date queryEndDate = (Date)((Object[])dateList.get(dateList.size() - 1))[1];
        int days = DateUtils.getDiffDays((Date)queryStartDate, (Date)queryEndDate);
        Date[] array = new Date[days];
        array[0] = queryEndDate;
        for (int i = 1; i < days; ++i) {
            array[i] = DateUtils.getNextDay((Date)queryEndDate, (int)(-i));
        }
        return array;
    }

    private static QFilter getDepositDateFilter(Date queryDate, Date[] rangeDates) {
        if (rangeDates == null) {
            QFilter dateFilter = new QFilter("intdate", "<=", (Object)queryDate);
            dateFilter.and(QFilter.of((String)"(cleardate IS NULL OR cleardate > ?)", (Object[])new Object[]{queryDate}));
            return dateFilter;
        }
        QFilter dateFilter = new QFilter("intdate", "<=", (Object)queryDate);
        dateFilter.and(QFilter.of((String)"(cleardate IS NULL OR cleardate > ?)", (Object[])new Object[]{rangeDates[rangeDates.length - 1]}));
        return dateFilter;
    }

    private static DataSet queryDepositRelease(String algoKey, Date queryDate, List<Long> orgIds) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR expireredeposit in('principalredeposit','principalintredeposit'))", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("org", "in", orgIds);
        filter.and("redeemdate", "<=", (Object)queryDate);
        DataSet releaseDs = QueryServiceHelper.queryDataSet((String)(algoKey + "NoticeDepositRelease"), (String)"cim_release", (String)"finbillno,amount,redeemdate", (QFilter[])filter.toArray(), null);
        return releaseDs;
    }

    private static DataSet getFinsubScribe(String algoKey, List<Long> orgIds, Date queryDate, boolean includeLastYear) {
        Date[] dateArray;
        String sic = "id,billno,redeemway,iopv,buycopies,org company,org.name companyname,currency,currency.name currencyname,amount,cleardate,valuedate,finaccountf7.id accountbank, 0L acctproperty, finaccount bankaccountnumber,finorginfo.finorgtype.type finorgtype,finorginfo bank, finorginfo.name bankname, finorginfo.bank_cate.id bankcateid, finorginfo.bank_cate.name bankcatename,finorginfo.country.id country, finorginfo.country.name countryname, finorginfo.city.name cityname,case when finorginfo.country.twocountrycode = 'CN' then '1' else case when finorginfo.country.threecountrycode = 'CHN' then '1' else case when finorginfo.country = 0 or (TRIM(finorginfo.country.twocountrycode) = '' and TRIM(finorginfo.country.threecountrycode) = '') then '1' else '0' end end end isdomestic,'0' as isoffset, finorginfo.org businessunit,'finance' fundtypevalue";
        QFilter filter = new QFilter("org.id", "in", orgIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("finservicestatus", "!=", (Object)"subscribe_ing");
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isrenewal='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        if (includeLastYear) {
            dateArray = CashConcentrationDataHelper.rangeDate(queryDate);
        } else {
            Date[] dateArray2 = new Date[1];
            dateArray = dateArray2;
            dateArray2[0] = queryDate;
        }
        Date[] dateList = dateArray;
        QFilter dateFilter = new QFilter("valuedate", "<=", (Object)dateList[0]);
        QFilter clearDateFilter = QFilter.isNull((String)"cleardate").or(new QFilter("cleardate", ">", (Object)dateList[dateList.length - 1]));
        filter.and(dateFilter).and(clearDateFilter);
        DataSet finsubscribeDs = QueryServiceHelper.queryDataSet((String)(algoKey + "FinsubScribe"), (String)"cim_finsubscribe", (String)sic, (QFilter[])filter.toArray(), null);
        DataSet[] copyDs = DataSetHelper.copy((DataSet)finsubscribeDs);
        finsubscribeDs = copyDs[0];
        Set finsubscribeIds = InvestCommonHelper.getFieldValues((DataSet)copyDs[1], (String)"id", Long.class);
        DataSet redeemDs = CashConcentrationDataHelper.queryRedeem(algoKey, finsubscribeIds, queryDate);
        DataSet resultDs = new FinsubscribeRedeem(algoKey, finsubscribeDs, redeemDs, dateList).join();
        return resultDs.addFields(new String[]{"0", "amount"}, new String[]{"realrestrictedamt", "realvalibalance"});
    }

    private static DataSet queryRedeem(String algoKey, Set<Long> finsubscribeIds, Date queryDate) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter channelFilter = QFilter.of((String)"((tradechannel = ? AND bebankstatus = ?) OR tradechannel = ? OR isrenewal='1' OR isrollcapital='1')", (Object[])new Object[]{"online", BeBillStatusEnum.TS.getValue(), "offline"});
        filter.and(channelFilter);
        filter.and("finbillno", "in", finsubscribeIds);
        if (queryDate != null) {
            filter.and("redeemdate", "<=", (Object)queryDate);
        }
        String sic = "finbillno,redeemdate,redeemway,copies,amount,realrevenue,case when redeemway='amount_redeem' then amount when redeemway='copies_redeem' then 0.0 else 0.0 end redeemamount";
        return QueryServiceHelper.queryDataSet((String)(algoKey + "redeem"), (String)"cim_redeem", (String)sic, (QFilter[])filter.toArray(), null);
    }

    private static DataSet parseDateType(DataSet ds, Date queryDate) {
        ds = ds.addFields(new String[]{"''", "1", "''"}, new String[]{"customtype", "days", "term"});
        final List dateList = FinanceCostDateHelper.getAllConcentrationQueryDateList((Date)queryDate);
        final RowMeta rowMetas = ds.getRowMeta();
        return ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                Integer dateType = row.getInteger("datetype");
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("customtype".equals(fieldName) && dateType != null) {
                        rowInfo.add(((Object[])dateList.get(dateType))[2]);
                        continue;
                    }
                    if ("days".equals(fieldName) && dateType != null) {
                        rowInfo.add(((Object[])dateList.get(dateType))[3]);
                        continue;
                    }
                    if ("term".equals(fieldName) && dateType != null) {
                        rowInfo.add(((Object[])dateList.get(dateType))[4]);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
    }

    private static String getCacheKey(Long orgViewId, Date queryDate, boolean includeLastYear) {
        return CashConcentrationDataHelper.class.getName() + "-cachekey-" + orgViewId + "-" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "-" + includeLastYear;
    }

    public static String getFilterStringFromPageCache(IPageCache pageCache) {
        return CashConcentrationDataHelper.getFilterStringFromPageCache(pageCache, null);
    }

    public static String getFilterStringFromPageCache(IPageCache pageCache, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)pageCache, filterParam, (String)"ccrtermtype", (String)"ccrdate");
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isEmpty((String)term)) {
            term = DateUtils.formatString((Date)new Date(), (String)"yyyyMM");
        }
        return "term = '" + term + "'";
    }
}

