/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.helper;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.tmc.fbp.common.util.DateUtils;

public class DepositRelease {
    private String algoKey;
    private DataSet depositDs;
    private DataSet releaseDs;
    private Date[] rangeDates;
    private String[] EXTRA_FIELD_NAMES = new String[]{"bizdate"};
    private DataType[] EXTRA_DATA_TYPES = new DataType[]{DataType.DateType};

    public DepositRelease(String algoKey, DataSet depositDs, DataSet releaseDs, Date[] rangeDates) {
        this.algoKey = algoKey;
        this.depositDs = depositDs;
        this.releaseDs = releaseDs;
        this.rangeDates = rangeDates;
    }

    public DataSet join() {
        if (this.rangeDates == null) {
            return this.depositDs;
        }
        if (this.rangeDates.length == 1) {
            Date queryDate = this.rangeDates[0];
            this.releaseDs = this.releaseDs.groupBy(new String[]{"finbillno"}).sum("amount", "ramount").finish();
            DataSet ds = this.depositDs.leftJoin(this.releaseDs).on("id", "finbillno").select(this.depositDs.getRowMeta().getFieldNames(), new String[]{"ramount"}).finish();
            ds = ds.addField("to_date('" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "', 'yy-MM-dd')", "bizdate");
            return ds.updateField("ramount", "case when ramount is null then 0.0 else ramount end");
        }
        DataSet depositFilterDs = this.handleDeposit(this.depositDs, this.rangeDates);
        DataSet releaseFilterDs = this.handleRelease(this.releaseDs, this.rangeDates);
        releaseFilterDs = releaseFilterDs.groupBy(new String[]{"finbillno", "bizdate"}).sum("amount", "ramount").finish();
        DataSet ds = depositFilterDs.leftJoin(releaseFilterDs).on("id", "finbillno").on("bizdate", "bizdate").select(depositFilterDs.getRowMeta().getFieldNames(), new String[]{"ramount"}).finish();
        return ds.updateField("ramount", "case when ramount is null then 0.0 else ramount end");
    }

    private DataSet handleDeposit(DataSet depositDs, Date[] rangeDates) {
        RowMeta builderMeta = this.builderMeta(depositDs);
        String[] fieldNames = depositDs.getRowMeta().getFieldNames();
        DataSetBuilder builder = Algo.create((String)(this.algoKey + ".handleDepositPeriod")).createDataSetBuilder(builderMeta);
        for (Row row : depositDs) {
            this.handleDeposit(rangeDates, fieldNames, builder, row);
        }
        return builder.build();
    }

    private void handleDeposit(Date[] rangeDates, String[] fieldNames, DataSetBuilder builder, Row row) {
        for (int i = 0; i < rangeDates.length; ++i) {
            boolean isContain;
            Date bizDate = rangeDates[i];
            Date clearDate = (Date)row.get("cleardate");
            Date intDate = (Date)row.get("intdate");
            boolean bl = isContain = (clearDate == null || clearDate.after(bizDate)) && intDate.compareTo(bizDate) <= 0;
            if (!isContain) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + this.EXTRA_FIELD_NAMES.length);
            for (int j = 0; j < fieldNames.length; ++j) {
                String fieldName = fieldNames[j];
                appendRow.add(row.get(fieldName));
            }
            appendRow.add(bizDate);
            builder.append(appendRow.toArray());
        }
    }

    private DataSet handleRelease(DataSet releaseDs, Date[] rangeDates) {
        RowMeta builderMeta = this.builderMeta(releaseDs);
        String[] fieldNames = releaseDs.getRowMeta().getFieldNames();
        DataSetBuilder builder = Algo.create((String)(this.algoKey + ".handleReleasePeriod")).createDataSetBuilder(builderMeta);
        for (Row row : releaseDs) {
            this.handleRelease(rangeDates, fieldNames, builder, row);
        }
        return builder.build();
    }

    private void handleRelease(Date[] rangeDates, String[] fieldNames, DataSetBuilder builder, Row row) {
        for (int i = 0; i < rangeDates.length; ++i) {
            boolean isContain;
            Date bizDate = rangeDates[i];
            Date redeemDate = (Date)row.get("redeemdate");
            boolean bl = isContain = bizDate.compareTo(redeemDate) >= 0;
            if (!isContain) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + this.EXTRA_FIELD_NAMES.length);
            for (int j = 0; j < fieldNames.length; ++j) {
                String fieldName = fieldNames[j];
                appendRow.add(row.get(fieldName));
            }
            appendRow.add(bizDate);
            builder.append(appendRow.toArray());
        }
    }

    private RowMeta builderMeta(DataSet ds) {
        DataType[] dataTypes = ds.getRowMeta().getDataTypes();
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length + this.EXTRA_FIELD_NAMES.length];
        DataType[] newDataTypes = new DataType[dataTypes.length + this.EXTRA_DATA_TYPES.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(this.EXTRA_FIELD_NAMES, 0, newFieldNames, fieldNames.length, this.EXTRA_FIELD_NAMES.length);
        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
        System.arraycopy(this.EXTRA_DATA_TYPES, 0, newDataTypes, dataTypes.length, this.EXTRA_DATA_TYPES.length);
        return RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
    }
}

