/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.FundFocusRateEnum;
import kd.tmc.tda.common.helper.CtrlConditionHelper;

public class FundConcentrateActHelper {
    public static Map<String, Set<Long>> cashConcentrationAccountConfig(Long orgViewId, List<Long> orgIds) {
        Map<String, Set<Long>> accountConfig = FundConcentrateActHelper.accountConfig(orgViewId, orgIds);
        Set<Long> parentAccounts = FundConcentrateActHelper.parentAccounts(orgIds);
        if (EmptyUtil.isEmpty(parentAccounts)) {
            return accountConfig;
        }
        Set<Long> includeCompanyAccounts = accountConfig.get(FundFocusRateEnum.GROUP_COLLECTION.getNumber());
        if (includeCompanyAccounts == null) {
            accountConfig.put(FundFocusRateEnum.GROUP_COLLECTION.getNumber(), parentAccounts);
        } else {
            includeCompanyAccounts.addAll(parentAccounts);
        }
        return accountConfig;
    }

    private static Set<Long> parentAccounts(List<Long> orgIds) {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("company", "in", orgIds);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fca_acctgroup", (String)"accountbank", (QFilter[])filter.toArray());
        return dyns.stream().map(e -> e.getLong("accountbank")).collect(Collectors.toSet());
    }

    public static Map<String, Set<Long>> accountConfig(Long orgViewId, List<Long> orgIds) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(8);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("orgview", "=", (Object)orgViewId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tda_fundconcentrateset", (String)"entry.statisticaltype,entry.applycondition_tag", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return result;
        }
        for (DynamicObject object : dynamicObjects) {
            String sstype = object.getString("entry.statisticaltype");
            String filterTag = object.getString("entry.applycondition_tag");
            QFilter subFilter = CtrlConditionHelper.getFilterFromTag((String)"bd_accountbanks", (String)filterTag);
            if (subFilter == null) continue;
            QFilter filter = new QFilter("company", "in", orgIds).and(subFilter);
            result.put(sstype, CtrlConditionHelper.getBankAcctSet((QFilter)filter));
        }
        return result;
    }
}

