/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundCcrAnlsByPointQingPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AREANUMBER = "areanumber";
    private static final String AREA = "area";
    private static final String COLLECTAMOUNT = "collectamount";
    private static final String FINANCEAMOUNT = "financeamount";
    private static final String COMPANYAMOUNT = "companyamount";
    private static final String AMOUNT = "amount";
    private static final String COLLECTABLEAMOUNT = "collectableamount";
    private static final String ISDOMESTIC = "isdomestic";
    private static final String COLLECTABLERATE = "collectablerate";
    private static final String ALLRATE = "allrate";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{AREANUMBER, ResManager.loadKDString((String)"\u533a\u57df\u7f16\u7801", (String)"FundCcrAnlsByPointQingPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{AREA, ResManager.loadKDString((String)"\u533a\u57df", (String)"FundConcentrationQingPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{COLLECTAMOUNT, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u603b\u989d", (String)"FundCcrAnlsByPointQingPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{FINANCEAMOUNT, ResManager.loadKDString((String)"\u8d22\u53f8\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrAnlsByPointQingPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{COMPANYAMOUNT, ResManager.loadKDString((String)"\u96c6\u56e2\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrAnlsByPointQingPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{COLLECTABLERATE, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundCcrAnlsByPointQingPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{ALLRATE, ResManager.loadKDString((String)"\u5168\u53e3\u5f84\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundCcrAnlsByPointQingPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        DataSet fundCcrAnlsByPointDataSet = CashConcentrationDataHelper.getFundDataSet("FundCcrAnlsByPointQingPlugin", (List)paramMap.get("allorgids"), DecisionAnlsHelper.getQueryDate(paramMap), paramMap, false);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.updateFields(new String[]{ISDOMESTIC, AMOUNT, COLLECTABLEAMOUNT}, new String[]{"case when isdomestic is null then '1' else isdomestic end", "case when isoffset = '1' then 0.0 else amount end", "case when isoffset = '1' then 0.0 else collectableamount end"});
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.select(new String[]{ISDOMESTIC, COLLECTAMOUNT, FINANCEAMOUNT, COMPANYAMOUNT, AMOUNT, COLLECTABLEAMOUNT});
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.groupBy(new String[]{ISDOMESTIC}).sum(COLLECTAMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(AMOUNT).sum(COLLECTABLEAMOUNT).finish();
        DataSet[] fundCcrAnlsByPointDataSets = fundCcrAnlsByPointDataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet allAreaSet = fundCcrAnlsByPointDataSets[0].groupBy().sum(COLLECTAMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(AMOUNT).sum(COLLECTABLEAMOUNT).finish().addField("'2'", AREANUMBER);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSets[1].addField(ISDOMESTIC, AREANUMBER).select(allAreaSet.getRowMeta().getFieldNames()).union(allAreaSet);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.addField("case when collectableamount is null or collectableamount = 0 then 0.0 else (collectamount * 100 / collectableamount) end", COLLECTABLERATE);
        fundCcrAnlsByPointDataSet = fundCcrAnlsByPointDataSet.addField("case when amount is null or amount = 0 then 0.0 else (collectamount * 100 / amount) end", ALLRATE);
        fundCcrAnlsByPointDataSet = DecisionAnlsHelper.creatAbsentRow(fundCcrAnlsByPointDataSet, AREANUMBER, Arrays.asList("0", "1", "2"), 5, () -> new Object[]{"0.0", "0.0", "0.0", "0.0", "0.0", "0", "0.0", "0.0"});
        return this.addPullDownField(fundCcrAnlsByPointDataSet);
    }

    private DataSet addPullDownField(DataSet dataSet) {
        dataSet = dataSet.addField("case when areanumber = '0' then '" + this.getMulText(0) + "' when areanumber = '1' then '" + this.getMulText(1) + "' else '" + this.getMulText(2) + "' end", AREA);
        return dataSet;
    }

    private String getMulText(int areaType) {
        if (0 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        if (1 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"FundConcentrationQingPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_collfunddistbyorgrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return AREANUMBER;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_collfunddistbyorgrpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u603b\u989d\u8868", (String)"FundCcrAnlsByPointQingPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
        showParameter.getCustomParams().put("dateRange", ids.get(0));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(Arrays.asList(COLLECTAMOUNT, FINANCEAMOUNT, COMPANYAMOUNT));
    }
}

