/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundDistByAreaTermQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String COLLECT_AMOUNT = "collectamount";
    private static final String COLLECTABLE_AMOUNT = "collectableamount";
    private static final String TOTAL_COLLECT_AMOUNT = "totalcollamt";
    private static final String AREA = "area";
    private static final String AREA_TYPE_NAME = "areatypename";
    private static final String FUND_RATIO = "colfundratio";
    private static final String FUND_CON_RATIO = "colfundconratio";
    private static final String DATE_TYPE = "term";
    private static final String CLICK = "click";
    private static final String ISOFFSET = "isoffset";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{COLLECT_AMOUNT, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1", (String)"FundDistByAreaQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AREA, ResManager.loadKDString((String)"\u533a\u57df", (String)"FundDistByAreaQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{AREA_TYPE_NAME, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b\u540d\u79f0", (String)"FundDistByAreaQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{FUND_RATIO, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u5360\u6bd4", (String)"FundDistByAreaQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{FUND_CON_RATIO, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u96c6\u4e2d\u5ea6", (String)"FundDistByAreaQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"InvestBankAmtQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{DATE_TYPE, ResManager.loadKDString((String)"\u65e5\u671f\u6392\u5e8f", (String)"InvestAmtSumQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{CLICK, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"InvestAmtSumQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet fundDataSet = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIdSet, queryDate, paramMap, true).select("collectamount, collectableamount, countryname, cityname, isoffset, term");
        fundDataSet = fundDataSet.filter("collectableamount > 0");
        return fundDataSet.groupBy(new String[]{"countryname", "cityname", ISOFFSET, DATE_TYPE}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        String filter = CashConcentrationDataHelper.getFilterStringFromPageCache(this.getPageCache(), filterParam);
        ds = ds.filter(filter);
        return this.handle(ds);
    }

    private DataSet handle(DataSet fundDataSet) {
        fundDataSet = fundDataSet.updateField(COLLECTABLE_AMOUNT, "case when isoffset = '1' then 0.0 else collectableamount end");
        DataSet[] dataSets = DataSetHelper.copy((DataSet)fundDataSet, (int)3);
        DataSet sumSet = dataSets[0].groupBy(new String[]{DATE_TYPE}).sum(COLLECT_AMOUNT, TOTAL_COLLECT_AMOUNT).finish();
        String countryStr = ResManager.loadKDString((String)"\u6309\u56fd\u5bb6", (String)"FundDistByAreaQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        String cityStr = ResManager.loadKDString((String)"\u6309\u57ce\u5e02", (String)"FundDistByAreaQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        String otherCountry = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FundDistByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet countrySet = dataSets[1].select("case when countryname is null then '" + otherCountry + "' else countryname end area, collectamount, term, collectableamount").groupBy(new String[]{AREA, DATE_TYPE}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish().orderBy(new String[]{"collectamount desc"});
        countrySet = countrySet.leftJoin(sumSet.copy()).on(DATE_TYPE, DATE_TYPE).select(new String[]{AREA, DATE_TYPE, COLLECT_AMOUNT, TOTAL_COLLECT_AMOUNT, COLLECTABLE_AMOUNT}).finish();
        countrySet = countrySet.addFields(new String[]{"case when collectamount is null or collectamount = 0 then 0.00 else collectamount / totalcollamt * 100 end", "case when collectamount is null or collectamount = 0 or collectableamount = 0 then 0.00 else collectamount / collectableamount * 100 end", "'" + countryStr + "'", "concat('0_', term)"}, new String[]{FUND_RATIO, FUND_CON_RATIO, AREA_TYPE_NAME, CLICK});
        String otherCity = ResManager.loadKDString((String)"\u5176\u4ed6\u57ce\u5e02", (String)"FundDistByAreaDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet citySet = dataSets[2].select("case when cityname is null then '" + otherCity + "' else cityname end area, collectamount, term, collectableamount").groupBy(new String[]{AREA, DATE_TYPE}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish().orderBy(new String[]{"collectamount desc"});
        citySet = citySet.leftJoin(sumSet).on(DATE_TYPE, DATE_TYPE).select(new String[]{AREA, DATE_TYPE, COLLECT_AMOUNT, TOTAL_COLLECT_AMOUNT, COLLECTABLE_AMOUNT}).finish();
        citySet = citySet.addFields(new String[]{"case when collectamount is null or collectamount = 0 then 0.00 else collectamount / totalcollamt * 100 end", "case when collectamount is null or collectamount = 0 or collectableamount = 0 then 0.00 else collectamount / collectableamount * 100 end", "'" + cityStr + "'", "concat('1_', term)"}, new String[]{FUND_RATIO, FUND_CON_RATIO, AREA_TYPE_NAME, CLICK});
        citySet = citySet.filter("area <> '" + otherCity + "'");
        return countrySet.union(citySet).select(new String[]{AREA, AREA_TYPE_NAME, DATE_TYPE, COLLECT_AMOUNT, FUND_RATIO, FUND_CON_RATIO, CLICK}).filter("collectamount > 0");
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(COLLECT_AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_collfundbyareaprpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(CLICK, ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        String[] value;
        JSONObject selectFilter = (JSONObject)clickArgs.get((Object)"selectFilter");
        param.getCustomParams().put(CLICK, "0_" + paramMap.get("ccrdate"));
        if (selectFilter != null && selectFilter.values().size() > 0 && (value = selectFilter.values().toArray(new String[0])) != null && value.length > 0 && ResManager.loadKDString((String)"\u6309\u57ce\u5e02", (String)"FundDistByAreaQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]).equals(value[0])) {
            param.getCustomParams().put(CLICK, "1_" + paramMap.get("ccrdate"));
        }
    }
}

