/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.data;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingLinkageInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.IQingAnalysis;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.bean.TdaLog;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.qing.data.AbstractQingAnlsDataPlugin;
import kd.tmc.tda.common.enums.SnapDataFromEnum;
import kd.tmc.tda.common.helper.HomeOverviewHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractDecisionAnlsQingDataPlugin
extends AbstractQingAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(AbstractDecisionAnlsQingDataPlugin.class);
    private static final String CONTROL_KEY = "controlKey";
    private TdaLog dtaLog;
    public static final String TMC_TDA_REPORT = "tmc-tda-report";

    public QingData getData(String qingPageId, int start, int limit) {
        long time = System.currentTimeMillis();
        ReportView view = (ReportView)SessionManager.getCurrent().getViewNoPlugin(qingPageId);
        this.dtaLog = SnapDataHelper.createRunLog((String)view.getFormId());
        try {
            QingData data;
            QingData qingData = data = super.getData(qingPageId, start, limit);
            return qingData;
        }
        catch (Exception e) {
            this.dtaLog.setException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
        finally {
            Long costMs = System.currentTimeMillis() - time;
            this.dtaLog.setCosttime(costMs);
            if (ThreadCache.exists((Object)"tdalogdesc")) {
                this.dtaLog.setDesc(this.dtaLog.getDesc() + ":" + ThreadCache.get((Object)"tdalogdesc"));
            }
            SnapDataHelper.saveLog((TdaLog)this.dtaLog);
        }
    }

    protected DataSet getQueryDataSet(String qingPageId, Map<String, Object> filterParam, String snapItem, int start, int limit) {
        DataSet ds = super.getQueryDataSet(qingPageId, filterParam, snapItem, start, limit);
        ds = this.filterResultDataSet(ds, filterParam);
        Set<String> amountFields = this.getAmountFields();
        if (!amountFields.isEmpty()) {
            return AmountTransHelper.dealRowOtherValue((DataSet)ds, filterParam, amountFields);
        }
        ds = this.dealCustomSubTotalDataSet(ds);
        return ds;
    }

    protected void addTdaLogDesc(String desc) {
        SnapDataFromEnum from = SnapDataFromEnum.getEnumByValue((String)desc);
        this.dtaLog.setDesc(EmptyUtil.isEmpty((String)this.dtaLog.getDesc()) ? from.getName() : this.dtaLog.getDesc() + "\uff1a" + from.getName());
    }

    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        return ds;
    }

    protected DataSet dealCustomSubTotalDataSet(DataSet ds) {
        return ds;
    }

    protected DataSet queryDataSet(String qingPageId, Map<String, Object> filterParam, int start, int limit) {
        if (EmptyUtil.isNoEmpty((Object)this.dtaLog)) {
            this.dtaLog.setSnapitem(null);
            this.addTdaLogDesc("realtime");
        }
        try (ThreadReadWriteContext ctx = DB.beginThreadRead((String)"qing");){
            DataSet dataSet = super.queryDataSet(qingPageId, filterParam, start, limit);
            return dataSet;
        }
    }

    protected void dealRowOtherValue(List<Object[]> columns, Row rs) {
    }

    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(2, 4);
        }
        return value;
    }

    protected Set<String> getAmountFields() {
        return new HashSet<String>();
    }

    protected boolean refreshFromHome() {
        return false;
    }

    protected Map initSnapParam(Map paramMap) {
        if (this.refreshFromHome()) {
            HomeOverviewHelper.getParamMap((Map)paramMap);
        } else {
            IFormView parentView = SnapDataHelper.getParantView((IPageCache)this.getPageCache());
            if (!(!EmptyUtil.isNoEmpty((Object)parentView) || this.getPageCache().getAll().containsKey("search") && "hand".equals(this.getPageCache().get("search")))) {
                DynamicObject set;
                DynamicObject org = (DynamicObject)parentView.getModel().getValue("org");
                paramMap.put("org", org);
                DynamicObject currency = (DynamicObject)parentView.getModel().getValue("currency");
                paramMap.put("currency", currency);
                paramMap.put("amountunit", parentView.getModel().getValue("amountunit"));
                if (EmptyUtil.isNotEmpty((CharSequence)parentView.getPageCache().get("basecurrency"))) {
                    paramMap.put("basecurrency", Long.valueOf(parentView.getPageCache().get("basecurrency")));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(set = SnapDataHelper.getSnapVersion((IFormView)parentView, (boolean)true)))) {
                    paramMap.put("orgview", set.getDynamicObject("orgview"));
                    paramMap.put("querydate", set.getDate("querydate"));
                    paramMap.put("snapItem", set.getString("number"));
                } else if (EmptyUtil.isNoEmpty(paramMap.get("snapItem"))) {
                    QFilter filter = new QFilter("number", "=", paramMap.get("snapItem"));
                    if (!TmcDataServiceHelper.exists((String)"tda_decisanlsversion", (QFilter[])filter.toArray())) {
                        paramMap.put("snapItem", null);
                    }
                } else if (EmptyUtil.isNoEmpty((Object)parentView)) {
                    DynamicObject orgView = (DynamicObject)parentView.getModel().getValue("orgview");
                    paramMap.put("orgview", orgView);
                    paramMap.put("currency", currency);
                    paramMap.put("querydate", parentView.getModel().getValue("querydate"));
                }
            } else {
                try {
                    DataEntityPropertyCollection properties = this.getView().getModel().getDataEntityType().getProperties();
                    if (properties.containsKey((Object)"orgview")) {
                        DynamicObject orgView = (DynamicObject)this.getView().getModel().getValue("orgview");
                        paramMap.put("orgview", orgView);
                    }
                    if (properties.containsKey((Object)"org")) {
                        DynamicObject org = (DynamicObject)this.getView().getModel().getValue("org");
                        paramMap.put("org", org);
                    }
                    if (properties.containsKey((Object)"currency")) {
                        DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currency");
                        paramMap.put("currency", currency);
                    }
                }
                catch (Exception e) {
                    logger.info(e.getMessage(), (Object)e);
                }
            }
            if (paramMap.get("orgview") == null || !(paramMap.get("orgview") instanceof DynamicObject)) {
                HomeOverviewHelper.getParamMap((Map)paramMap);
            }
        }
        if (paramMap.containsKey("snapItem")) {
            this.dtaLog.setSnapitem((String)paramMap.get("snapItem"));
        }
        if (paramMap.containsKey("orgview")) {
            this.dtaLog.setOrgView((DynamicObject)paramMap.get("orgview"));
        }
        if (paramMap.containsKey("org")) {
            this.dtaLog.setOrg((DynamicObject)paramMap.get("org"));
        }
        return paramMap;
    }

    protected List<Long> getOrgIds(Map paramMap) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        return TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
    }

    protected ReportQueryParam setFilter(ReportQueryParam param, QFilter[] filters) {
        try {
            param = DecisionAnlsHelper.tranFilterToParam(param, filters);
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return param;
    }

    public List<QingLinkageInfo> getLinkageInfo(String pageId, String ctrKey) {
        ArrayList<QingLinkageInfo> result = new ArrayList<QingLinkageInfo>(10);
        List<String> linkReport = this.getLinkReport();
        for (String reportId : linkReport) {
            QingLinkageInfo info = new QingLinkageInfo();
            LinkedHashMap<String, String> formKey = new LinkedHashMap<String, String>(16);
            formKey.put("AppId", TmcAppEnum.TDA.getValue());
            formKey.put("FormId", reportId);
            formKey.put("System", "IERP");
            formKey.put("CtrKey", ctrKey);
            formKey.put("PageId", pageId);
            info.setFormKey(JSONObject.toJSONString(formKey));
            info.setFormDisplayName(EntityMetadataCache.getDataEntityType((String)reportId).getDisplayName().toString());
            info.setFormPrimaryKey(this.getFormPrimaryKey(reportId));
            result.add(info);
        }
        this.getView().getPageCache().put(CONTROL_KEY, ctrKey);
        return result;
    }

    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView parentView = SnapDataHelper.getParantView((IPageCache)this.getPageCache());
        if (parentView != null) {
            DynamicObject orgView = (DynamicObject)parentView.getModel().getValue("orgview");
            DynamicObject org = (DynamicObject)parentView.getModel().getValue("org");
            DynamicObject currency = (DynamicObject)parentView.getModel().getValue("currency");
            Date queryDate = (Date)parentView.getModel().getValue("querydate");
            String amountUnit = (String)parentView.getModel().getValue("amountunit");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{orgView, org, queryDate, currency, amountUnit})) {
                throw new KDBizException(BosErrorCode.paramError, new Object[]{ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u67e5\u8be2\u4fe1\u606f\u3002", (String)"AbstractDecisionAnlsQingDataPlugin_3", (String)TMC_TDA_REPORT, (Object[])new Object[0])});
            }
        }
    }

    protected void fireLinkageShowForm(IFormView view, ReportShowParameter rsp) {
        if (view == null || rsp == null) {
            return;
        }
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView thisView = this.getView();
        String ctrKey = thisView.getPageCache().get(CONTROL_KEY);
        if (ctrKey != null) {
            Control control = view.getControl(ctrKey);
            if (control instanceof IQingAnalysis) {
                this.showForm(view, rsp);
                return;
            }
            this.setClientReturnData(view, rsp, thisView);
        }
    }

    private void showForm(IFormView view, ReportShowParameter rsp) {
        if (this.isLinkFromHome(view)) {
            rsp.getCustomParams().put("home", Boolean.TRUE);
            if (view instanceof FormView && "bos_card_qing".equals(((FormView)view).getFormId())) {
                rsp.setAppId(TmcAppEnum.TDA.getValue());
            }
        }
        view.showForm((FormShowParameter)rsp);
    }

    private void setClientReturnData(IFormView view, ReportShowParameter rsp, IFormView thisView) {
        if (this.isLinkFromHome(view)) {
            rsp.getCustomParams().put("home", Boolean.TRUE);
            if (view instanceof FormView && "bos_card_qing".equals(((FormView)view).getFormId())) {
                rsp.setAppId(TmcAppEnum.TDA.getValue());
            }
        }
        thisView.setClientReturnData((Object)ReportShowParameter.toJsonString((FormShowParameter)rsp));
    }

    private boolean isLinkFromHome(IFormView view) {
        String formId = ((FormView)view).getFormId();
        if ("tda_decisanlsresvisual".equals(formId) || "tda_decisanlsresvisual_bl".equals(formId) || "tda_configtheme".equals(formId) || "tda_configtheme_bl".equals(formId) || "tda_resvisual_new".equals(formId)) {
            return false;
        }
        IFormView parentView = view.getParentView();
        if (parentView == null || !(parentView instanceof FormView)) {
            return false;
        }
        String parentViewFormId = ((FormView)parentView).getFormId();
        return "pc_main_console".equals(parentViewFormId) || "tda_overview".equals(parentViewFormId) || "tda_apphome".equals(parentViewFormId);
    }

    protected ReportQueryParam getQueryParam(String formid, String schemeid, String batchno) {
        return new ReportQueryParam();
    }

    protected List<String> getLinkReport() {
        return Collections.emptyList();
    }

    public String getShowFormId() {
        return Optional.ofNullable(this.getLinkReport()).filter(EmptyUtil::isNoEmpty).map(r -> (String)r.get(0)).orElse("");
    }

    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
    }

    protected String getFormPrimaryKey(String reportId) {
        return null;
    }

    protected String createAlgoKey(String key) {
        return "tda-decisanls-algo-" + ((Object)((Object)this)).getClass().getName() + key;
    }

    protected JobSession createAlgoxSession(ReportQueryParam queryParam) {
        String pageId = (String)queryParam.getFilter().getFilterItem("pageid").getValue();
        return AlgoX.createSession((String)("tda-decisanls-" + ((Object)((Object)this)).getClass().getName() + pageId));
    }

    protected DataSetX DbInput(JobSession session, String key, String sql, Object[] params, RowMeta rowMeta) {
        DbInput input = new DbInput("tda-decisanls-algox-" + ((Object)((Object)this)).getClass().getName() + key, DBRouteConst.TMC.getRouteKey(), sql, params, rowMeta);
        return session.fromInput((Input)input);
    }

    protected DataSetX OrmInput(JobSession session, String key, String entityName, String selectFields, QFilter[] filters, RowMeta rowMeta) {
        OrmInput input = new OrmInput("tda-decisanls-algox-" + ((Object)((Object)this)).getClass().getName() + key, entityName, selectFields, filters, rowMeta);
        return session.fromInput((Input)input);
    }
}

