/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.olap.util.Pair;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;

public class DetailDataFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(AbstractDetailDataPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlistap = (ReportList)this.getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
        event.setTreeExpandColId("orgname");
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String entity = (String)customParams.get("entity");
        if (entity != null) {
            queryParam.getCustomParam().put("entity", entity);
            if (MetaToDetailPluginMap.ENTITY_SET.contains(entity)) {
                queryParam.getCustomParam().putAll(customParams);
            }
        }
        return super.verifyQuery(queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        ReportQueryParam queryParam = this.getQueryParam();
        String entity = (String)queryParam.getCustomParam().get("entity");
        Map pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity);
        if (pluginInfo != null) {
            Set hyperlinkKeys;
            Map<String, String> hyperlinkMap = (Map<String, String>)pluginInfo.get("hyperlink");
            if (hyperlinkMap == null) {
                hyperlinkMap = this.getHyperlinkMap(pluginInfo);
            }
            if ((hyperlinkKeys = hyperlinkMap.keySet()).contains(fieldName)) {
                String linkName = hyperlinkMap.get(fieldName);
                Function linkFunction = (Function)pluginInfo.get("hyperlinkEntity");
                String linkEntity = (String)linkFunction.apply(hyperLinkClickEvent);
                ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
                DynamicObject rowData = reportlistap.getReportModel().getRowData(hyperLinkClickEvent.getRowIndex());
                Long id = rowData.getLong(linkName);
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId(linkEntity);
                billShowParameter.setPkId((Object)id);
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                billShowParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)billShowParameter);
                if (EmptyUtil.isNoEmpty((String)linkEntity) && linkEntity.startsWith("cdm_")) {
                    this.setVisible(billShowParameter);
                }
            }
        }
    }

    private void setVisible(BillShowParameter billShowParameter) {
        String pageId = billShowParameter.getPageId();
        IFormView view = this.getView().getViewNoPlugin(pageId);
        view.setVisible(Boolean.valueOf(false), new String[]{"generatevoucher", "bar_print", "relatedprebill"});
        this.getView().sendFormAction(view);
    }

    private Map<String, String> getHyperlinkMap(Map<String, Object> pluginInfo) {
        String pluginName = "";
        try {
            Pair pluginPair = (Pair)pluginInfo.get("plugin");
            pluginName = pluginPair != null ? (String)pluginPair.getValue0() : (String)pluginInfo.get("unittestPlugin");
            AbstractDetailDataPlugin detailPlugin = (AbstractDetailDataPlugin)((Object)Class.forName(pluginName).newInstance());
            Map<String, String> hyperlinkMap = detailPlugin.getHyperlinkMap();
            pluginInfo.put("hyperlink", hyperlinkMap);
            pluginInfo.put("hyperlinkEntity", detailPlugin.getHyperlinkEntity());
            return hyperlinkMap;
        }
        catch (Exception e) {
            logger.info(String.format("\u6620\u5c04\u83b7\u53d6\u660e\u7ec6DataSet\u5931\u8d25\uff0cpulgin name is %s", pluginName.substring(pluginName.lastIndexOf(".") + 1)));
            return new HashMap<String, String>(2);
        }
    }
}

