/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.algo.input.CollectionInput;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.bankacct.helper.BankAcctHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;

public class DecisionAnlsHelper {
    private static final Log logger = LogFactory.getLog(AbstractDecisionAnlsQingDataPlugin.class);
    protected static String sumField = "sumlevel";
    public static final String FTRADECOUNT_MAP = "FTRADECOUNT_MAP";
    public static final String FDATARANGE_MAP = "FDATARANGE_MAP";

    public static String[] getSelectField(List<String> sumField) {
        int i = 8;
        String[] fieldArray = new String[sumField.size() + i];
        fieldArray[0] = "mixorgname";
        fieldArray[1] = "rowid";
        fieldArray[2] = "orgid";
        fieldArray[3] = "pid";
        fieldArray[4] = "isgroupnode";
        fieldArray[5] = "level";
        fieldArray[6] = "0 sumlevel";
        fieldArray[7] = "sortcode";
        Iterator<String> iterator = sumField.iterator();
        while (iterator.hasNext()) {
            String s;
            fieldArray[i] = s = iterator.next();
            ++i;
        }
        return fieldArray;
    }

    public static boolean checkEmptyAndClose(DataSet ds) {
        if (ds == null) {
            return true;
        }
        try {
            boolean bl = ds.isEmpty();
            return bl;
        }
        finally {
            ds.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getTopBanks(DataSet topBankDs, String fieldName) {
        HashSet<String> topBanks = new HashSet<String>(16);
        try {
            while (topBankDs.hasNext()) {
                Row row = topBankDs.next();
                topBanks.add(row.getString(fieldName));
            }
        }
        finally {
            topBankDs.close();
        }
        return topBanks;
    }

    public static FilterFunction buildContainFilter(final Set<String> topBanks, final String fieldName) {
        return new FilterFunction(){

            public boolean test(Row row) {
                return DecisionAnlsHelper.testContains(row, topBanks, fieldName);
            }
        };
    }

    public static FilterFunction buildOtherFilter(final Set<String> topBanks, final String fieldName) {
        return new FilterFunction(){

            public boolean test(Row row) {
                return !DecisionAnlsHelper.testContains(row, topBanks, fieldName);
            }
        };
    }

    private static boolean testContains(Row row, Set<String> topBanks, String fieldName) {
        String bankName = row.getString(fieldName);
        if (bankName != null && !bankName.isEmpty()) {
            return topBanks.contains(bankName);
        }
        return false;
    }

    public static DataSet createRow(String className, String[] fieldNames, DataType[] dataTypes, Collection<Object[]> values) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        CollectionInput inputs = new CollectionInput(rowMeta, values);
        return Algo.create((String)className).createDataSet(new Input[]{inputs});
    }

    public static DataSet createRowByDefault(String[] fieldNames, DataType[] dataTypes) {
        ArrayList<Object[]> collection = new ArrayList<Object[]>(2);
        Object[] objects = new Object[fieldNames.length];
        int i = 0;
        for (DataType dataType : dataTypes) {
            objects[i++] = dataType instanceof DateType || dataType instanceof TimestampType ? DataType.convertValue((DataType)dataType, (Object)new Date()) : DataType.convertValue((DataType)dataType, (Object)"0");
        }
        collection.add(objects);
        return DecisionAnlsHelper.createRow("CreateRowByDefault", fieldNames, dataTypes, collection);
    }

    public static DataSet creatAbsentRow(DataSet dataSet, String typeName, List<String> typeValues, int index, Supplier supplier) {
        RowMeta rowMeta = dataSet.getRowMeta();
        typeValues = new ArrayList<String>(typeValues);
        ArrayList<String> exists = new ArrayList<String>(typeValues.size());
        ArrayList<Object[]> collection = new ArrayList<Object[]>();
        for (Row row : dataSet.copy()) {
            exists.add(row.getString(typeName));
        }
        typeValues.removeAll(exists);
        DataSet resultSet = dataSet;
        if (kd.bos.util.CollectionUtils.isNotEmpty(typeValues)) {
            for (String absent : typeValues) {
                Object[] value = (Object[])supplier.get();
                value[index] = absent;
                collection.add(value);
            }
            DataSet createRow = DecisionAnlsHelper.createRow("creatAbsentRow", rowMeta.getFieldNames(), rowMeta.getDataTypes(), collection);
            resultSet = resultSet.union(createRow);
        }
        return resultSet;
    }

    public static DataSet getSumDataSetByLevel(DataSet treeData, List<String> sumFields, String customFields) {
        Set<Integer> levels = DecisionAnlsHelper.getLevels(treeData.copy());
        List levelList = levels.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (Integer level : levelList) {
            if (level == 1) continue;
            String filter = "level=" + level;
            String sumFieldSts = DecisionAnlsHelper.getSumFields(sumFields, false, customFields);
            GroupbyDataSet groupbyDataSet = treeData.copy().filter(filter).select(sumFieldSts.split(",")).groupBy(new String[]{"pid"});
            sumFields.forEach(field -> groupbyDataSet.sum("p" + field));
            DataSet deltailSm = groupbyDataSet.finish();
            String joinFieldSts = DecisionAnlsHelper.getSumFields(sumFields, true, customFields);
            treeData = treeData.leftJoin(deltailSm).on("rowid", "pid").select(joinFieldSts.split(",")).finish();
        }
        return treeData;
    }

    private static Set<Integer> getLevels(DataSet treeData) {
        HashSet<Integer> levels = new HashSet<Integer>();
        DataSet levelDs = treeData.groupBy(new String[]{"level"}).finish();
        levelDs.forEach(o -> {
            if (o.getInteger("level") != null) {
                levels.add(o.getInteger("level"));
            }
        });
        return levels;
    }

    private static String getSumFields(List<String> sumFields, boolean isJoin, String customFields) {
        StringBuilder fieldStrs = new StringBuilder();
        String str = "pid,";
        if (isJoin) {
            str = "rowid, pid, isgroupnode, level, sumlevel,";
        }
        fieldStrs.append(str);
        for (String field : sumFields) {
            String expStr = field + " as p" + field;
            if (isJoin) {
                expStr = field + "+ p" + field + " as " + field;
            }
            fieldStrs.append(expStr).append(',');
        }
        if (isJoin) {
            return fieldStrs.append(customFields).toString();
        }
        return fieldStrs.substring(0, fieldStrs.length());
    }

    /*
     * WARNING - void declaration
     */
    public static DataSet ChangeRowToColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField) {
        DataSet tempDs = ds.copy();
        LinkedHashSet<DataSet> dsSet = new LinkedHashSet<DataSet>(10);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(10);
        while (tempDs.hasNext()) {
            void var11_11;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            String fieldName = beginChangeField + fieldValue;
            String string = changeField + " = '" + fieldValue + "'";
            if (!dateType.equals((Object)DataType.StringType)) {
                String string2 = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            DataSet ds1 = ds.copy().filter((String)var11_11).select(groupFieldName + ", count as " + fieldName);
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        ArrayList<String> fieldNameList = new ArrayList<String>(result.getRowMeta().getFieldNames().length * dsSet.size());
        Collections.addAll(fieldNameList, result.getRowMeta().getFieldNames());
        for (DataSet dsTemp : dsSet) {
            void var11_17;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            for (String fieldName : dsTemp.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var11_17.on(groupField.trim(), groupField.trim());
            }
            result = var11_17.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static DataSet ChangeRowToMultiColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField, Map<String, String> fieldMap) {
        DataSet tempDs = ds.copy();
        LinkedHashSet<DataSet> dsSet = new LinkedHashSet<DataSet>(10);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(10);
        while (tempDs.hasNext()) {
            void var12_12;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            String fieldName = beginChangeField + fieldValue;
            String string = changeField + " = '" + fieldValue + "'";
            if (!dateType.equals((Object)DataType.StringType)) {
                String string2 = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            StringJoiner fieldJoiner = new StringJoiner(", ");
            fieldMap.forEach((k, v) -> fieldJoiner.add(k + " as " + fieldName + "_" + v));
            DataSet ds1 = ds.copy().filter((String)var12_12).select(groupFieldName + "," + fieldJoiner);
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        ArrayList<String> fieldNameList = new ArrayList<String>(result.getRowMeta().getFieldNames().length * dsSet.size());
        Collections.addAll(fieldNameList, result.getRowMeta().getFieldNames());
        for (DataSet dsTemp : dsSet) {
            void var12_18;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            for (String fieldName : dsTemp.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var12_18.on(groupField.trim(), groupField.trim());
            }
            result = var12_18.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static DataSet ChangeMultRowToColDataSet(DataSet ds, String changeField, String groupFieldName, String beginChangeField, List<String> changeFieldNames) {
        DataSet tempDs = ds.copy();
        HashSet<DataSet> dsSet = new HashSet<DataSet>(10);
        HashMap<String, String> dsFieldName = new HashMap<String, String>(10);
        while (tempDs.hasNext()) {
            void var12_12;
            Row row = tempDs.next();
            DataType dateType = tempDs.getRowMeta().getField(changeField).getDataType();
            String fieldValue = row.getString(changeField);
            StringBuilder fieldName = new StringBuilder();
            for (String changeFieldName : changeFieldNames) {
                fieldName.append(", ").append(changeFieldName).append(" as ").append(beginChangeField).append(fieldValue).append(changeFieldName);
            }
            String string = changeField + " = '" + fieldValue + "'";
            if (!dateType.equals((Object)DataType.StringType)) {
                String string2 = changeField + " = " + fieldValue;
            }
            if (dsFieldName.get(fieldValue) != null) continue;
            DataSet ds1 = ds.copy().filter((String)var12_12).select(groupFieldName + fieldName);
            dsSet.add(ds1);
            dsFieldName.put(fieldValue, "");
        }
        DataSet result = ds.copy().select(groupFieldName).groupBy(groupFieldName.split(",")).finish();
        for (DataSet dsTemp : dsSet) {
            void var12_19;
            if (result == null) {
                result = dsTemp;
                continue;
            }
            ArrayList<String> fieldNameList = new ArrayList<String>();
            Collections.addAll(fieldNameList, dsTemp.getRowMeta().getFieldNames());
            for (String fieldName : result.getRowMeta().getFieldNames()) {
                if (fieldNameList.contains(fieldName)) continue;
                fieldNameList.add(fieldName);
            }
            JoinDataSet joinDataSet = result.join(dsTemp, JoinType.LEFT);
            for (String groupField : groupFieldName.split(",")) {
                JoinDataSet joinDataSet2 = var12_19.on(groupField.trim(), groupField.trim());
            }
            result = var12_19.select(fieldNameList.toArray(new String[fieldNameList.size()])).finish();
        }
        return result;
    }

    public static DataSet addAllTotalDataSet(DataSet bizDs, List<String> sumFields, String sumNameField) {
        return DecisionAnlsHelper.addAllTotalDataSet(bizDs, sumFields, null, sumNameField);
    }

    public static DataSet addAllTotalDataSet(DataSet bizDs, List<String> sumFields, List<String> gruopFields, String sumNameField) {
        Field[] fields;
        DataSet dsTemp = bizDs.copy();
        String[] groupField = null;
        if (EmptyUtil.isNoEmpty(gruopFields)) {
            groupField = gruopFields.toArray(new String[0]);
        }
        GroupbyDataSet gdsTemp = dsTemp.filter(sumField + " = 0").groupBy(groupField);
        for (String sumField : sumFields) {
            gdsTemp.sum(sumField);
        }
        DataSet ds = gdsTemp.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = bizDs.getRowMeta().getFields()) {
            if (sumFields.contains(field.getName())) {
                selectField.add(field.getName());
                continue;
            }
            if (field.getName().equals(sumNameField)) {
                selectField.add(String.format(DecisionAnlsHelper.getKDString() + " as %s", field.getName()));
                continue;
            }
            if (field.getName().equals(sumField)) {
                selectField.add("2 as " + sumField);
                continue;
            }
            if (gruopFields != null && gruopFields.contains(field.getName().trim())) {
                selectField.add(field.getName());
                continue;
            }
            selectField.add("NULL as " + field.getName());
        }
        return ds.select(String.join((CharSequence)",", selectField));
    }

    private static String getKDString() {
        return ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"DecisionAnlsHelper_2", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static DataSet getAcctByOrgIdAndDate(List<Long> orgIds, Date queryDate, Long orgview) {
        DataSet allDataSet = DecisionAnlsHelper.dormantDataSet(orgIds, queryDate).groupBy(new String[]{"openorg"}).count("acctcount").finish();
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        DataSet ds = orgDataSet.leftJoin(allDataSet).on("rowid", "openorg").select(new String[]{"orgname", "simplename", "mixorgname", "rowid", "orgid", "pid", "isgroupnode", "level", "0 sumlevel", "acctcount", "sortcode"}).finish();
        return DecisionAnlsHelper.getSumDataSetByLevel(ds, Collections.singletonList("acctcount"), "orgname,simplename,orgid,mixorgname,sortcode").filter("acctcount > 0");
    }

    public static DataSet dormantDataSet(List<Long> orgIds, Date queryDate) {
        QFilter[] dailyFilters;
        Map<String, Object> settingFilterMap = DecisionAnlsHelper.dormantSettingFilter(queryDate);
        QFilter dailytimefilter = new QFilter("bizdate", ">=", settingFilterMap.get("queryStartDate")).and(new QFilter("bizdate", "<=", settingFilterMap.get("queryEndDate")));
        QFilter acctimefilter = new QFilter("opendate", "<=", settingFilterMap.get("queryStartDate"));
        QFilter orgfilter = new QFilter("openorg.id", "in", orgIds);
        ArrayList<String> isfin = new ArrayList<String>();
        isfin.add(FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        isfin.add(FinOrgTypeEnum.FINCOMP.getValue());
        QFilter finorgtypefilter = new QFilter("finorgtype", "not in", isfin);
        QFilter acctstatusfilter = new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue());
        QFilter[] acctfilters = new QFilter[]{acctimefilter, orgfilter, finorgtypefilter, acctstatusfilter};
        DataSet acctDataSet = QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)"bd_accountbanks", (String)"id,openorg,bankaccountnumber,finorgtype,issetbankinterface", (QFilter[])acctfilters, null);
        QFilter acctFilter = new QFilter("accountbank", "in", (Object)DecisionCommonHelper.getFieldValues((DataSet)acctDataSet.copy(), (String)"id", Long.class));
        DataSet dailyAllDataSet = null;
        String dormantConfig = BankAcctHelper.getDormantConfig();
        if ("bankjournal".equalsIgnoreCase(dormantConfig)) {
            dailyFilters = new QFilter[]{dailytimefilter, acctFilter};
            dailyAllDataSet = DecisionAnlsHelper.queryTradeCountByEntity("cas_bankjournal", dailyFilters);
        } else if ("transdetail".equalsIgnoreCase(dormantConfig)) {
            dailyFilters = new QFilter[]{dailytimefilter, acctFilter};
            dailyAllDataSet = DecisionAnlsHelper.queryTradeCountByEntity("bei_transdetail", dailyFilters);
        } else if ("other".equalsIgnoreCase(dormantConfig)) {
            Map<String, List<Long>> acctIdMap = DecisionAnlsHelper.getAcctIdMap(acctDataSet);
            List<Long> innerList = acctIdMap.get("inner");
            List<Long> normalList = acctIdMap.get("normal");
            QFilter innerAcctFilter = new QFilter("accountbank", "in", (Object)innerList.toArray());
            QFilter[] dailyFilters2 = new QFilter[]{dailytimefilter, innerAcctFilter};
            dailyAllDataSet = DecisionAnlsHelper.queryTradeCountByEntity("bei_transdetail", dailyFilters2);
            QFilter normalAcctFilter = new QFilter("accountbank", "in", (Object)normalList.toArray());
            dailyFilters2 = new QFilter[]{dailytimefilter, normalAcctFilter};
            dailyAllDataSet = dailyAllDataSet == null ? DecisionAnlsHelper.queryTradeCountByEntity("cas_bankjournal", dailyFilters2) : dailyAllDataSet.union(DecisionAnlsHelper.queryTradeCountByEntity("cas_bankjournal", dailyFilters2));
        }
        HashMap<String, Object> count = new HashMap<String, Object>();
        count.put("tradenumber", settingFilterMap.get("tradenumber"));
        return acctDataSet.join(dailyAllDataSet, JoinType.LEFT).on("bankaccountnumber", "accountbank.bankaccountnumber").select(new String[]{"id", "openorg"}, new String[]{"tradecount"}).finish().filter("tradecount<tradenumber", count);
    }

    private static Map<String, List<Long>> getAcctIdMap(DataSet acctDs) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(10);
        ArrayList initList = new ArrayList(10);
        map.put("inner", initList);
        map.put("normal", initList);
        DataSet acctDs0 = acctDs.copy();
        DataSet innerDs = acctDs0.filter("finorgtype = '1' or finorgtype = '3' or issetbankinterface = true ").select("id");
        map.put("inner", new ArrayList(DecisionCommonHelper.getFieldValues((DataSet)innerDs, (String)"id", Long.class)));
        DataSet acctDs1 = acctDs.copy();
        DataSet normalDs = acctDs1.filter("finorgtype <> '1' and finorgtype <> '3' and issetbankinterface = false ").select("id");
        map.put("normal", new ArrayList(DecisionCommonHelper.getFieldValues((DataSet)normalDs, (String)"id", Long.class)));
        return map;
    }

    private static DataSet queryTradeCountByEntity(String entity, QFilter[] dailyFilters) {
        return QueryServiceHelper.queryDataSet((String)"dormantAcct", (String)entity, (String)"accountbank.bankaccountnumber", (QFilter[])dailyFilters, null).groupBy(new String[]{"accountbank.bankaccountnumber"}).count("tradecount").finish();
    }

    public static Map<String, Object> dormantSettingFilter(Date queryDate) {
        HashMap<String, Object> settingFilterMap = new HashMap<String, Object>();
        int tradenumber = 5;
        String datarange = "sixmonth";
        try (TXHandle txHandle = TX.requiresNew();){
            String selectStr = "SELECT FTRADECOUNT,FDATARANGE FROM T_AM_DORMANTSET";
            Map info = (Map)DB.query((DBRoute)DBRouteConst.SYS, (String)selectStr, (Object[])new Object[0], rs -> {
                HashMap<String, String> lockInfo = new HashMap<String, String>();
                if (rs.next()) {
                    lockInfo.put(FTRADECOUNT_MAP, rs.getString(1));
                    lockInfo.put(FDATARANGE_MAP, rs.getString(2));
                }
                return lockInfo;
            });
            if (info.size() != 0) {
                tradenumber = Integer.parseInt((String)info.get(FTRADECOUNT_MAP));
                datarange = (String)info.get(FDATARANGE_MAP);
            }
        }
        Date queryStartDate = new Date();
        Date queryEndDate = new Date();
        if (datarange.contains(RptDateRangeEnum.CUSTOM.getValue())) {
            String[] data = datarange.split("&");
            if (data.length == 3) {
                queryStartDate = new Date(Long.parseLong(data[1]));
                queryEndDate = new Date(Long.parseLong(data[2]));
            }
        } else {
            queryStartDate = DecisionAnlsHelper.transRange2Date(datarange, queryDate);
            queryEndDate = DateUtils.getNextDay((Date)queryDate, (int)1);
        }
        settingFilterMap.put("queryStartDate", queryStartDate);
        settingFilterMap.put("queryEndDate", queryEndDate);
        settingFilterMap.put("tradenumber", tradenumber);
        return settingFilterMap;
    }

    public static Date transRange2Date(String datarange, Date queryDate) {
        Date endDate = DateUtils.getNextDay((Date)queryDate, (int)1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        if (RptDateRangeEnum.ONEMONTH.getValue().equals(datarange)) {
            calendar.add(2, -1);
        } else if (RptDateRangeEnum.THREEMONTH.getValue().equals(datarange)) {
            calendar.add(2, -3);
        } else if (RptDateRangeEnum.SIXMONTH.getValue().equals(datarange)) {
            calendar.add(2, -6);
        } else if (RptDateRangeEnum.NIGHTMONTH.getValue().equals(datarange)) {
            calendar.add(2, -9);
        } else if (RptDateRangeEnum.ONEYEAR.getValue().equals(datarange)) {
            calendar.add(1, -1);
        } else if (RptDateRangeEnum.TWOYEAR.getValue().equals(datarange)) {
            calendar.add(1, -2);
        } else if (RptDateRangeEnum.THREEYEAR.getValue().equals(datarange)) {
            calendar.add(1, -3);
        }
        return DateUtils.getDataFormat((Date)calendar.getTime(), (boolean)true);
    }

    public static DataSet getAcctSetByType(DataSet allDataSet, AcctDisplayByBankTypeEnum acctDisplayByBankTypeEnum) {
        String isDomesticFilter = "true";
        if (acctDisplayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC) {
            isDomesticFilter = "isdomestic = '1'";
        } else if (acctDisplayByBankTypeEnum == AcctDisplayByBankTypeEnum.OVERSEAS) {
            isDomesticFilter = "isdomestic = '0'";
        }
        return allDataSet.filter(isDomesticFilter);
    }

    public static DataSet getAcctByType(DataSet allDataSet, AcctDisplayByBankTypeEnum acctDisplayByBankTypeEnum) {
        allDataSet = allDataSet.filter("finorgtype = '0'");
        String isDomesticFilter = "true";
        if (acctDisplayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC) {
            isDomesticFilter = "isdomestic = '1'";
        } else if (acctDisplayByBankTypeEnum == AcctDisplayByBankTypeEnum.OVERSEAS) {
            isDomesticFilter = "isdomestic = '0'";
        }
        return allDataSet.filter(isDomesticFilter);
    }

    public static Map<String, String> getTopBankCate(DataSet bankAcctSet, int top) {
        LinkedHashMap<String, String> topBank = new LinkedHashMap<String, String>(20);
        DataSet topBankCateSet = bankAcctSet.copy();
        topBankCateSet = top == 0 ? topBankCateSet.filter("bankcate > 0").groupBy(new String[]{"bankcate", "bankname"}).count("num").finish().orderBy(new String[]{"num desc"}) : topBankCateSet.filter("bankcate > 0").groupBy(new String[]{"bankcate", "bankname"}).count("num").finish().orderBy(new String[]{"num desc"}).top(top);
        while (topBankCateSet.hasNext()) {
            Row row = topBankCateSet.next();
            topBank.put(row.getLong(0).toString(), row.getString(1));
        }
        return topBank;
    }

    public static Map<String, String> getTopBankCate(DataSet bankAcctSet, String sumAndOrderbyCol, int top) {
        LinkedHashMap<String, String> topBank = new LinkedHashMap<String, String>(20);
        DataSet topBankCateSet = bankAcctSet.copy().filter("bankcate > 0").select(new String[]{"bankcate", "bankname", sumAndOrderbyCol}).groupBy(new String[]{"bankcate", "bankname"}).sum(sumAndOrderbyCol).finish().orderBy(new String[]{sumAndOrderbyCol + " desc", "bankcate desc"}).top(top);
        while (topBankCateSet.hasNext()) {
            Row row = topBankCateSet.next();
            topBank.put(row.getLong(0).toString(), row.getString(1));
        }
        return topBank;
    }

    public static Pair<DataSet, DataSet> splitTopBank(DataSet bankDataSet, String sumAndOrderbyCol, int top) {
        Set<String> topBankCate;
        Set<String> set = topBankCate = StringUtils.isEmpty((CharSequence)sumAndOrderbyCol) ? DecisionAnlsHelper.getTopBankCate(bankDataSet.copy(), top).keySet() : DecisionAnlsHelper.getTopBankCate(bankDataSet.copy(), sumAndOrderbyCol, top).keySet();
        if (!topBankCate.isEmpty()) {
            String topFilter = "bankcate in (" + String.join((CharSequence)",", topBankCate) + ")";
            DataSet[] splitTopDataSet = bankDataSet.splitByFilter(new String[]{topFilter}, true);
            if (splitTopDataSet != null && splitTopDataSet.length > 1) {
                return new Pair((Object)splitTopDataSet[0], (Object)splitTopDataSet[1]);
            }
            return new Pair((Object)bankDataSet, (Object)DecisionAnlsHelper.createEmptyDataSet(bankDataSet.getRowMeta()));
        }
        return new Pair((Object)bankDataSet, (Object)DecisionAnlsHelper.createEmptyDataSet(bankDataSet.getRowMeta()));
    }

    public static Pair<DataSet, DataSet> splitTopBank(DataSet bankDataSet, int top) {
        return DecisionAnlsHelper.splitTopBank(bankDataSet, null, top);
    }

    public static QFilter getCreditFilter() {
        return new QFilter("finorgtype", "in", (Object)new String[]{FinOrgTypeEnum.BANK.getValue(), FinOrgTypeEnum.FINCOMP.getValue()});
    }

    public static DataSet getfinCompCreditLimit(DataSet allDataSet) {
        return allDataSet.filter("finorgtype = '3'");
    }

    public static Map<String, String> getTopCreditLimitBankCate(DataSet bankCreditLimitSet) {
        LinkedHashMap<String, String> topBank = new LinkedHashMap<String, String>(20);
        DataSet topBankCateSet = bankCreditLimitSet.copy().filter("bankcate > 0").select(new String[]{"bankcate", "bankname", "totalamt", "useamt"}).groupBy(new String[]{"bankcate", "bankname"}).sum("totalamt").sum("useamt").finish().orderBy(new String[]{"totalamt desc"}).top(10);
        while (topBankCateSet.hasNext()) {
            Row row = topBankCateSet.next();
            topBank.put(row.getLong(0).toString(), row.getString(1));
        }
        return topBank;
    }

    public static Pair<DataSet, DataSet> splitCreditLimitTopBank(DataSet bankDataSet) {
        Set<String> topBankCate = DecisionAnlsHelper.getTopCreditLimitBankCate(bankDataSet.copy()).keySet();
        if (!topBankCate.isEmpty()) {
            String topFilter = "bankcate in (" + String.join((CharSequence)",", topBankCate) + ")";
            String notTopFilter = "bankcate not in (" + String.join((CharSequence)",", topBankCate) + ")";
            DataSet topBankCreditLimitSet = bankDataSet.copy().filter(topFilter);
            DataSet nonTopBankCreditLimitSet = bankDataSet.filter(notTopFilter);
            return new Pair((Object)topBankCreditLimitSet, (Object)nonTopBankCreditLimitSet);
        }
        return new Pair((Object)bankDataSet.copy(), (Object)bankDataSet.copy().filter("1 = 0"));
    }

    public static Date getQueryDate(Map<String, Object> paramMap) {
        Object date = paramMap.get("querydate");
        Date queryDate = date == null ? DateUtils.getCurrentDate() : (date instanceof String ? DateUtils.stringToDate((String)((String)date), (String)"yyyy-MM-dd HH:mm:ss") : (Date)date);
        return DateUtils.truncateDate((Date)queryDate);
    }

    public static ReportQueryParam tranFilterToParam(ReportQueryParam param, QFilter[] filters) {
        List filterItems = param.getFilter().getFilterItems();
        for (QFilter fi : filters) {
            if (param.getFilter().containProp(fi.getProperty())) {
                for (FilterItemInfo filterItem : filterItems) {
                    if (!fi.getProperty().equals(filterItem.getPropName())) continue;
                    filterItem.setValue(fi.getValue());
                }
                continue;
            }
            param.getFilter().addFilterItem(fi.getProperty(), fi.getValue());
        }
        Long orgViewId = ((DynamicObject)param.getFilter().getFilterItem("orgview").getValue()).getLong("id");
        Long orgId = ((DynamicObject)param.getFilter().getFilterItem("org").getValue()).getLong("id");
        List orgIdList = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        if (param.getFilter().containProp("allorgids")) {
            for (FilterItemInfo filterItem : filterItems) {
                if (!"allorgids".equals(filterItem.getPropName())) continue;
                filterItem.setValue((Object)orgIdList);
            }
        } else {
            param.getFilter().addFilterItem("allorgids", (Object)orgIdList);
        }
        logger.info("------\u83b7\u53d6\u7ec4\u7ec7\u7684\u6240\u6709\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u8d70\u67e5\u8be2\uff1a" + orgViewId + "-" + orgId);
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        if (param.getFilter().containProp("suborgids")) {
            for (FilterItemInfo filterItem : filterItems) {
                if (!"suborgids".equals(filterItem.getPropName())) continue;
                filterItem.setValue((Object)subOrgIds);
            }
        } else {
            param.getFilter().addFilterItem("suborgids", (Object)subOrgIds);
        }
        if (param.getFilter().containProp("basecurrency")) {
            for (FilterItemInfo filterItem : filterItems) {
                if (!"basecurrency".equals(filterItem.getPropName())) continue;
                filterItem.setValue((Object)AmountTransHelper.getBaseCurrency((Long)orgViewId));
            }
        } else {
            param.getFilter().addFilterItem("basecurrency", (Object)AmountTransHelper.getBaseCurrency((Long)orgViewId));
        }
        return param;
    }

    public static DataSet addAbsentFields(DataSet dataSet, List<String> checkFields) {
        return DecisionAnlsHelper.addAbsentFields(dataSet, checkFields, "0");
    }

    public static DataSet addAbsentFields(DataSet dataSet, List<String> checkFields, String defaultValue) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        ArrayList<String> tempFields = new ArrayList<String>(checkFields);
        tempFields.removeAll(new HashSet<String>(Arrays.asList(fieldNames)));
        if (!CollectionUtils.isEmpty(tempFields)) {
            String[] value = new String[tempFields.size()];
            for (int i = 0; i < tempFields.size(); ++i) {
                value[i] = defaultValue;
            }
            dataSet = dataSet.addFields(value, tempFields.toArray(new String[0]));
        }
        return dataSet;
    }

    public static DataSet updateValueWhenNull(DataSet dataSet, List<String> fields) {
        String exp1 = "case when ";
        String exp2 = " = NULL then 0 else ";
        String exp3 = " end";
        String[] value = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            value[i] = exp1 + fields.get(i) + exp2 + fields.get(i) + exp3;
        }
        dataSet = dataSet.updateFields(fields.toArray(new String[0]), value);
        return dataSet;
    }

    public static DataSet removeNoDataTreeDs(DataSet treeData, List<String> amountFields, boolean updateIsGroupnode) {
        String[] fieldNames = treeData.getRowMeta().getFieldNames();
        treeData = treeData.copy().filter(DecisionAnlsHelper.getFilterStr(amountFields)).select(fieldNames);
        if (updateIsGroupnode) {
            DataSet pidGroupDs = treeData.copy().groupBy(new String[]{"pid"}).finish().select("pid parentid");
            treeData = treeData.leftJoin(pidGroupDs).on("rowid", "parentid").select(fieldNames, new String[]{"parentid"}).finish();
            treeData = treeData.updateField("isgroupnode", "case when parentid=null then 0 else 1 end ");
        }
        return treeData;
    }

    private static String getFilterStr(List<String> amountFields) {
        StringBuilder filter = new StringBuilder();
        amountFields.forEach(o -> {
            filter.append("( ");
            filter.append((String)o);
            filter.append(" !=0 and ");
            filter.append((String)o);
            filter.append("!=null ) or ");
        });
        return filter.substring(0, filter.length() - 4);
    }

    public static DataSet getDateDateSet(Date queryDate) {
        ArrayList<Object[]> dateDataSetRow = new ArrayList<Object[]>(12);
        for (int i = 0; i < 11; ++i) {
            Date thisDate = i == 0 ? queryDate : DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-i));
            dateDataSetRow.add(new Object[]{DateUtils.formatString((Date)thisDate, (String)"yyyyMM"), DateUtils.formatString((Date)thisDate, (String)"yyyyMM"), i});
        }
        Date firstDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-11);
        dateDataSetRow.add(new Object[]{DateUtils.formatString((Date)firstDate, (String)"yyyyMM"), DateUtils.formatString((Date)firstDate, (String)"yyyyMM"), 11});
        Collections.reverse(dateDataSetRow);
        return DecisionAnlsHelper.createRow("kd.tmc.tda.report.common.helper.DecisionAnlsHelper.getDateDateSet", new String[]{"datestring", "showname", "sortnum"}, new DataType[]{DataType.StringType, DataType.StringType, DateType.IntegerType}, dateDataSetRow);
    }

    public static DataSet createEmptyDataSet(RowMeta rowMeta) {
        return DecisionAnlsHelper.createEmptyDataSet(rowMeta.getFieldNames(), rowMeta.getDataTypes());
    }

    public static DataSet createEmptyDataSet(String[] fieldNames, DataType[] dataTypes) {
        RowMeta rowMeta = new RowMeta(fieldNames, dataTypes);
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }

    public static List<ValueMapItem> getEnumItemsByProperty(String entity, String property) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        DynamicProperty propertyObj = dataEntityType.getProperty(property);
        if (propertyObj == null) {
            return null;
        }
        return ((ComboProp)propertyObj).getComboItems();
    }

    public static DataSet typeGroupFiledSum(DataSet ds, String groupFileds, String prefix, String singleTypeFiled, List<String> sumFields, List<String> needColFiled) {
        DataSet[] groupDataSet = ds.copy().splitByGroup(new String[]{singleTypeFiled});
        if (needColFiled == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7c7b\u522b\u5206\u7ec4\u540e\u5217\u5b57\u6bb5\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (String)"DecisionAnlsHelper_10", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        String[] groupFiledArr = groupFileds.split(",");
        int len = groupFiledArr.length;
        String[] groupArr = new String[len + 1];
        for (int i = 0; i < groupFiledArr.length; ++i) {
            groupFiledArr[i] = groupFiledArr[i].trim();
            groupArr[i] = groupFiledArr[i];
        }
        groupArr[len] = singleTypeFiled;
        GroupbyDataSet baseSetGroup = ds.groupBy(groupArr);
        for (String sumField : sumFields) {
            baseSetGroup.sum(sumField, "total_" + sumField);
            needColFiled.add("total_" + sumField);
        }
        DataSet baseSet = baseSetGroup.finish();
        int size = sumFields.size() + 1;
        for (DataSet dataSet : groupDataSet) {
            if (dataSet.isEmpty()) continue;
            Row row = dataSet.copy().next();
            String groupFiledValue = row.getString(singleTypeFiled);
            GroupbyDataSet dataSetGroup = dataSet.groupBy(groupArr);
            ArrayList<String> newField = new ArrayList<String>(size);
            for (String string : sumFields) {
                String alias = prefix + groupFiledValue + string;
                dataSetGroup.sum(string, alias);
                newField.add(alias);
                needColFiled.add(alias);
            }
            dataSet = dataSetGroup.finish();
            JoinDataSet joinDataSet = baseSet.leftJoin(dataSet);
            for (String groupF : groupArr) {
                joinDataSet = joinDataSet.on(groupF, groupF);
            }
            HashSet<String> hashSet = new HashSet<String>(newField);
            hashSet.addAll(Arrays.asList(baseSet.getRowMeta().getFieldNames()));
            baseSet = joinDataSet.select(hashSet.toArray(new String[0])).finish();
        }
        GroupbyDataSet groupByDS = baseSet.groupBy(groupFiledArr);
        for (String sumField : needColFiled) {
            groupByDS.sum(sumField);
        }
        return groupByDS.finish();
    }

    public static Map<String, String> getFieldMap(DataSet dataSet, String typeField) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Iterator iterator = dataSet.copy().iterator();
        HashSet<Integer> hashCodes = new HashSet<Integer>(32);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String field = row.getString(typeField);
            String hashCode = String.valueOf(DecisionAnlsHelper.getHashCode(hashCodes, typeField));
            map.put(hashCode, field);
        }
        return map;
    }

    public static int getHashCode(Set<Integer> hashCodes, String s) {
        int i = s.hashCode();
        if (i < 0) {
            i = -1 * i;
        }
        if (hashCodes == null) {
            return i;
        }
        while (hashCodes.contains(i)) {
            ++i;
        }
        return i;
    }
}

