/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.helper;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.QueryEvent;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.snap.IDataSnapExecute;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.TdaCommonHelper;

public class TdaRptDataServiceHelper {
    private static final Log logger = LogFactory.getLog(TdaRptDataServiceHelper.class);

    public static DataSet getRptData(ReportQueryParam queryParam, String entity, String rptType) throws Throwable {
        String queryPlugin = TdaRptDataServiceHelper.getQueryPluginByEntity(entity, rptType);
        if (EmptyUtil.isEmpty((String)queryPlugin)) {
            logger.info("TdaRptDataServiceHelper--getQueryPluginByEntity\u83b7\u53d6\u8868\u5355\u53d6\u6570\u63d2\u4ef6\u4e3a\u7a7a\uff1a\u8868\u5355\uff1a" + entity + "\u7c7b\u578b" + rptType);
            return null;
        }
        logger.info("TdaRptDataServiceHelper--getQueryPluginByEntity\u83b7\u53d6\u8868\u5355\u53d6\u6570\u63d2\u4ef6\u4e3a" + queryPlugin + "\u8868\u5355\uff1a" + entity);
        return TdaRptDataServiceHelper.getRptDataByPlugin(queryParam, entity, queryPlugin, rptType);
    }

    public static DataSet getRptDataByPlugin(ReportQueryParam queryParam, String entity, String queryPlugin, String rptType) throws Throwable {
        Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)queryParam);
        if ("qing".equals(rptType)) {
            QFilter orgViewFilter = new QFilter("orgview", "=", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)paramMap.get("orgview")).getLong("id"), (String)"fbd_companysysviewsch"));
            QFilter orgFilter = new QFilter("org", "=", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)paramMap.get("org")).getLong("id"), (String)"bos_org"));
            QFilter currencyFilter = new QFilter("currency", "=", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)paramMap.get("currency")).getLong("id"), (String)"bd_currency"));
            QFilter queryDateFilter = new QFilter("querydate", "=", paramMap.get("querydate"));
            QFilter unitFilter = new QFilter("amountunit", "=", paramMap.get("amountunit"));
            QFilter[] qFilters = new QFilter[]{orgViewFilter, orgFilter, queryDateFilter, currencyFilter, unitFilter};
            IDataSnapExecute pluginInstance = (IDataSnapExecute)Class.forName(queryPlugin).newInstance();
            DataSet bizDs = pluginInstance.data(entity, "", qFilters);
            Set amountFields = TdaCommonHelper.getAmountFields((IDataSnapExecute)pluginInstance);
            if (EmptyUtil.isNoEmpty((Object)amountFields)) {
                bizDs = AmountTransHelper.dealRowOtherValue((DataSet)bizDs, (Map)paramMap, (Set)amountFields);
            }
            return bizDs;
        }
        if ("rpt".equals(rptType)) {
            Class pluginClass = TypesContainer.getOrRegister((String)queryPlugin.trim());
            AbstractReportListDataPlugin reportPlugin = (AbstractReportListDataPlugin)pluginClass.newInstance();
            Map customMap = queryParam.getCustomParam();
            String pageId = TdaRptDataServiceHelper.createPage(entity, customMap);
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            formView.getFormShowParameter().getCustomParams().putAll(customMap);
            TdaRptDataServiceHelper.fillValuesAndFireQuery(queryParam, paramMap, formView);
            TdaRptDataServiceHelper.setQueryParam(queryParam, reportPlugin);
            DynamicObjectCollection orgs = new DynamicObjectCollection();
            orgs.add((Object)((DynamicObject)paramMap.get("org")));
            queryParam.getFilter().addFilterItem("filter_company", (Object)orgs);
            queryParam.getCustomParam().putAll(customMap);
            DataSet ds = reportPlugin.query(queryParam, null);
            return ds;
        }
        AbstractTmcListDataPlugin pluginInstance = (AbstractTmcListDataPlugin)Class.forName(queryPlugin).newInstance();
        TdaRptDataServiceHelper.tranQueryParam(queryParam, paramMap);
        queryParam.getCustomParam().put("entity", entity);
        DataSet bizDs = pluginInstance.query(queryParam, null);
        return bizDs;
    }

    private static ReportViewPluginProxy fillValuesAndFireQuery(ReportQueryParam reportQueryParam, Map<String, Object> paramMap, IFormView formView) {
        IDataModel model = formView.getModel();
        model.setValue("orgview", paramMap.get("orgview"));
        DynamicObjectCollection orgs = new DynamicObjectCollection();
        orgs.add((Object)((DynamicObject)paramMap.get("org")));
        model.setValue("filter_company", (Object)orgs);
        model.setValue("querydate", paramMap.get("querydate"));
        model.setValue("currency", paramMap.get("currency"));
        model.setValue("amountunit", paramMap.get("amountunit"));
        ReportViewPluginProxy pluginProxy = (ReportViewPluginProxy)formView.getService(FormViewPluginProxy.class);
        QueryEvent queryEvt = new QueryEvent();
        queryEvt.setQueryParam(reportQueryParam);
        pluginProxy.fireVerifyQuery(queryEvt);
        pluginProxy.fireBeforeQuery(reportQueryParam);
        return pluginProxy;
    }

    public static void tranQueryParam(ReportQueryParam queryParam, Map<String, Object> paramMap) {
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List<Long> orgIdSet = Collections.singletonList(orgId);
        List orgIdList = TmcOrgDataHelper.getAllSubordinateOrgs((Long)orgView.getLong("id"), orgIdSet, (boolean)true, (boolean)false);
        queryParam.getFilter().addFilterItem("allorgids", (Object)orgIdList);
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIds((Long)orgView.getLong("id"), (Long)orgId, (boolean)true, (boolean)false);
        if (subOrgIds != null) {
            queryParam.getFilter().addFilterItem("suborgids", (Object)subOrgIds);
        }
        queryParam.getFilter().addFilterItem("basecurrency", (Object)AmountTransHelper.getBaseCurrency((Long)orgView.getLong("id")));
        DynamicObjectCollection orgs = new DynamicObjectCollection();
        orgs.add((Object)((DynamicObject)paramMap.get("org")));
        queryParam.getFilter().addFilterItem("filter_company", (Object)orgs);
    }

    public static String getQueryPluginByEntity(String entity, String rptType) {
        if ("qing".equals(rptType) || "rpt".equals(rptType)) {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fcs_snapschedule", (String)"number,queryplugin", (QFilter[])new QFilter("number", "=", (Object)entity).toArray());
            return dynamicObject.getString("queryplugin");
        }
        Map pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity);
        if (pluginInfo.get("plugin") != null) {
            Pair pluginPair = (Pair)pluginInfo.get("plugin");
            return (String)pluginPair.getValue0();
        }
        if (pluginInfo.get("unittestPlugin") != null) {
            return (String)pluginInfo.get("unittestPlugin");
        }
        return "";
    }

    private static void setQueryParam(ReportQueryParam queryParam, AbstractReportListDataPlugin reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        Field queryParamField = AbstractReportListDataPlugin.class.getDeclaredField("queryParam");
        ReflectionUtils.makeAccessible((Field)queryParamField);
        queryParamField.set(reportPlugin, queryParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPage(String formId, Map<String, Object> cumstomParam) {
        FormShowParameter listShowParameter = TdaRptDataServiceHelper.createFormShowParameter(formId);
        listShowParameter.getCustomParams().putAll(cumstomParam);
        Map items = FormConfigFactory.createConfig((FormShowParameter)listShowParameter);
        String pageId = (String)items.get("pageId");
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        IFormController srv = (IFormController)formView.getService(IFormController.class);
        try {
            srv.loadData();
        }
        finally {
            srv.destory();
        }
        return pageId;
    }

    public static FormShowParameter createFormShowParameter(String formId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", formId);
        FormShowParameter listShowParameter = FormShowParameter.createFormShowParameter(mapParam);
        listShowParameter.setFormId(formId);
        listShowParameter.setAppId(TdaRptDataServiceHelper.getAppId(formId));
        return listShowParameter;
    }

    public static String getAppId(String formId) {
        QFilter filter = new QFilter("number", "=", (Object)formId);
        DynamicObject reportForm = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])filter.toArray());
        return reportForm.getString("bizappid");
    }
}

