/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.credit.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.credit.helper.CreditLimitHelper;

public class CreditLimitByAreaDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static String ORG_NAME = "org_name";
    private static String DOMESTIC = "domestic";
    private static String OVERSEAS = "overseas";
    private static List<String> TOTAL_FIELDS = Arrays.asList("totalamt_" + DOMESTIC, "useamt_" + DOMESTIC, "avaramt_" + DOMESTIC, "totalamt_" + OVERSEAS, "useamt_" + OVERSEAS, "avaramt_" + OVERSEAS, "totalamt", "useamt", "avaramt");

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        return CreditLimitHelper.query(this.transQueryParam(reportQueryParam));
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        if (ds.copy().isEmpty()) {
            return ds;
        }
        Map paramMap = this.transQueryParam(queryParam);
        DataSet processDataSet = CreditLimitHelper.processDataSet(ds, paramMap);
        if (processDataSet.copy().isEmpty()) {
            return processDataSet;
        }
        DataSet filterResultDataSet = CreditLimitHelper.filterResultDataSet(processDataSet, paramMap);
        filterResultDataSet = filterResultDataSet.updateField("org_name", "mixorgname").orderBy(new String[]{"sortcode"});
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(filterResultDataSet, TOTAL_FIELDS, ORG_NAME);
        DataSet resultSet = filterResultDataSet.union(totalDataSet);
        return resultSet.addField("rowid", "orgid");
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(TOTAL_FIELDS);
    }
}

