/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.credit.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.credit.helper.CreditLimitHelper;

public class CreditTotalDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private String ORG = "org";
    private String ORG_NAME = "org_name";
    private String MIX_ORGNAME = "mixorgname";
    private String ROWID = "rowid";
    private String PID = "pid";
    private String ISGROUPNODE = "isgroupnode";
    private String LEVEL = "level";
    private List<String> COUNT_FIELDS = Arrays.asList("totalamt", "useamt", "avaramt");

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        return CreditLimitHelper.query(this.transQueryParam(reportQueryParam));
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet groupByOrgSet = ds.groupBy(new String[]{this.ORG}).sum("totalamt").sum("useamt").finish();
        DataSet leftJoinDataSet = orgDateSet.leftJoin(groupByOrgSet).on(this.ORG, this.ORG).select(new String[]{this.ORG, this.ROWID, this.PID, this.ISGROUPNODE, this.LEVEL, "orgname org_name", "sortcode", this.MIX_ORGNAME, "totalamt", "useamt"}).finish();
        leftJoinDataSet = leftJoinDataSet.addField("0", "sumlevel");
        DataSet sumResultSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDataSet, Arrays.asList("totalamt", "useamt"), this.ORG + "," + this.ORG_NAME + "," + this.MIX_ORGNAME + ",sortcode");
        sumResultSet = DecisionAnlsHelper.updateValueWhenNull(sumResultSet, Arrays.asList("totalamt", "useamt"));
        sumResultSet = sumResultSet.addField("totalamt-useamt", "avaramt");
        DataSet filterDataSet = sumResultSet = DecisionAnlsHelper.removeNoDataTreeDs(sumResultSet, Arrays.asList("totalamt", "useamt", "avaramt"), false);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            filterDataSet = filterDataSet.where("org in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        filterDataSet = filterDataSet.updateField("org_name", "mixorgname").orderBy(new String[]{"sortcode"});
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(filterDataSet, this.COUNT_FIELDS, this.ORG_NAME);
        DataSet resultSet = filterDataSet.union(totalDataSet);
        return resultSet.addField("rowid", "orgid");
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.COUNT_FIELDS);
    }
}

