/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.credit.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.credit.helper.CreditLimitHelper;

public class CreditTotalDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected String CLICK = "click";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{"totalamt", ResManager.loadKDString((String)"\u603b\u6388\u4fe1\u989d\u5ea6", (String)"CreditTotalDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"useamt", ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditTotalDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"avaramt", ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditTotalDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{this.CLICK, ResManager.loadKDString((String)"\u70b9\u51fb\u7a7f\u900f\u5b57\u6bb5", (String)"FundFlowTrendDataPulgin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"type", ResManager.loadKDString((String)"\u989d\u5ea6\u7c7b\u578b", (String)"CreditTotalDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"typename", ResManager.loadKDString((String)"\u989d\u5ea6\u7c7b\u578b\u540d\u79f0", (String)"CreditTotalDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"usecolumn", ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6\u5217", (String)"CreditTotalDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"avaramtcolumn", ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6\u5217", (String)"CreditTotalDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet creditDataSet = CreditLimitHelper.query(paramMap);
        creditDataSet = creditDataSet.select(new String[]{"totalamt", "useamt", "totalamt-useamt as avaramt"});
        DataSet resultSet = creditDataSet.groupBy().sum("totalamt").sum("useamt").sum("avaramt").finish();
        resultSet = this.handleDataSet(resultSet);
        resultSet = DecisionAnlsHelper.creatAbsentRow(resultSet, "type", Arrays.asList("0", "1"), 3, () -> new Object[]{0.0, 0.0, 0.0, ""});
        String typeName = String.format("case when type=0 then '%1$s' when type=1 then '%2$s' else ' ' end", ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditTotalDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditTotalDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
        return resultSet.addFields(new String[]{"'click'", typeName, DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditTotalDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditTotalDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{this.CLICK, "typename", "usecolumn", "avaramtcolumn"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet handleDataSet(DataSet ds) {
        if (DecisionAnlsHelper.checkEmptyAndClose(ds.copy())) {
            return ds.addField("0", "type");
        }
        try {
            Row row = (Row)ds.iterator().next();
            String useamt = row.getString("useamt");
            String avaramt = row.getString("avaramt");
            ds = ds.addField("0", "type");
            RowMeta rowMeta = ds.getRowMeta();
            DataSet useDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{useamt, useamt, 0.0, 1}));
            DataSet avaDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{avaramt, 0.0, avaramt, 0}));
            DataSet dataSet = useDs.union(avaDs);
            return dataSet;
        }
        finally {
            ds.close();
        }
    }

    @Override
    protected List<String> getLinkReport() {
        ArrayList<String> objects = new ArrayList<String>();
        objects.add("tda_totalcreditrpt");
        return objects;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return this.CLICK;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_totalcreditrpt");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6388\u4fe1\u603b\u989d\u5206\u6790\u8868", (String)"CreditTotalDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Arrays.asList("totalamt", "useamt", "avaramt").stream().collect(Collectors.toSet());
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(4, 4);
        }
        return value;
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.setFormId("tda_totalcreditrpt");
        param.setCaption(ResManager.loadKDString((String)"\u6388\u4fe1\u603b\u989d\u5206\u6790\u8868", (String)"CreditTotalDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
    }
}

