/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.creditlimit.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.CreditDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CreditLimitTopBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String DISPLAY_TYPE = "displayType";
    private static final String ORG = "org";
    private static final String BANKCATE = "bankcate";
    private static final String PREFIX = "bankcate_";
    private static final String FINCOMP_ID = "2";
    private static final String OHTERBANK_ID = "1";
    private static final String STAT = "stat";
    private static final String ROWID = "rowid";
    private static final String TOTALAMT = "totalamt";
    private static final String USEAMT = "useamt";
    private static final String BALANCE = "balance";
    private static List<String> amountFieldName = Arrays.asList("totalamt", "useamt", "balance");

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allCreditLimitDateSet = CreditDataHelper.getAllCreditLimit((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (List)((List)paramMap.get("allorgids")), (Date)queryDate, (Long)baseCurrency).filter(DecisionAnlsHelper.getCreditFilter().toString());
        return allCreditLimitDateSet.addField("totalamt - useamt", BALANCE);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        DataSet unionSet;
        Map paramMap = this.transQueryParam(queryParam);
        ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)paramMap, amountFieldName.stream().collect(Collectors.toSet()));
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
        DataSet bankCreditLimitSet = DecisionAnlsHelper.getAcctByType(ds.copy(), displayByBankTypeEnum);
        Pair<DataSet, DataSet> splitDataSet = DecisionAnlsHelper.splitCreditLimitTopBank(bankCreditLimitSet);
        DataSet topBankCreditLimitSet = (DataSet)splitDataSet.getValue0();
        if (splitDataSet.getValue1() != null) {
            DataSet nonTopBankCreditLimitSet = ((DataSet)splitDataSet.getValue1()).updateField(BANKCATE, OHTERBANK_ID);
            unionSet = topBankCreditLimitSet.union(nonTopBankCreditLimitSet);
        } else {
            unionSet = topBankCreditLimitSet;
        }
        if (displayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC) {
            DataSet finCompCreditLimitSet = DecisionAnlsHelper.getfinCompCreditLimit(ds.copy()).updateField(BANKCATE, FINCOMP_ID);
            unionSet = unionSet.union(finCompCreditLimitSet);
        }
        DataSet groupSet = unionSet.select(new String[]{ORG, BANKCATE, TOTALAMT, USEAMT, BALANCE}).groupBy(new String[]{ORG, BANKCATE}).sum(TOTALAMT).sum(USEAMT).sum(BALANCE).finish();
        DataSet result = DecisionAnlsHelper.ChangeMultRowToColDataSet(groupSet, BANKCATE, ORG, PREFIX, amountFieldName);
        Long orgview = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgview);
        List<String> sumField = CreditLimitTopBankDataListPlugin.getSumField(result);
        List<String> selectField = CreditLimitTopBankDataListPlugin.getSelectField(sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(result).on(ROWID, ORG).select(selectField.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "orgname,mixorgname,sortcode");
        List secondOrgIds = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)secondOrgIds)) {
            secondOrgIds = (List)paramMap.get("allorgids");
        }
        if (!EmptyUtil.isEmpty((Collection)secondOrgIds)) {
            sumDataSet = sumDataSet.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", secondOrgIds));
        }
        sumDataSet = sumDataSet.addField(String.join((CharSequence)"+", sumField.stream().filter(f -> f.endsWith(TOTALAMT)).collect(Collectors.toSet())), STAT).addField("'groupcol'", "groupcol");
        sumDataSet = sumDataSet.filter("stat > 0").orderBy(new String[]{"sortcode"});
        sumField.add(STAT);
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumField, "orgname").updateField("orgname", ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CreditLimitTopBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        return sumDataSet.union(totalSet);
    }

    private static List<String> getSumField(DataSet result) {
        ArrayList<String> sumField = new ArrayList<String>(25);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("orgname");
        selectField.add("mixorgname");
        selectField.add(ROWID);
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }

    private Map<String, String> getTopNineTeenBankType(AcctDisplayByBankTypeEnum displayByBankTypeEnum, DataSet allCreditLimitSet) {
        DataSet bankCreditLimitSet = DecisionAnlsHelper.getAcctByType(allCreditLimitSet, displayByBankTypeEnum);
        Map<String, String> topBank = DecisionAnlsHelper.getTopCreditLimitBankCate(bankCreditLimitSet.copy());
        topBank.put(OHTERBANK_ID, ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"CreditLimitTopBankDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
        if (displayByBankTypeEnum == AcctDisplayByBankTypeEnum.ALL || displayByBankTypeEnum == AcctDisplayByBankTypeEnum.DOMESTIC) {
            topBank.put(FINCOMP_ID, ResManager.loadKDString((String)"\u8d22\u52a1\u516c\u53f8", (String)"CreditLimitTopBankDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]));
        }
        return topBank;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map paramMap = this.transQueryParam(this.getQueryParam());
        String displayType = (String)paramMap.get(DISPLAY_TYPE);
        AcctDisplayByBankTypeEnum displayByBankTypeEnum = AcctDisplayByBankTypeEnum.getEnumByValue((String)displayType);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allCreditLimitSet = CreditDataHelper.getAllCreditLimit((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, (List)((List)paramMap.get("allorgids")), (Date)queryDate, (Long)baseCurrency).filter(DecisionAnlsHelper.getCreditFilter().toString());
        Map<String, String> topBank = this.getTopNineTeenBankType(displayByBankTypeEnum, allCreditLimitSet);
        for (Map.Entry<String, String> topBankEntry : topBank.entrySet()) {
            ReportColumnGroup newColGroup = new ReportColumnGroup();
            newColGroup.setFieldKey(PREFIX + topBankEntry.getKey());
            newColGroup.setCaption(new LocaleString(topBankEntry.getValue()));
            for (String amountField : amountFieldName) {
                String caption = "";
                switch (amountField) {
                    case "totalamt": {
                        caption = ResManager.loadKDString((String)"\u6388\u4fe1\u603b\u989d\u5ea6", (String)"CreditLimitTopBankDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
                        break;
                    }
                    case "useamt": {
                        caption = ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditLimitTopBankDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
                        break;
                    }
                    case "balance": {
                        caption = ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditLimitTopBankDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
                        break;
                    }
                }
                ReportColumn newCol = new ReportColumn();
                newCol.setFieldKey(PREFIX + topBankEntry.getKey() + amountField);
                newCol.setFieldType("decimal");
                newCol.setScale(2);
                newCol.setZeroShow(true);
                newCol.setCaption(new LocaleString(caption));
                newColGroup.getChildren().add(newCol);
            }
            columns.add((AbstractReportColumn)newColGroup);
        }
        ReportColumn newCol = new ReportColumn();
        newCol.setFieldKey(STAT);
        newCol.setFieldType("decimal");
        newCol.setScale(2);
        newCol.setZeroShow(true);
        newCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CreditLimitTopBankDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)newCol);
        return columns;
    }
}

