/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.creditlimit.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.CreditDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CreditLimitTopBankQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ISDOMESTIC = "isdomestic";
    private static final String BANKNAME = "bankname";
    private static final String TOTALAMT = "totalamt";
    private static final String USEAMT = "useamt";
    private static final String BALANCE = "balance";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{BANKNAME, ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"CreditLimitTopBankQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{ISDOMESTIC, ResManager.loadKDString((String)"\u5883\u5185\u5916", (String)"CreditLimitTopBankQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{TOTALAMT, ResManager.loadKDString((String)"\u6388\u4fe1\u603b\u989d\u5ea6", (String)"CreditLimitTopBankQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{USEAMT, ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditLimitTopBankQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{BALANCE, ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditLimitTopBankQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f\u5217", (String)"CreditLimitTopBankQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    @Override
    protected List<String> getLinkReport() {
        return Arrays.asList("tda_creditlmtdomeqingrpt", "tda_creditlmtoverqingrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return BANKNAME;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        AcctDisplayByBankTypeEnum type = "tda_creditlmtdomeqingrpt".equals(formId) ? AcctDisplayByBankTypeEnum.DOMESTIC : AcctDisplayByBankTypeEnum.OVERSEAS;
        String caption = "tda_creditlmtdomeqingrpt".equals(formId) ? ResManager.loadKDString((String)"\u5883\u5185\u94f6\u884c\u6388\u4fe1\u5206\u5e03\u8868", (String)"CreditLimitTopBankQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5883\u5916\u94f6\u884c\u6388\u4fe1\u5206\u5e03\u8868", (String)"CreditLimitTopBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.getCustomParams().put("displayType", type.getValue());
        param.setFormId("tda_creditlimitrpt");
        param.setCaption(caption);
        this.fireLinkageShowForm(view, param);
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet overseasUnionSet;
        DataSet domesticUnionSet;
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allCreditLimitSet = CreditDataHelper.getAllCreditLimit((String)((Object)((Object)this)).getClass().getName(), (Long)orgViewId, this.getOrgIds(paramMap), (Date)queryDate, (Long)baseCurrency).filter(DecisionAnlsHelper.getCreditFilter().toString());
        DataSet finCompCreditLimitSet = DecisionAnlsHelper.getfinCompCreditLimit(allCreditLimitSet.copy()).updateField(ISDOMESTIC, "'1'").updateField(BANKNAME, ResManager.loadKDString((String)"'\u8d22\u52a1\u516c\u53f8'", (String)"CreditLimitTopBankQingAnlsPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]));
        DataSet bankDomesticCreditLimitSet = DecisionAnlsHelper.getAcctByType(allCreditLimitSet.copy(), AcctDisplayByBankTypeEnum.DOMESTIC);
        Pair<DataSet, DataSet> splitDomesticDataSet = DecisionAnlsHelper.splitCreditLimitTopBank(bankDomesticCreditLimitSet);
        DataSet topDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue0()).select(new String[]{BANKNAME, ISDOMESTIC, TOTALAMT, USEAMT}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(TOTALAMT).sum(USEAMT).finish().orderBy(new String[]{"totalamt desc"});
        if (splitDomesticDataSet.getValue1() != null) {
            DataSet nonTopDomesticBankAcctSet = ((DataSet)splitDomesticDataSet.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"CreditLimitTopBankQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0])).select(new String[]{BANKNAME, ISDOMESTIC, TOTALAMT, USEAMT}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(TOTALAMT).sum(USEAMT).finish();
            domesticUnionSet = topDomesticBankAcctSet.union(nonTopDomesticBankAcctSet);
        } else {
            domesticUnionSet = topDomesticBankAcctSet;
        }
        finCompCreditLimitSet = finCompCreditLimitSet.select(new String[]{BANKNAME, ISDOMESTIC, TOTALAMT, USEAMT}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(TOTALAMT).sum(USEAMT).finish();
        DataSet bankOverseasAcctSet = DecisionAnlsHelper.getAcctByType(allCreditLimitSet, AcctDisplayByBankTypeEnum.OVERSEAS);
        Pair<DataSet, DataSet> splitOverseasDataSet = DecisionAnlsHelper.splitTopBank(bankOverseasAcctSet, 15);
        DataSet topBankOverseasAcctSet = ((DataSet)splitOverseasDataSet.getValue0()).select(new String[]{BANKNAME, ISDOMESTIC, TOTALAMT, USEAMT}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(TOTALAMT).sum(USEAMT).finish().orderBy(new String[]{"totalamt desc"});
        if (splitOverseasDataSet.getValue1() != null) {
            DataSet nonTopOverseasBankAcctSet = ((DataSet)splitOverseasDataSet.getValue1()).updateField(BANKNAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"CreditLimitTopBankQingAnlsPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0])).select(new String[]{BANKNAME, ISDOMESTIC, TOTALAMT, USEAMT}).groupBy(new String[]{BANKNAME, ISDOMESTIC}).sum(TOTALAMT).sum(USEAMT).finish();
            overseasUnionSet = topBankOverseasAcctSet.union(nonTopOverseasBankAcctSet);
        } else {
            overseasUnionSet = topBankOverseasAcctSet;
        }
        return domesticUnionSet.union(finCompCreditLimitSet).union(overseasUnionSet).addField("totalamt - useamt", BALANCE);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(3);
        fields.add(TOTALAMT);
        fields.add(USEAMT);
        fields.add(BALANCE);
        return fields;
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        JSONArray data = (JSONArray)clickArgs.get((Object)"data");
        AcctDisplayByBankTypeEnum type = AcctDisplayByBankTypeEnum.DOMESTIC;
        if (data != null && data.size() > 1 && "0".equals(data.get(1))) {
            type = AcctDisplayByBankTypeEnum.OVERSEAS;
        }
        String caption = type == AcctDisplayByBankTypeEnum.DOMESTIC ? ResManager.loadKDString((String)"\u5883\u5185\u94f6\u884c\u6388\u4fe1\u5206\u5e03\u8868", (String)"CreditLimitTopBankQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5883\u5916\u94f6\u884c\u6388\u4fe1\u5206\u5e03\u8868", (String)"CreditLimitTopBankQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
        param.getCustomParams().put("displayType", type.getValue());
        param.setFormId("tda_creditlimitrpt");
        param.setCaption(caption);
    }
}

