/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractFinDebtDistDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    protected static final String ORG = "org";
    protected static final String ORGNAME = "orgname";
    protected static final String LIST_CURRENCY = "listcurrency";
    protected static final String REPAY_AMOUNT = "repayamount";
    protected static final String SOURCE_TYPE = "sourcetype";
    protected static final String FINANCE_TYPE = "financetype";
    protected static final String BANK_DEBT = "bankdebt";
    protected static final String BOND_DEBT = "bonddebt";
    protected static final String ENTER_DEBT = "enterdebt";
    protected static final String OTHER_DEBT = "otherdebt";
    private static final String FOREIGN_ENTER_DEBT = "foreignenterdebt";
    private static final String FOREIGN_OTHER_DEBT = "foreignotherdebt";
    protected static final String FINORG_DEBT = "finorgdebt";
    protected static final String SETTLE_DEBT = "settledebt";
    protected static final String LEASE_DEBT = "leasedebt";
    protected static final String TOTAL_DEBT = "totaldebt";
    protected static final String TOTAL_EQUITY = "totalequity";
    protected static final String TOTAL_DEBT_WITH_EQUITY = "totaldebtwithequity";
    protected static final String ROW_OFFSET_DEBT = "rowoffset";
    protected static final String COL_OFFSET_DEBT = "coloffset";
    public static final String CREDITORTYPE = "creditortype";
    protected static final String FINORG_OFFSET = "coloffsetfinorg";
    protected static final String SETTLE_OFFSET = "coloffsetsettle";
    protected static final String LEASE_OFFSET = "coloffsetlease";
    protected static final String ENTER_OFFSET = "coloffsetenter";
    protected static final String OTHER_OFFSET = "coloffsetother";
    protected static final String FOREIGN_ENTER_OFFSET = "coloffsetforeignenter";
    protected static final String FOREIGN_OTHER_OFFSET = "coloffsetforeignother";
    protected static final String CNY_OFFSET = "coloffsetcny";
    protected static final String HKD_OFFSET = "coloffsethkd";
    protected static final String USD_OFFSET = "coloffsetusd";
    protected static final String ISOUTGROUP = "isoutgroup";
    protected static final List<String> ORG_SELECTFIELD = Arrays.asList("org", "rowid", "mixorgname", "pid", "isgroupnode", "level", "0  as sumlevel", "sortcode");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get(ORG)).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        List orgIdSet = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allDs = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIdSet, (Date)queryDate, (Long)currencyId, (Long)orgViewId, (Long)orgId).select(new String[]{ORG, FINANCE_TYPE, SOURCE_TYPE, REPAY_AMOUNT, ROW_OFFSET_DEBT, COL_OFFSET_DEBT, "isequity", "region", "currency", ISOUTGROUP, CREDITORTYPE, "startintdate", "creditor"});
        return this.getFinanceQueryDataset(allDs, paramMap);
    }

    protected DataSet offsetMerge(DataSet bizSet, List<String> mergeFields, List<String> sumFields) {
        Field[] fields;
        DataSet dsTemp = bizSet.copy();
        GroupbyDataSet merTemp = dsTemp.filter("sumlevel = 0").groupBy(new String[]{LIST_CURRENCY});
        for (String mergeField : mergeFields) {
            merTemp.sum(mergeField);
        }
        DataSet mergeSet = merTemp.finish();
        Iterator rowIterator = mergeSet.copy().iterator();
        HashMap<String, BigDecimal> mergeFieldMap = new HashMap<String, BigDecimal>(8);
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            for (String mergeField : mergeFields) {
                mergeFieldMap.put(mergeField, EmptyUtil.isNoEmpty((BigDecimal)row.getBigDecimal(mergeField)) ? row.getBigDecimal(mergeField) : BigDecimal.ZERO);
            }
        }
        LinkedList<String> selectFields = new LinkedList<String>();
        for (Field field : fields = bizSet.getRowMeta().getFields()) {
            if ("mixorgname".equals(field.getName())) {
                selectFields.add(AbstractFinDebtDistDataListPlugin.getLoadKDString() + " as " + ORGNAME);
                continue;
            }
            if ("sumlevel".equals(field.getName())) {
                selectFields.add("0 as sumlevel");
                continue;
            }
            if (LIST_CURRENCY.equals(field.getName())) {
                selectFields.add(field.getName());
                continue;
            }
            if (sumFields.contains(field.getName())) {
                this.setMergeFieldValue(mergeFieldMap, selectFields, field.getName());
                continue;
            }
            selectFields.add("NULL as " + field.getName());
        }
        return mergeSet.select(String.join((CharSequence)",", selectFields));
    }

    private static String getLoadKDString() {
        return ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"AbstractFinDebtDistDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    protected abstract DataSet getFinanceQueryDataset(DataSet var1, Map<String, Object> var2);

    private void setMergeFieldValue(Map<String, BigDecimal> mergeFieldMap, List<String> selectFields, String fieldName) {
        switch (fieldName) {
            case "finorgdebt": {
                selectFields.add(mergeFieldMap.get(FINORG_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "settledebt": {
                selectFields.add(mergeFieldMap.get(SETTLE_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "leasedebt": {
                selectFields.add(mergeFieldMap.get(LEASE_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "ingroupenterdebt": 
            case "enterdebt": {
                selectFields.add(mergeFieldMap.get(ENTER_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "foreignenterdebt": {
                selectFields.add(mergeFieldMap.get(FOREIGN_ENTER_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "foreignsubtotal": {
                selectFields.add(mergeFieldMap.get(FOREIGN_ENTER_OFFSET).add(mergeFieldMap.get(FOREIGN_OTHER_OFFSET)).toPlainString() + " as " + fieldName);
                break;
            }
            case "ingroupdebtcny": 
            case "totaldebtcny": {
                selectFields.add(mergeFieldMap.get(CNY_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "ingroupdebthkd": 
            case "totaldebthkd": {
                selectFields.add(mergeFieldMap.get(HKD_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "ingroupdebtusd": 
            case "totaldebtusd": {
                selectFields.add(mergeFieldMap.get(USD_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "ingroupdebtother": 
            case "totaldebtother": 
            case "otherdebt": {
                selectFields.add(mergeFieldMap.get(OTHER_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "foreignotherdebt": {
                selectFields.add(mergeFieldMap.get(FOREIGN_OTHER_OFFSET).toPlainString() + " as " + fieldName);
                break;
            }
            case "domesticsubtotal": {
                selectFields.add(mergeFieldMap.get(ENTER_OFFSET).add(mergeFieldMap.get(OTHER_OFFSET)).add(mergeFieldMap.get(FINORG_OFFSET)).toPlainString() + " as " + fieldName);
                break;
            }
            default: {
                selectFields.add(mergeFieldMap.get(COL_OFFSET_DEBT).toPlainString() + " as " + fieldName);
            }
        }
    }
}

