/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.data.FinanceCostByTermDataListPlugin;
import kd.tmc.tda.report.finance.helper.FinanceingCostAnalsDataHelper;

public class FinCostCurrencyPeriodDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(FinanceCostByTermDataListPlugin.class);
    private static final String AVGBALANCE = "avgbalance";
    private static final String AVGBALANCE_SUFFIX = "_avg";
    private static final String INTEREST = "interest";
    private static final String INTEREST_SUFFIX = "_int";
    private static final String CHANGE_FIELD = "changeField";
    private static final String CUSTOMTYPE = "customtype";
    private static final String ORGID = "orgid";
    private static final String CURRENCY_NUMBER = "currencynumber";
    private static final String CURRENCY_PREFIX = "cry_";
    private static final String DATE_TYPE = "datetype";
    private static final String AVG_COST = "999";

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        List allorgids = (List)paramMap.get("allorgids");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List queryDateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet financeCostDataSet = FinanceCostDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)0L, (List)queryDateList);
        String dateRange = (String)reportQueryParam.getCustomParam().get("dateRange");
        dateRange = EmptyUtil.isEmpty((String)dateRange) ? "year" : dateRange;
        financeCostDataSet = financeCostDataSet.filter("customtype = '" + dateRange + "'");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        financeCostDataSet = FinanceCostDataHelper.getFinanceMergeDataSet((DataSet)financeCostDataSet, (DataSet)orgDateSet, (Long)orgId);
        financeCostDataSet = financeCostDataSet.updateFields(new String[]{AVGBALANCE, INTEREST}, new String[]{"avgbalance + rowoffset", "(avgbalance + rowoffset) * intrate / 100"});
        financeCostDataSet = financeCostDataSet.select(new String[]{ORGID, "currency", CURRENCY_NUMBER, DATE_TYPE, "principle", "intrate", INTEREST, "daynum", "dayweight", AVGBALANCE, "begindate", "enddate", CUSTOMTYPE, "coloffset"});
        financeCostDataSet = this.dealCryDataSet(financeCostDataSet);
        return financeCostDataSet;
    }

    private DataSet processDataSet(DataSet orgDateSet, DataSet currencyCostDataSet, List<String> countFields) {
        DataSet tempDataSet = currencyCostDataSet;
        tempDataSet = tempDataSet.addField("concat(datetype, concat('_', concat(currencynumber, concat('_', customtype))))", CHANGE_FIELD);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(AVGBALANCE, "avg");
        map.put(INTEREST, "int");
        tempDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(tempDataSet, CHANGE_FIELD, ORGID, CURRENCY_PREFIX, map);
        tempDataSet = DecisionAnlsHelper.addAbsentFields(tempDataSet, countFields);
        DataSet leftJoinDs = orgDateSet.leftJoin(tempDataSet).on("rowid", ORGID).select(new String[]{ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, countFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, countFields, "orgid,mixorgname,sortcode");
        sumDataSet = this.removeAllZeroRow(sumDataSet, new HashSet<String>(countFields));
        return sumDataSet;
    }

    private DataSet dealCryDataSet(DataSet financeCostDataSet) {
        final RowMeta rowMeta = financeCostDataSet.getRowMeta();
        return financeCostDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String currency = row.getString(FinCostCurrencyPeriodDataListPlugin.CURRENCY_NUMBER);
                int cryIndex = rowMeta.getFieldIndex(FinCostCurrencyPeriodDataListPlugin.CURRENCY_NUMBER, false);
                String cryType = CurrencyTypeEnum.getByNumber((String)currency).getType();
                data[cryIndex] = cryType;
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        long start = System.currentTimeMillis();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta());
        }
        DataSet allDataSet = ds.copy();
        allDataSet = allDataSet.updateFields(new String[]{AVGBALANCE, INTEREST}, new String[]{"avgbalance + coloffset", "(avgbalance + coloffset) * intrate / 100"});
        allDataSet = allDataSet.select(new String[]{ORGID, "currency", CURRENCY_NUMBER, DATE_TYPE, "principle", "intrate", INTEREST, "daynum", "dayweight", AVGBALANCE, "begindate", "enddate", CUSTOMTYPE});
        DataSet cryDataSetAll = allDataSet.copy().groupBy(new String[]{DATE_TYPE, CURRENCY_NUMBER, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish().addField("-1", ORGID);
        DataSet weightedAverageSetAll = allDataSet.groupBy(new String[]{DATE_TYPE, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish().select(new String[]{DATE_TYPE, "'999' as currencynumber", CUSTOMTYPE, AVGBALANCE, INTEREST}).addField("-1", ORGID);
        allDataSet = cryDataSetAll.union(weightedAverageSetAll);
        ds = ds.select(new String[]{ORGID, "currency", CURRENCY_NUMBER, DATE_TYPE, "principle", "intrate", INTEREST, "daynum", "dayweight", AVGBALANCE, "begindate", "enddate", CUSTOMTYPE});
        DataSet cryDataSet = ds.copy().groupBy(new String[]{ORGID, DATE_TYPE, CURRENCY_NUMBER, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish();
        DataSet weightedAverageSet = ds.groupBy(new String[]{ORGID, DATE_TYPE, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish().select(new String[]{ORGID, DATE_TYPE, "'999' as currencynumber", CUSTOMTYPE, AVGBALANCE, INTEREST});
        ds = cryDataSet.union(weightedAverageSet);
        Set<String> currencyTypes = this.getCurrencyTypes(ds);
        queryParam.getCustomParam().put("currencyTypes", currencyTypes);
        List<String> countFields = this.genFieldNames(currencyTypes, "change");
        allDataSet = allDataSet.addField("concat(datetype, concat('_', concat(currencynumber, concat('_', customtype))))", CHANGE_FIELD);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(AVGBALANCE, "avg");
        map.put(INTEREST, "int");
        allDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(allDataSet, CHANGE_FIELD, ORGID, CURRENCY_PREFIX, map);
        allDataSet = DecisionAnlsHelper.addAbsentFields(allDataSet, countFields).addFields(new String[]{"-1L", "-1L", "'0'", "1", "2", "'mixorgname'", "'1'"}, new String[]{"rowid", "pid", "isgroupnode", "level", "sumlevel", "mixorgname", "sortcode"});
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet processDataSet = this.processDataSet(orgDateSet, ds, countFields);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        DataSet filterDataSet = processDataSet;
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            filterDataSet = filterDataSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds));
        }
        filterDataSet = filterDataSet.orderBy(new String[]{"sortcode"});
        String[] fieldNames = filterDataSet.getRowMeta().getFieldNames();
        filterDataSet = filterDataSet.union(allDataSet.select(fieldNames));
        List<String> calcFieldNames = this.genFieldNames(currencyTypes, "calc");
        calcFieldNames.addAll(Arrays.asList(ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode", "sumlevel"));
        DataSet resultDataSet = filterDataSet.select(calcFieldNames.toArray(new String[0]));
        logger.info("\u878d\u8d44\u6210\u672c\u5206\u6790-\u6309\u5e01\u79cd\uff08\u533a\u95f4\uff09" + orgViewId + " \u5904\u7406\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Set currencyTypes;
        ReportQueryParam queryParam = this.getQueryParam();
        Map queryParamMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(queryParamMap);
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = DateRangeEnum.MONTH.getValue();
        }
        if (EmptyUtil.isEmpty((Collection)(currencyTypes = (Set)this.getQueryParam().getCustomParam().get("currencyTypes")))) {
            currencyTypes = Arrays.stream(CurrencyTypeEnum.values()).map(CurrencyTypeEnum::getType).collect(Collectors.toSet());
            currencyTypes.add(AVG_COST);
        }
        List<String> fieldNames = this.genFieldNames(currencyTypes, "target");
        String finalDateRange = dateRange;
        fieldNames = fieldNames.stream().filter(fieldname -> fieldname.endsWith(finalDateRange)).collect(Collectors.toList());
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        int diff = dateRangeEnum.getEnd() - dateRangeEnum.getStart();
        LinkedHashMap<String, ReportColumnGroup> groupMap = new LinkedHashMap<String, ReportColumnGroup>();
        for (String fieldName : fieldNames) {
            String[] fieldNameSplit = fieldName.split("_");
            String dateIndex = fieldNameSplit[1];
            String key = CURRENCY_PREFIX + dateIndex;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)groupMap.get(key);
            if (reportColumnGroup == null) {
                reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setFieldKey(key);
                String caption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff--);
                reportColumnGroup.setCaption(new LocaleString(caption));
                groupMap.put(key, reportColumnGroup);
            }
            String cryType = fieldNameSplit[2];
            CurrencyTypeEnum currencyTypeEnum = CurrencyTypeEnum.getByType((String)cryType);
            String columnCaption = "";
            if (EmptyUtil.isNoEmpty((Object)currencyTypeEnum)) {
                columnCaption = currencyTypeEnum.getName();
            } else if (AVG_COST.equals(cryType)) {
                columnCaption = FinanceingCostAnalsDataHelper.getWeightAvgCostKDString();
            }
            ReportColumn column = this.createColumn(fieldName, columnCaption);
            reportColumnGroup.getChildren().add(column);
        }
        groupMap.forEach((k, v) -> columns.add((AbstractReportColumn)v));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("text");
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    private List<String> genFieldNames(Set<String> currencyTypes, String fieldType) {
        ReportQueryParam queryParam = this.getQueryParam();
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        LinkedList<String> fieldNames = new LinkedList<String>();
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        for (int i = dateRangeEnum.getStart().intValue(); i <= dateRangeEnum.getEnd(); ++i) {
            for (String currencyType : currencyTypes) {
                this.getFields(fieldNames, i, currencyType, dateRangeEnum.getValue(), fieldType);
            }
        }
        return fieldNames;
    }

    private void getFields(List<String> fieldNames, int count, String currencyType, String dateRangeEnumValue, String fieldType) {
        switch (fieldType) {
            case "target": {
                fieldNames.add(CURRENCY_PREFIX + count + "_" + currencyType + "_" + dateRangeEnumValue);
                break;
            }
            case "change": {
                fieldNames.add(CURRENCY_PREFIX + count + "_" + currencyType + "_" + dateRangeEnumValue + AVGBALANCE_SUFFIX);
                fieldNames.add(CURRENCY_PREFIX + count + "_" + currencyType + "_" + dateRangeEnumValue + INTEREST_SUFFIX);
                break;
            }
            case "calc": {
                String temp = CURRENCY_PREFIX + count + "_" + currencyType + "_" + dateRangeEnumValue;
                String _int = temp + INTEREST_SUFFIX;
                String _avg = temp + AVGBALANCE_SUFFIX;
                String calcStr = "case when " + _avg + " = 0.0  or " + _avg + " is null then 0 else " + _int + " *1.0 / " + _avg + " end as " + temp;
                fieldNames.add(calcStr);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getCurrencyTypes(DataSet ds) {
        TreeSet<String> currencyTypes = new TreeSet<String>();
        try (DataSet copy = null;){
            copy = ds.copy().groupBy(new String[]{CURRENCY_NUMBER}).finish();
            for (Row row : copy) {
                String cryNum = row.getString(CURRENCY_NUMBER);
                currencyTypes.add(cryNum);
            }
            TreeSet<String> treeSet = currencyTypes;
            return treeSet;
        }
    }
}

