/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.sdk.tmc.tda.extpoint.finance.IFinanceSourceReBuildInterface;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.data.AbstractFinDebtDistDataListPlugin;

public class FinDebtByRegionDataListPlugin
extends AbstractFinDebtDistDataListPlugin {
    private static final String FOREIGN_BANK_DEBT = "foreignbankdebt";
    private static final String FOREIGN_BOND_DEBT = "foreignbonddebt";
    private static final String FOREIGN_ENTER_DEBT = "foreignenterdebt";
    private static final String FOREIGN_OTHER_DEBT = "foreignotherdebt";
    private static final String DOMESTIC_SUBTOTAL = "domesticsubtotal";
    private static final String FOREIGN_SUBTOTAL = "foreignsubtotal";
    private static final List<String> DOMESTIC_SUM_FIELD = Arrays.asList("bankdebt", "bonddebt", "finorgdebt", "enterdebt", "otherdebt");
    private static final List<String> FOREIGN_SUM_FIELD = Arrays.asList("foreignbankdebt", "foreignbonddebt", "foreignenterdebt", "foreignotherdebt");
    private static final List<String> SUM_FIELD = Arrays.asList("bankdebt", "bonddebt", "finorgdebt", "enterdebt", "otherdebt", "foreignbankdebt", "foreignbonddebt", "foreignenterdebt", "foreignotherdebt", "totalequity", "coloffsetfinorg", "coloffsetenter", "coloffsetother", "coloffsetforeignother", "coloffsetforeignenter", "coloffset");
    private static final List<String> MERGE_FIELD = Arrays.asList("finorgdebt", "enterdebt", "otherdebt", "domesticsubtotal", "foreignenterdebt", "foreignotherdebt", "foreignsubtotal", "totaldebt", "totaldebtwithequity");
    private static final List<String> SOURCE_MERGE_FIELD = Arrays.asList("coloffsetfinorg", "coloffsetenter", "coloffsetother", "coloffsetforeignenter", "coloffsetforeignother", "coloffset");
    private static final List<String> TOTAL_SUM_FIELD = Arrays.asList("bankdebt", "bonddebt", "finorgdebt", "enterdebt", "foreignbankdebt", "foreignbonddebt", "foreignenterdebt", "foreignotherdebt", "otherdebt", "domesticsubtotal", "foreignsubtotal", "totaldebt", "totalequity", "totaldebtwithequity");

    @Override
    protected DataSet getFinanceQueryDataset(DataSet allDs, Map<String, Object> paramMap) {
        DataSet dataUnion = allDs.copy().select(new String[]{"org", "coloffset"}).groupBy(new String[]{"org"}).sum("coloffset").finish();
        DataSet[] splitEquityDataSet = allDs.splitByFilter(new String[]{"isequity = false"}, true);
        DataSet[] splitRegionDataSet = splitEquityDataSet[0].splitByFilter(new String[]{"region = 1"}, true);
        DataSet domesticSet = splitRegionDataSet[0];
        DataSet domesticResSet = domesticSet.copy().select("org").groupBy(new String[]{"org"}).finish();
        String notInFincomStr = " and ((sourcetype <> 1 or creditortype <> 'fincom' or isoutgroup <> 0) and (sourcetype <> 0 or isoutgroup <> 0 or creditortype = 'settlecenter'))";
        DataSet[] splitDomesticSet = domesticSet.splitByFilter(new String[]{"financetype = 0 " + notInFincomStr, "financetype = 1 " + notInFincomStr, "financetype = 2" + notInFincomStr, "financetype = 3" + notInFincomStr, "(sourcetype = 1 and creditortype = 'fincom' and isoutgroup = 0) or (sourcetype = 0 and isoutgroup = 0 and creditortype <> 'settlecenter') "}, false);
        DataSet otherDebtSet = splitDomesticSet[3];
        DataSet finorgdebtSet = splitDomesticSet[4];
        DataSet[] rebuildDataSet = this.rebuildFinAndLeaseDataSet(new DataSet[]{finorgdebtSet, otherDebtSet});
        finorgdebtSet = rebuildDataSet[0];
        otherDebtSet = rebuildDataSet[1];
        DataSet bankDebtSet = splitDomesticSet[0].groupBy(new String[]{"org"}).sum("repayamount", "bankdebt").finish();
        domesticResSet = domesticResSet.leftJoin(bankDebtSet).on("org", "org").select(new String[]{"org", "bankdebt"}).finish();
        DataSet bondDebtSet = splitDomesticSet[1].groupBy(new String[]{"org"}).sum("repayamount", "bonddebt").finish();
        domesticResSet = domesticResSet.leftJoin(bondDebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt"}).finish();
        DataSet enterDebtSet = splitDomesticSet[2].groupBy(new String[]{"org"}).sum("repayamount", "enterdebt").sum("rowoffset").sum("coloffset", "coloffsetenter").finish().updateField("enterdebt", "enterdebt + rowoffset");
        domesticResSet = domesticResSet.leftJoin(enterDebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "coloffsetenter"}).finish();
        otherDebtSet = otherDebtSet.groupBy(new String[]{"org"}).sum("repayamount", "otherdebt").sum("rowoffset").sum("coloffset", "coloffsetother").finish().updateField("otherdebt", "otherdebt + rowoffset");
        domesticResSet = domesticResSet.leftJoin(otherDebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "coloffsetenter", "otherdebt", "coloffsetother"}).finish();
        finorgdebtSet = finorgdebtSet.groupBy(new String[]{"org"}).sum("repayamount", "finorgdebt").sum("rowoffset").sum("coloffset", "coloffsetfinorg").finish().updateField("finorgdebt", "finorgdebt + rowoffset");
        domesticResSet = domesticResSet.leftJoin(finorgdebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "coloffsetenter", "otherdebt", "coloffsetother", "finorgdebt", "coloffsetfinorg"}).finish();
        dataUnion = dataUnion.leftJoin(domesticResSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "finorgdebt", "enterdebt", "otherdebt", "coloffsetfinorg", "coloffsetenter", "coloffsetother", "coloffset"}).finish();
        DataSet foreignSet = splitRegionDataSet[1].select(new String[]{"org", "repayamount", "financetype", "rowoffset", "coloffset"});
        DataSet foreignResSet = foreignSet.copy().select("org").groupBy(new String[]{"org"}).finish();
        DataSet[] splitForeignSet = foreignSet.splitByFilter(new String[]{"financetype = 0", "financetype = 1", "financetype = 2", "financetype = 3"}, false);
        DataSet foreignBankDebtSet = splitForeignSet[0].groupBy(new String[]{"org"}).sum("repayamount", FOREIGN_BANK_DEBT).finish();
        foreignResSet = foreignResSet.leftJoin(foreignBankDebtSet).on("org", "org").select(new String[]{"org", FOREIGN_BANK_DEBT}).finish();
        DataSet foreignBondDebtSet = splitForeignSet[1].groupBy(new String[]{"org"}).sum("repayamount", FOREIGN_BOND_DEBT).finish();
        foreignResSet = foreignResSet.leftJoin(foreignBondDebtSet).on("org", "org").select(new String[]{"org", FOREIGN_BANK_DEBT, FOREIGN_BOND_DEBT}).finish();
        DataSet foreignEnterDebtSet = splitForeignSet[2].groupBy(new String[]{"org"}).sum("repayamount", FOREIGN_ENTER_DEBT).sum("rowoffset").sum("coloffset", "coloffsetforeignenter").finish().updateField(FOREIGN_ENTER_DEBT, "foreignenterdebt + rowoffset");
        foreignResSet = foreignResSet.leftJoin(foreignEnterDebtSet).on("org", "org").select(new String[]{"org", FOREIGN_BANK_DEBT, FOREIGN_BOND_DEBT, FOREIGN_ENTER_DEBT, "coloffsetforeignenter"}).finish();
        DataSet foreignOtherDebtSet = splitForeignSet[3].groupBy(new String[]{"org"}).sum("repayamount", FOREIGN_OTHER_DEBT).sum("rowoffset").sum("coloffset", "coloffsetforeignother").finish().updateField(FOREIGN_OTHER_DEBT, "foreignotherdebt + rowoffset");
        foreignResSet = foreignResSet.leftJoin(foreignOtherDebtSet).on("org", "org").select(new String[]{"org", FOREIGN_BANK_DEBT, FOREIGN_BOND_DEBT, FOREIGN_ENTER_DEBT, "coloffsetforeignenter", FOREIGN_OTHER_DEBT, "coloffsetforeignother"}).finish();
        dataUnion = dataUnion.leftJoin(foreignResSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "finorgdebt", "enterdebt", "otherdebt", FOREIGN_BANK_DEBT, FOREIGN_BOND_DEBT, FOREIGN_ENTER_DEBT, FOREIGN_OTHER_DEBT, "coloffsetforeignother", "coloffsetfinorg", "coloffsetenter", "coloffsetother", "coloffsetforeignenter", "coloffset"}).finish();
        DataSet equitySumSet = splitEquityDataSet[1].groupBy(new String[]{"org"}).sum("repayamount", "totalequity").finish();
        dataUnion = dataUnion.leftJoin(equitySumSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "finorgdebt", "enterdebt", "otherdebt", FOREIGN_BANK_DEBT, FOREIGN_BOND_DEBT, FOREIGN_ENTER_DEBT, FOREIGN_OTHER_DEBT, "totalequity", "coloffsetfinorg", "coloffsetenter", "coloffsetother", "coloffsetforeignother", "coloffsetforeignenter", "coloffset"}).finish();
        return dataUnion;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet financeDataset, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet resultSet = orgDataSet.leftJoin(financeDataset).on("org", "org").select(ORG_SELECTFIELD.toArray(new String[0]), SUM_FIELD.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(resultSet, SUM_FIELD, "mixorgname,sortcode").addFields(new String[]{String.valueOf(currencyId), String.join((CharSequence)"+", DOMESTIC_SUM_FIELD), String.join((CharSequence)"+", FOREIGN_SUM_FIELD)}, new String[]{"listcurrency", DOMESTIC_SUBTOTAL, FOREIGN_SUBTOTAL}).addFields(new String[]{String.join((CharSequence)"+", DOMESTIC_SUM_FIELD) + "+" + String.join((CharSequence)"+", FOREIGN_SUM_FIELD), String.join((CharSequence)"+", DOMESTIC_SUM_FIELD) + "+" + String.join((CharSequence)"+", FOREIGN_SUM_FIELD) + "+" + "totalequity"}, new String[]{"totaldebt", "totaldebtwithequity"});
        sumDataSet = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("suborgids"))) : sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("allorgids")));
        DataSet mergeSet = this.offsetMerge(sumDataSet, SOURCE_MERGE_FIELD, MERGE_FIELD);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(mergeSet);
        DataSet totalSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, TOTAL_SUM_FIELD, Collections.singletonList("listcurrency"), "mixorgname");
        return sumDataSet.union(totalSet).addFields(new String[]{"mixorgname", "rowid"}, new String[]{"orgname", "orgid"});
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(TOTAL_SUM_FIELD);
    }

    private DataSet[] rebuildFinAndLeaseDataSet(DataSet[] dataSets) {
        PluginProxy pluginProxy = PluginProxy.create(IFinanceSourceReBuildInterface.class, (String)"kd.sdk.tmc.tda.extpoint.finance.IFinanceSourceReBuildInterface");
        List result = pluginProxy.callReplace(p -> p.rebuildDataSet(dataSets));
        if (EmptyUtil.isNoEmpty((Object)result) && EmptyUtil.isNoEmpty((Object[])((Object[])result.get(0)))) {
            return (DataSet[])result.get(0);
        }
        return dataSets;
    }
}

