/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinDebtTrendDataHelper;

public class FinDebtTrendDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ORGID = "orgid";
    private static final String ROWID = "rowid";
    private static final String GROUP_COL = "groupcol";
    private static final String REPAYAMOUNT = "repayamount";
    private static final String DATE_TYPE = "datetype";
    private List<String> sumFields;
    private List<String> mergeFields;

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List orgIdSet = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet dateDataSet = FinDebtTrendDataHelper.getDateDataSet("tda_findebttrendrpt", queryDate);
        DataSet financeDataset = null;
        while (dateDataSet.hasNext()) {
            Row row = dateDataSet.next();
            Date date = row.getDate("dateTime");
            String dateStr = row.getString("dateStr");
            DataSet trendDateDataset = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIdSet, (Date)date, (Long)currencyId, (Long)orgViewId, (Long)orgId).filter("isequity = false").select("org orgid, repayamount, rowoffset, coloffset").updateField(REPAYAMOUNT, String.join((CharSequence)"+", REPAYAMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME));
            trendDateDataset = trendDateDataset.addField(dateStr, DATE_TYPE);
            trendDateDataset = trendDateDataset.groupBy(new String[]{ORGID, DATE_TYPE}).sum(REPAYAMOUNT).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
            if (financeDataset != null) {
                financeDataset = financeDataset.union(trendDateDataset);
                continue;
            }
            financeDataset = trendDateDataset;
        }
        if (financeDataset == null) {
            return null;
        }
        return this.convertTrendField(financeDataset);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<String> sumField = this.getSumField(dataSet);
        sumField.addAll(this.mergeFields);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet orgJoinSet = orgDateSet.leftJoin(dataSet).on(ROWID, ORGID).select(DecisionAnlsHelper.getSelectField(sumField)).finish();
        dataSet = this.getSumDataSetByLevel(orgJoinSet, sumField, "sortcode, orgid, mixorgname");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        dataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? dataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("total_repayamount > 0") : dataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("total_repayamount > 0");
        dataSet = dataSet.orderBy(new String[]{"sortcode"}).addField("'groupcol'", GROUP_COL).removeFields(new String[]{"total_repayamount"});
        this.sumFields.remove("total_repayamount");
        if (dataSet.copy().isEmpty()) {
            queryParam.getCustomParam().put("isEmpty", true);
            return dataSet;
        }
        queryParam.getCustomParam().put("isEmpty", false);
        DataSet mergeSet = this.offsetMerge(dataSet, this.mergeFields, this.sumFields);
        dataSet = dataSet.union(mergeSet);
        DataSet totalSet = this.addSubTotalDataSet(dataSet, Collections.singletonList(GROUP_COL), this.sumFields, "mixorgname");
        return dataSet.union(totalSet);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (this.sumFields == null || this.sumFields.isEmpty()) {
            return columns;
        }
        this.sumFields.removeAll(this.mergeFields);
        this.sumFields.sort((s1, s2) -> {
            s1 = s1.split("_")[0];
            s2 = s2.split("_")[0];
            return Integer.parseInt(s1) - Integer.parseInt(s2);
        });
        for (String sumField : this.sumFields) {
            String[] splits = sumField.split("_");
            String typeName = splits[0];
            ReportColumn newCol = new ReportColumn();
            newCol.setHideSingleColumnRow(false);
            newCol.setFieldKey(sumField);
            newCol.setFieldType("decimal");
            newCol.setScale(2);
            newCol.setZeroShow(true);
            newCol.setCaption(new LocaleString(typeName));
            ColumnStyle style = new ColumnStyle();
            style.setTextAlign("right");
            newCol.setStyle(style);
            columns.add((AbstractReportColumn)newCol);
        }
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(16);
        if (EmptyUtil.isNoEmpty(this.sumFields)) {
            fields.addAll(this.sumFields);
        }
        return fields;
    }

    private DataSet convertTrendField(DataSet dataSet) {
        DataSet[] groupSets;
        DataSet baseSet = dataSet.copy().groupBy(new String[]{ORGID}).sum(REPAYAMOUNT, "total_repayamount").finish();
        for (DataSet groupSet : groupSets = dataSet.splitByGroup(new String[]{DATE_TYPE})) {
            Row row = groupSet.copy().next();
            String dateStr = row.getString(DATE_TYPE);
            groupSet = groupSet.groupBy(new String[]{ORGID}).sum(REPAYAMOUNT, dateStr + "_" + REPAYAMOUNT).sum(MergeOffsetHandler.COL_OFFSETFILENAME, dateStr + "_" + MergeOffsetHandler.COL_OFFSETFILENAME).finish();
            baseSet = baseSet.leftJoin(groupSet).on(ORGID, ORGID).select(baseSet.getRowMeta().getFieldNames(), new String[]{dateStr + "_" + REPAYAMOUNT, dateStr + "_" + MergeOffsetHandler.COL_OFFSETFILENAME}).finish();
        }
        return baseSet;
    }

    protected DataSet offsetMerge(DataSet bizSet, List<String> mergeFields, List<String> sumFields) {
        String[] fieldNames;
        GroupbyDataSet merTemp = bizSet.copy().filter("sumlevel = 0").groupBy(new String[]{GROUP_COL});
        for (String mergeField : mergeFields) {
            merTemp.sum(mergeField);
        }
        DataSet mergeSet = merTemp.finish();
        Iterator rowIterator = mergeSet.copy().iterator();
        HashMap<String, BigDecimal> mergeFieldMap = new HashMap<String, BigDecimal>(16);
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            for (String mergeField : mergeFields) {
                mergeFieldMap.put(mergeField, EmptyUtil.isNoEmpty((BigDecimal)row.getBigDecimal(mergeField)) ? row.getBigDecimal(mergeField) : BigDecimal.ZERO);
            }
        }
        LinkedList<String> selectFields = new LinkedList<String>();
        for (String fieldName : fieldNames = bizSet.getRowMeta().getFieldNames()) {
            if ("mixorgname".equals(fieldName)) {
                selectFields.add(FinDebtTrendDataListPlugin.getLoadKDString() + " as " + "orgname");
                continue;
            }
            if ("sumlevel".equals(fieldName)) {
                selectFields.add("0 as sumlevel");
                continue;
            }
            if (GROUP_COL.equals(fieldName)) {
                selectFields.add(fieldName);
                continue;
            }
            if (sumFields.contains(fieldName)) {
                if (!mergeFieldMap.isEmpty()) {
                    String mergeFieldName = fieldName.split("_")[0] + "_" + MergeOffsetHandler.COL_OFFSETFILENAME;
                    selectFields.add(((BigDecimal)mergeFieldMap.get(mergeFieldName)).toPlainString() + " as " + fieldName);
                    continue;
                }
                selectFields.add("NULL as " + fieldName);
                continue;
            }
            selectFields.add("NULL as " + fieldName);
        }
        return mergeSet.select(String.join((CharSequence)",", selectFields));
    }

    private List<String> getSumField(DataSet ds) {
        if (this.sumFields != null && !this.sumFields.isEmpty()) {
            return this.sumFields;
        }
        this.sumFields = new ArrayList<String>(16);
        this.mergeFields = new ArrayList<String>(16);
        for (String fieldName : ds.getRowMeta().getFieldNames()) {
            if (fieldName.endsWith(REPAYAMOUNT)) {
                this.sumFields.add(fieldName);
                continue;
            }
            if (!fieldName.endsWith(MergeOffsetHandler.COL_OFFSETFILENAME)) continue;
            this.mergeFields.add(fieldName);
        }
        return this.sumFields;
    }

    private static String getLoadKDString() {
        return ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"AbstractFinDebtDistDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
    }
}

