/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.enums.FinanceCostTermEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceCostByTermDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(FinanceCostByTermDataListPlugin.class);
    private static final String AVGBALANCE = "avgbalance";
    private static final String AVGBALANCE_SUFFIX = "_avg";
    private static final String INTEREST = "interest";
    private static final String INTEREST_SUFFIX = "_int";
    private static final String CHANGE_FIELD = "changeField";
    private static final String CUSTOMTYPE = "customtype";
    private String ORGID = "orgid";
    private String TERM = "term";
    private String TERM_PREFIX = "term_";
    private String DATE_TYPE = "datetype";
    private Integer AVG_TERM = 999;

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List queryDateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet financeCostDataSet = FinanceCostDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)0L, (List)queryDateList);
        String dateRange = (String)reportQueryParam.getCustomParam().get("dateRange");
        dateRange = EmptyUtil.isEmpty((String)dateRange) ? "year" : dateRange;
        financeCostDataSet = financeCostDataSet.filter("customtype = '" + dateRange + "'");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        financeCostDataSet = FinanceCostDataHelper.getFinanceMergeDataSet((DataSet)financeCostDataSet, (DataSet)orgDateSet, (Long)orgId);
        financeCostDataSet = financeCostDataSet.updateFields(new String[]{AVGBALANCE, INTEREST}, new String[]{"avgbalance + rowoffset", "(avgbalance + rowoffset) * intrate / 100"});
        financeCostDataSet = financeCostDataSet.select(new String[]{this.ORGID, "currency", this.TERM, this.DATE_TYPE, "principle", "intrate", INTEREST, "daynum", "dayweight", AVGBALANCE, "begindate", "enddate", CUSTOMTYPE, "coloffset"});
        financeCostDataSet = this.dealTermDataSet(financeCostDataSet);
        return financeCostDataSet;
    }

    private DataSet processDataSet(DataSet orgDateSet, DataSet financeCostDataSet) {
        DataSet tempDataSet = financeCostDataSet;
        tempDataSet = tempDataSet.addField("concat(datetype, concat('_', concat(term, concat('_', customtype))))", CHANGE_FIELD);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(AVGBALANCE, "avg");
        map.put(INTEREST, "int");
        tempDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(tempDataSet, CHANGE_FIELD, this.ORGID, this.TERM_PREFIX, map);
        List<String> countFields = this.genFieldNames("change");
        tempDataSet = DecisionAnlsHelper.addAbsentFields(tempDataSet, countFields);
        DataSet leftJoinDs = orgDateSet.leftJoin(tempDataSet).on("rowid", this.ORGID).select(new String[]{this.ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, countFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, countFields, this.ORGID + "," + "mixorgname" + "," + "sortcode");
        sumDataSet = this.removeAllZeroRow(sumDataSet, new HashSet<String>(countFields));
        return sumDataSet;
    }

    private DataSet dealTermDataSet(DataSet financeCostDataSet) {
        final RowMeta rowMeta = financeCostDataSet.getRowMeta();
        return financeCostDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String term = row.getString(FinanceCostByTermDataListPlugin.this.TERM);
                int termIndex = rowMeta.getFieldIndex(FinanceCostByTermDataListPlugin.this.TERM, false);
                FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.matchExp((String)term);
                data[termIndex] = String.valueOf(financeCostTermEnum.getIndex());
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        long start = System.currentTimeMillis();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        DataSet allDataSet = ds.copy();
        allDataSet = allDataSet.updateFields(new String[]{AVGBALANCE, INTEREST}, new String[]{"avgbalance + coloffset", "(avgbalance + coloffset) * intrate / 100"});
        allDataSet = allDataSet.select(new String[]{this.ORGID, "currency", this.TERM, this.DATE_TYPE, "principle", "intrate", INTEREST, "daynum", "dayweight", AVGBALANCE, "begindate", "enddate", CUSTOMTYPE});
        DataSet cryDataSetAll = allDataSet.copy().groupBy(new String[]{this.DATE_TYPE, this.TERM, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish().addField("-1", this.ORGID);
        DataSet weightedAverageSetAll = allDataSet.groupBy(new String[]{this.DATE_TYPE, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish().select(new String[]{this.DATE_TYPE, "'" + this.AVG_TERM + "' as " + this.TERM, CUSTOMTYPE, AVGBALANCE, INTEREST}).addField("-1", this.ORGID);
        allDataSet = cryDataSetAll.union(weightedAverageSetAll);
        DataSet termDataSet = ds.copy().groupBy(new String[]{this.ORGID, this.DATE_TYPE, this.TERM, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish();
        DataSet weightedAverageSet = ds.groupBy(new String[]{this.ORGID, this.DATE_TYPE, CUSTOMTYPE}).sum(AVGBALANCE).sum(INTEREST).finish().select(new String[]{this.ORGID, this.DATE_TYPE, "'" + this.AVG_TERM + "' as " + this.TERM, CUSTOMTYPE, AVGBALANCE, INTEREST});
        ds = termDataSet.union(weightedAverageSet);
        List<String> countFields = this.genFieldNames("change");
        allDataSet = allDataSet.addField("concat(datetype, concat('_', concat(term, concat('_', customtype))))", CHANGE_FIELD);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(AVGBALANCE, "avg");
        map.put(INTEREST, "int");
        allDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(allDataSet, CHANGE_FIELD, this.ORGID, this.TERM_PREFIX, map);
        allDataSet = DecisionAnlsHelper.addAbsentFields(allDataSet, countFields).addFields(new String[]{"-1L", "-1L", "'0'", "1", "2", "'mixorgname'", "'1'"}, new String[]{"rowid", "pid", "isgroupnode", "level", "sumlevel", "mixorgname", "sortcode"});
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet processDataSet = this.processDataSet(orgDateSet, ds);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        DataSet filterDataSet = processDataSet;
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            filterDataSet = filterDataSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds));
        }
        filterDataSet = filterDataSet.orderBy(new String[]{"sortcode"});
        String[] fieldNames = filterDataSet.getRowMeta().getFieldNames();
        filterDataSet = filterDataSet.union(allDataSet.select(fieldNames));
        List<String> calcFieldNames = this.genFieldNames("calc");
        calcFieldNames.addAll(Arrays.asList(this.ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode", "sumlevel"));
        DataSet resultDataSet = filterDataSet.select(calcFieldNames.toArray(new String[0]));
        logger.info("\u878d\u8d44\u6210\u672c\u5206\u6790-\u6309\u671f\u9650\uff08\u533a\u95f4\uff09" + orgViewId + " \u5904\u7406\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        Map queryParamMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(queryParamMap);
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = DateRangeEnum.MONTH.getValue();
        }
        List<String> fieldNames = this.genFieldNames("target");
        String finalDateRange = dateRange;
        fieldNames = fieldNames.stream().filter(fieldname -> fieldname.endsWith(finalDateRange)).collect(Collectors.toList());
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        int diff = dateRangeEnum.getEnd() - dateRangeEnum.getStart();
        LinkedHashMap<String, ReportColumnGroup> groupMap = new LinkedHashMap<String, ReportColumnGroup>();
        for (String fieldName : fieldNames) {
            String[] fieldNameSplit = fieldName.split("_");
            String dateIndex = fieldNameSplit[1];
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)groupMap.get(this.TERM_PREFIX + dateIndex);
            if (reportColumnGroup == null) {
                reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setFieldKey(this.TERM_PREFIX + dateIndex);
                String caption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff--);
                reportColumnGroup.setCaption(new LocaleString(caption));
                groupMap.put(this.TERM_PREFIX + dateIndex, reportColumnGroup);
            }
            Integer termIndex = Integer.parseInt(fieldNameSplit[2]);
            FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.getEnumByIndex((Integer)termIndex);
            String description = financeCostTermEnum.getText().getDescription();
            String resourceID = financeCostTermEnum.getText().getResourceID();
            String columnCaption = ResManager.loadKDString((String)description, (String)resourceID, (String)financeCostTermEnum.getText().getSystemType(), (Object[])new Object[0]);
            if (this.AVG_TERM.equals(termIndex)) {
                columnCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostTermEnum_6", (String)financeCostTermEnum.getText().getSystemType(), (Object[])new Object[0]);
            }
            ReportColumn column = this.createColumn(fieldName, columnCaption);
            reportColumnGroup.getChildren().add(column);
        }
        groupMap.forEach((k, v) -> columns.add((AbstractReportColumn)v));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("text");
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    private List<String> genFieldNames(String fieldType) {
        ReportQueryParam queryParam = this.getQueryParam();
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        ArrayList<String> fieldNames = new ArrayList<String>(16);
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        for (int i = dateRangeEnum.getStart().intValue(); i <= dateRangeEnum.getEnd(); ++i) {
            for (FinanceCostTermEnum financeCostTermEnum : FinanceCostTermEnum.values()) {
                if (financeCostTermEnum == FinanceCostTermEnum.UNKNOWN) continue;
                this.getFields(fieldNames, i, financeCostTermEnum.getIndex(), dateRangeEnum.getValue(), fieldType);
            }
            this.getFields(fieldNames, i, this.AVG_TERM, dateRangeEnum.getValue(), fieldType);
        }
        return fieldNames;
    }

    private void getFields(List<String> fieldNames, int count, Integer financeCostTermEnumIndex, String dateRangeEnumValue, String fieldType) {
        switch (fieldType) {
            case "target": {
                fieldNames.add(this.TERM_PREFIX + count + "_" + financeCostTermEnumIndex + "_" + dateRangeEnumValue);
                break;
            }
            case "change": {
                fieldNames.add(this.TERM_PREFIX + count + "_" + financeCostTermEnumIndex + "_" + dateRangeEnumValue + AVGBALANCE_SUFFIX);
                fieldNames.add(this.TERM_PREFIX + count + "_" + financeCostTermEnumIndex + "_" + dateRangeEnumValue + INTEREST_SUFFIX);
                break;
            }
            case "calc": {
                String temp = this.TERM_PREFIX + count + "_" + financeCostTermEnumIndex + "_" + dateRangeEnumValue;
                String _int = temp + INTEREST_SUFFIX;
                String _avg = temp + AVGBALANCE_SUFFIX;
                String calcStr = "case when " + _avg + " = 0.0  or " + _avg + " is null then 0 else " + _int + " *1.0 / " + _avg + " end as " + temp;
                fieldNames.add(calcStr);
                break;
            }
        }
    }
}

