/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceTermDateHelper;

public class FinanceDebtByYearDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        ds = ds.filter("isequity=false");
        DataSet[] avgTermDs = this.dealDayNum(ds.copy(), orgDs.copy());
        ds = ds.select("isoutgroup,org orgid,term,repayamount drawamount,rowoffset,coloffset,0 termyearnumber");
        ds = ds.updateField("drawamount", "drawamount + rowoffset");
        ds = FinanceTermDateHelper.parseTerm(ds);
        DataSet yearDs = ds.groupBy(new String[]{"orgid", "isoutgroup", "termyearnumber"}).sum("drawamount").sum("coloffset").finish();
        DataSet[] dataSets = DataSetHelper.copy((DataSet)yearDs);
        yearDs = dataSets[0];
        DataSet allDs = this.groupby(dataSets[1]);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet colOffsetDs = yearDs.filter("coloffset < 0").updateFields(new String[]{"drawamount", "orgid"}, new String[]{"coloffset", ((DynamicObject)parentOrgs.get(0)).getString("id")});
        colOffsetDs = this.groupby(colOffsetDs);
        List<String> sumFields = this.getSumField();
        allDs = this.unionOrgInfo(allDs, orgDs, sumFields, JoinType.RIGHT);
        colOffsetDs = this.unionOrgInfo(colOffsetDs, orgDs, sumFields, JoinType.LEFT).updateFields(new String[]{"orgid", "isgroupnode", "mixorgname"}, new String[]{"-1", "'0'", ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"CashCateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])});
        colOffsetDs = colOffsetDs.addFields(new String[]{"0", "0", "0"}, new String[]{"avgterm", "inavgterm", "outavgterm"});
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode").filter("stat > 0").updateField("orgid", "rowid");
        String[] sumDataSetFields = sumDataSet.getRowMeta().getFieldNames();
        sumDataSet = sumDataSet.leftJoin(avgTermDs[0]).on("rowid", "rowid").select(sumDataSetFields, new String[]{"avgterm", "inavgterm", "outavgterm"}).finish();
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("orgid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : sumDataSet.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat > 0");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(colOffsetDs.select(sumDataSet.getRowMeta().getFieldNames())).addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        BigDecimal totalAvgTerm = BigDecimal.ZERO;
        BigDecimal totalInAvgTerm = BigDecimal.ZERO;
        BigDecimal totalOuntAvgTerm = BigDecimal.ZERO;
        DataSet otalAvgDs = avgTermDs[1];
        while (otalAvgDs.hasNext()) {
            Row totalRow = otalAvgDs.next();
            totalAvgTerm = totalRow.getBigDecimal("avgterm");
            totalInAvgTerm = totalRow.getBigDecimal("inavgterm");
            totalOuntAvgTerm = totalRow.getBigDecimal("outavgterm");
        }
        totalSet = totalSet.updateFields(new String[]{"avgterm", "inavgterm", "outavgterm"}, new String[]{totalAvgTerm.toPlainString(), totalInAvgTerm.toPlainString(), totalOuntAvgTerm.toPlainString()});
        return sumDataSet.union(totalSet);
    }

    private DataSet groupby(DataSet ds) {
        String sic = "orgid, isoutgroup,termyearnumber,drawamount,case when isoutgroup=0 and termyearnumber=1 then drawamount else 0 end as onein,case when isoutgroup=0 and termyearnumber=2 then drawamount else 0 end as twoin,case when isoutgroup=0 and termyearnumber=3 then drawamount else 0 end as threein,case when isoutgroup=0 and termyearnumber=4 then drawamount else 0 end as fourin,case when isoutgroup=0 and termyearnumber=5 then drawamount else 0 end as fivein,case when isoutgroup=0 and termyearnumber=6 then drawamount else 0 end as sixin,case when isoutgroup=0 then drawamount else 0 end as instat,case when isoutgroup=1 and termyearnumber=1 then drawamount else 0 end as oneout,case when isoutgroup=1 and termyearnumber=2 then drawamount else 0 end as twoout,case when isoutgroup=1 and termyearnumber=3 then drawamount else 0 end as threeout,case when isoutgroup=1 and termyearnumber=4 then drawamount else 0 end as fourout,case when isoutgroup=1 and termyearnumber=5 then drawamount else 0 end as fiveout,case when isoutgroup=1 and termyearnumber=6 then drawamount else 0 end as sixout,case when isoutgroup=1 then drawamount else 0 end as outstat,case when termyearnumber=1 then drawamount else 0 end as onestat,case when termyearnumber=2 then drawamount else 0 end as twostat,case when termyearnumber=3 then drawamount else 0 end as threestat,case when termyearnumber=4 then drawamount else 0 end as fourstat,case when termyearnumber=5 then drawamount else 0 end as fivestat,case when termyearnumber=6 then drawamount else 0 end as sixstat,drawamount as stat";
        ds = ds.select(sic);
        GroupbyDataSet groupbyDataSet = ds.groupBy(new String[]{"orgid"});
        List<String> sumFields = this.getSumField();
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    private DataSet unionOrgInfo(DataSet ds, DataSet orgDs, List<String> sumFields, JoinType joinType) {
        return ds.join(orgDs, joinType).on("orgid", "orgid").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(32);
        fields.addAll(this.getSumField());
        return fields;
    }

    private List<String> getSumField() {
        ArrayList<String> fields = new ArrayList<String>(22);
        fields.add("onein");
        fields.add("twoin");
        fields.add("threein");
        fields.add("fourin");
        fields.add("fivein");
        fields.add("sixin");
        fields.add("instat");
        fields.add("oneout");
        fields.add("twoout");
        fields.add("threeout");
        fields.add("fourout");
        fields.add("fiveout");
        fields.add("sixout");
        fields.add("outstat");
        fields.add("onestat");
        fields.add("twostat");
        fields.add("threestat");
        fields.add("fourstat");
        fields.add("fivestat");
        fields.add("sixstat");
        fields.add("stat");
        return fields;
    }

    private DataSet[] dealDayNum(DataSet detailData, DataSet orgDataSet) {
        detailData = detailData.addFields(new String[]{"0", "repayamount"}, new String[]{"days", "avgrepayamout"});
        final RowMeta rowMeta = detailData.getRowMeta();
        detailData = detailData.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                int days = 0;
                int daysIndex = rowMeta.getFieldIndex("days", false);
                Date startIntDate = row.getDate("startintdate");
                Date expiredDate = row.getDate("expiredate");
                days = EmptyUtil.isEmpty((Object)startIntDate) || EmptyUtil.isEmpty((Object)expiredDate) ? 0 : DateUtils.getDiffDays((Date)startIntDate, (Date)expiredDate);
                if (days <= 0) {
                    days = 1;
                }
                data[daysIndex] = days;
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        detailData = detailData.addField("days * avgrepayamout", "dmavgrepayamout");
        detailData = detailData.select("org,rowoffset,coloffset,perpetualbond,isoutgroup,dmavgrepayamout,avgrepayamout");
        detailData = detailData.select("org,rowoffset,coloffset,perpetualbond,dmavgrepayamout,avgrepayamout,case when isoutgroup=0 then dmavgrepayamout else 0 end as indmavgrepayamout,case when isoutgroup=0 then avgrepayamout else 0 end as inavgrepayamout,case when isoutgroup=1 then dmavgrepayamout else 0 end as outdmavgrepayamout,case when isoutgroup=1 then avgrepayamout else 0 end as outavgrepayamout");
        DataSet[] splitDataSet = detailData.splitByFilter(new String[]{"rowoffset = 0 and perpetualbond = false", "rowoffset = 0 and coloffset = 0 and perpetualbond = false"}, false);
        DataSet sumData = splitDataSet[0].groupBy(new String[]{"org"}).sum("dmavgrepayamout").sum("avgrepayamout").sum("indmavgrepayamout").sum("inavgrepayamout").sum("outdmavgrepayamout").sum("outavgrepayamout").finish();
        DataSet leftJoinSet = orgDataSet.leftJoin(sumData).on("org", "org").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname as org_name", "sortcode"}, sumData.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinSet, Arrays.asList("dmavgrepayamout", "avgrepayamout", "indmavgrepayamout", "inavgrepayamout", "outdmavgrepayamout", "outavgrepayamout"), "").select("rowid,case when avgrepayamout = 0 or avgrepayamout is null then 0 else dmavgrepayamout/(avgrepayamout*365) end as avgterm,case when inavgrepayamout = 0 or inavgrepayamout is null then 0 else indmavgrepayamout/(inavgrepayamout*365) end as inavgterm,case when outavgrepayamout = 0 or outavgrepayamout is null then 0 else outdmavgrepayamout/(outavgrepayamout*365) end as outavgterm ");
        DataSet total = splitDataSet[1].groupBy().sum("dmavgrepayamout").sum("avgrepayamout").sum("indmavgrepayamout").sum("inavgrepayamout").sum("outdmavgrepayamout").sum("outavgrepayamout").finish().select("case when avgrepayamout = 0 or avgrepayamout is null then 0 else dmavgrepayamout/(avgrepayamout*365) end as avgterm,case when inavgrepayamout = 0 or inavgrepayamout is null then 0 else indmavgrepayamout/(inavgrepayamout*365) end as inavgterm,case when outavgrepayamout = 0 or outavgrepayamout is null then 0 else outdmavgrepayamout/(outavgrepayamout*365) end as outavgterm ");
        return new DataSet[]{sumDataSet, total};
    }
}

