/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceEquityDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceEquityAnalDataHelper;

public class FinanceEquityAnalDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String BEGINYEAR = "beginyear";
    private static final String GROUPCOL = "groupcol";
    private static final String LASTMONTH = "lastmonth";
    private static final String PERCENTAGE = "percentage";
    private static final String LYPERCENTAGE = "lypercentage";

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Date lastYearDate;
        String lastYearDateString;
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        boolean haveSameDate = false;
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String queryDateString = DateUtils.formatString((Date)queryDate, (String)"yyyyMMdd");
        Date lastMonthDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-1);
        String lastMonthDateString = DateUtils.formatString((Date)lastMonthDate, (String)"yyyyMMdd");
        Date lastYearSameDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-12);
        String lastYearSameDateString = DateUtils.formatString((Date)lastYearSameDate, (String)"yyyyMMdd");
        if (lastYearSameDateString.equals(lastYearDateString = DateUtils.formatString((Date)(lastYearDate = DateUtils.getLastYearDate((Date)lastYearSameDate)), (String)"yyyyMMdd")) || lastMonthDateString.equals(lastYearDateString)) {
            haveSameDate = true;
        }
        ArrayList<String> dateStringFields = new ArrayList<String>(4);
        if (haveSameDate) {
            Collections.addAll(dateStringFields, queryDateString, lastMonthDateString, lastYearSameDateString);
        } else {
            Collections.addAll(dateStringFields, queryDateString, lastMonthDateString, lastYearSameDateString, lastYearDateString);
        }
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet queryDateResult = FinanceEquityDataHelper.getFinanceDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryDate"), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        DataSet[] splitDataSet = queryDateResult.splitByFilter(new String[]{"datestring = '" + queryDateString + "'", "true"}, false);
        DataSet averageDataSet = splitDataSet[0];
        averageDataSet = averageDataSet.filter("firstredeemdate is not null").addField("DATEDIF(bizdate,firstredeemdate,'D')*1.0/365", "difyears").addField("repayamount*difyears", "redeem").select("org,repayamount,redeem");
        averageDataSet = averageDataSet.groupBy(new String[]{"org"}).sum("repayamount").sum("redeem").finish();
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet averageJoinDataSet = orgDateSet.leftJoin(averageDataSet).on("rowid", "org").select("rowid,orgid,pid,isgroupnode,level,0 sumlevel,repayamount,redeem".split(",")).finish();
        DataSet averageResult = DecisionAnlsHelper.getSumDataSetByLevel(averageJoinDataSet, Arrays.asList("redeem", "repayamount"), "orgid");
        averageResult = averageResult.addField("redeem/repayamount", "avgredeem");
        DataSet result = FinanceEquityAnalDataHelper.dealRow(dateStringFields, orgViewId, splitDataSet[1]);
        result = result.addFields(new String[]{"datestring_" + queryDateString + "repayamount", "datestring_" + queryDateString + "repayamount" + " - " + "datestring_" + lastYearDateString + "repayamount", "datestring_" + queryDateString + "repayamount" + " - " + "datestring_" + lastMonthDateString + "repayamount", "datestring_" + queryDateString + "percent", "datestring_" + lastYearSameDateString + "percent"}, new String[]{"repayamount", BEGINYEAR, LASTMONTH, PERCENTAGE, LYPERCENTAGE});
        String[] leftFieldNames = result.getRowMeta().getFieldNames();
        String[] rightFieldName = new String[]{"avgredeem"};
        result = result.leftJoin(averageResult).on("rowid", "orgid").select(leftFieldNames, rightFieldName).finish();
        return result;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        DataSet[] splitDataSets = ds.splitByFilter(new String[]{"rowid =" + ((DynamicObject)paramMap.get("org")).getLong("id")}, true);
        DataSet totalAvgRedeem = splitDataSets[0];
        BigDecimal totalAbgRedeemSum = BigDecimal.ZERO;
        BigDecimal totalPercenage = BigDecimal.ZERO;
        BigDecimal totalLyPercenage = BigDecimal.ZERO;
        if (!totalAvgRedeem.isEmpty() && totalAvgRedeem.hasNext()) {
            Row totalAvgRedeemRow = totalAvgRedeem.next();
            totalAbgRedeemSum = totalAvgRedeemRow.getBigDecimal("avgredeem");
            totalPercenage = totalAvgRedeemRow.getBigDecimal(PERCENTAGE);
            totalLyPercenage = totalAvgRedeemRow.getBigDecimal(LYPERCENTAGE);
        }
        ds = splitDataSets[1];
        if (CollectionUtils.isNotEmpty((Collection)filterOrg)) {
            ds = ds.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", filterOrg));
        }
        ds = ds.addField("'groupcol'", GROUPCOL);
        DataSet totalSet = this.addSubTotalDataSet(ds, Collections.singletonList(GROUPCOL), Arrays.asList("repayamount", BEGINYEAR, LASTMONTH, PERCENTAGE, LYPERCENTAGE), "mixorgname").updateField("mixorgname", ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"FinanceEquityAnalDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        if (totalAbgRedeemSum != null) {
            totalSet = totalSet.updateField("avgredeem", totalAbgRedeemSum.toPlainString());
        }
        if (totalPercenage != null) {
            totalSet = totalSet.updateField(PERCENTAGE, totalPercenage.toPlainString());
        }
        if (totalLyPercenage != null) {
            totalSet = totalSet.updateField(LYPERCENTAGE, totalLyPercenage.toPlainString());
        }
        return ds.orderBy(new String[]{"sortcode"}).union(totalSet);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("repayamount");
        fields.add(BEGINYEAR);
        fields.add(LASTMONTH);
        return fields;
    }
}

