/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceFormByDirectDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private String DIRECT = "direct";
    private static String FINANCE_MODE = "financemode";
    private static String FINANCE_PRODUCT = "finproduct";
    private static String REPAY_AMOUNT = "repayamount";
    private static String IS_OUT_GROUP = "isoutgroup";
    private static String UN_EQUITY = "isequity = false";
    private static String GROUP_FORM = "group_mode";
    private static String TOTAL = "total";
    private List<String> COUNT_FIELDS = new ArrayList<String>();
    private static String PRODUCT_PREFIX = "product_";
    private static String IN_GROUP_SUFFIX = "_0";
    private static String OUT_GROUP_SUFFIX = "_1";
    private static String OUT_GROUP_TOTAL = PRODUCT_PREFIX + TOTAL + OUT_GROUP_SUFFIX;
    private static String IN_GROUP_TOTAL = PRODUCT_PREFIX + TOTAL + IN_GROUP_SUFFIX;

    protected String getFinanceForm() {
        return this.DIRECT;
    }

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        String financeForm = this.DIRECT.equals(this.getFinanceForm()) ? "1" : "0";
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet query = FinanceDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        return query.filter(UN_EQUITY).filter(FINANCE_MODE + "=" + financeForm).select(new String[]{"org", IS_OUT_GROUP, FINANCE_PRODUCT, REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        List inGroupFields;
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        dataSet = dataSet.groupBy(new String[]{"org", IS_OUT_GROUP, FINANCE_PRODUCT}).sum(REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet interestSet = dataSets[0].select(new String[]{"org", REPAY_AMOUNT + "+" + MergeOffsetHandler.ROW_OFFSETFILENAME + " as " + "count", "concat(finproduct, concat('_',isoutgroup)) as group_mode"});
        interestSet = DecisionAnlsHelper.ChangeRowToColDataSet(interestSet, GROUP_FORM, "org", PRODUCT_PREFIX);
        interestSet = orgDateSet.leftJoin(interestSet).on("org", "org").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, interestSet.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        interestSet = DecisionAnlsHelper.getSumDataSetByLevel(interestSet, this.getCountFields(interestSet), "mixorgname,sortcode");
        this.COUNT_FIELDS.clear();
        ArrayList<String> totalFields = new ArrayList<String>(2);
        List outGroupFields = this.getCountFields(interestSet).stream().filter(s -> s.endsWith(OUT_GROUP_SUFFIX)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outGroupFields)) {
            interestSet = interestSet.addField(String.join((CharSequence)"+", outGroupFields), OUT_GROUP_TOTAL);
            totalFields.add(OUT_GROUP_TOTAL);
        }
        if (CollectionUtils.isNotEmpty(inGroupFields = this.getCountFields(interestSet).stream().filter(s -> s.endsWith(IN_GROUP_SUFFIX)).collect(Collectors.toList()))) {
            interestSet = interestSet.addField(String.join((CharSequence)"+", inGroupFields), IN_GROUP_TOTAL);
            totalFields.add(IN_GROUP_TOTAL);
        }
        String totalValue = totalFields.size() == 0 ? "0" : (totalFields.size() == 1 ? (String)totalFields.get(0) : String.join((CharSequence)"+", totalFields));
        interestSet = interestSet.addField(totalValue, TOTAL);
        this.COUNT_FIELDS = this.getCountFields(interestSet);
        this.COUNT_FIELDS.add(TOTAL);
        DataSet colOffsetSet = this.getColOffsetSet(dataSets[1], orgId, interestSet);
        DataSet result = interestSet.orderBy(new String[]{"sortcode"}).union(colOffsetSet);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            subOrgIds.add(0L);
            result = result.where("rowid in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(result, this.COUNT_FIELDS, "mixorgname");
        result = result.union(totalDataSet);
        return result.addField("mixorgname", "org_name").addField("rowid", "orgid");
    }

    private DataSet getColOffsetSet(DataSet dataSet, Long orgId, DataSet interestSet) {
        dataSet = dataSet.filter(IS_OUT_GROUP + " = 0 AND org != " + orgId).updateField("org", "0L").groupBy(new String[]{"org", IS_OUT_GROUP, FINANCE_PRODUCT}).sum(MergeOffsetHandler.COL_OFFSETFILENAME, "count").finish().select(new String[]{"org", "count", "concat(finproduct, concat('_',isoutgroup)) as group_mode"});
        dataSet = DecisionAnlsHelper.ChangeRowToColDataSet(dataSet, GROUP_FORM, "org", PRODUCT_PREFIX);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        Iterator iterator = dataSet.iterator();
        DataSet colOffsetSet = DecisionAnlsHelper.createRowByDefault(interestSet.getRowMeta().getFieldNames(), interestSet.getRowMeta().getDataTypes());
        if (iterator.hasNext()) {
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashDistributionByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
            BigDecimal totalOffset = BigDecimal.ZERO;
            Row next = (Row)iterator.next();
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                if ("org".equals(fieldName)) continue;
                BigDecimal value = Objects.nonNull(next.getBigDecimal(fieldName)) ? next.getBigDecimal(fieldName) : BigDecimal.ZERO;
                totalOffset = totalOffset.add(value);
                valueMap.put(fieldNames[i], value.toPlainString());
            }
            valueMap.put("mixorgname", "'" + offsetName + "'");
            valueMap.put(IN_GROUP_TOTAL, totalOffset.toPlainString());
            valueMap.put(TOTAL, totalOffset.toPlainString());
            colOffsetSet = colOffsetSet.updateFields(valueMap.keySet().toArray(new String[0]), valueMap.values().toArray(new String[0]));
        }
        return colOffsetSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.COUNT_FIELDS);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map productsMap = BusinessDataServiceHelper.loadFromCache((String)"cfm_financingvarieties", (String)String.join((CharSequence)",", "id", "name"), null);
        ReportColumnGroup groupOutGroup = new ReportColumnGroup();
        groupOutGroup.setFieldKey("groupout");
        groupOutGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u96c6\u56e2\u5916\u6709\u606f\u8d1f\u503a", (String)"FinanceFormByDirectDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)groupOutGroup);
        ReportColumnGroup groupInGroup = new ReportColumnGroup();
        groupInGroup.setFieldKey("groupin");
        groupInGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u6709\u606f\u8d1f\u503a", (String)"FinanceFormByDirectDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)groupInGroup);
        this.COUNT_FIELDS.stream().forEach(fieldName -> {
            if (fieldName.startsWith(PRODUCT_PREFIX)) {
                String productName = "";
                if (fieldName.contains(TOTAL)) {
                    productName = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"FinanceFormByDirectDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
                } else {
                    String[] names = fieldName.split("_");
                    Long productId = Long.valueOf(names[1]);
                    if (productId.equals(0L)) {
                        productName = ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"FinanceFormByDirectDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
                    } else {
                        DynamicObject product = (DynamicObject)productsMap.get(productId);
                        if (Objects.nonNull(product)) {
                            productName = product.getString("name");
                        }
                    }
                }
                if (fieldName.endsWith("1")) {
                    groupOutGroup.getChildren().add(this.createColumn((String)fieldName, productName));
                } else {
                    groupInGroup.getChildren().add(this.createColumn((String)fieldName, productName));
                }
            }
        });
        columns.add((AbstractReportColumn)this.createColumn(TOTAL, ResManager.loadKDString((String)"\u6709\u606f\u8d1f\u503a\u5408\u8ba1", (String)"FinanceFormByDirectDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        reportColumn.setHideSingleColumnRow(false);
        return reportColumn;
    }

    public List<String> getCountFields(DataSet dataSet) {
        return Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(PRODUCT_PREFIX)).sorted(Comparator.comparing(fieldName -> fieldName.substring(fieldName.length() - 1))).collect(Collectors.toList());
    }
}

